/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.telemetry.ConnectorNamespace;

public class HostProperties {
    private boolean isLocalhost;
    private String ipmitoolCommand;
    private int ipmiExecutionCount;
    private Set<String> possibleWmiNamespaces;
    private Set<String> possibleWbemNamespaces;
    private String vCenterTicket;
    private boolean osCommandExecutesLocally;
    private boolean osCommandExecutesRemotely;
    private boolean mustCheckSshStatus;
    private Map<String, ConnectorNamespace> connectorNamespaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorNamespace getConnectorNamespace(@NonNull String connectorId) {
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        Map<String, ConnectorNamespace> map = this.connectorNamespaces;
        synchronized (map) {
            return this.connectorNamespaces.computeIfAbsent(connectorId, cn -> ConnectorNamespace.builder().build());
        }
    }

    @Generated
    private static Set<String> $default$possibleWmiNamespaces() {
        return new TreeSet<String>();
    }

    @Generated
    private static Set<String> $default$possibleWbemNamespaces() {
        return new TreeSet<String>();
    }

    @Generated
    private static Map<String, ConnectorNamespace> $default$connectorNamespaces() {
        return new HashMap<String, ConnectorNamespace>();
    }

    @Generated
    public static HostPropertiesBuilder builder() {
        return new HostPropertiesBuilder();
    }

    @Generated
    public boolean isLocalhost() {
        return this.isLocalhost;
    }

    @Generated
    public String getIpmitoolCommand() {
        return this.ipmitoolCommand;
    }

    @Generated
    public int getIpmiExecutionCount() {
        return this.ipmiExecutionCount;
    }

    @Generated
    public Set<String> getPossibleWmiNamespaces() {
        return this.possibleWmiNamespaces;
    }

    @Generated
    public Set<String> getPossibleWbemNamespaces() {
        return this.possibleWbemNamespaces;
    }

    @Generated
    public String getVCenterTicket() {
        return this.vCenterTicket;
    }

    @Generated
    public boolean isOsCommandExecutesLocally() {
        return this.osCommandExecutesLocally;
    }

    @Generated
    public boolean isOsCommandExecutesRemotely() {
        return this.osCommandExecutesRemotely;
    }

    @Generated
    public boolean isMustCheckSshStatus() {
        return this.mustCheckSshStatus;
    }

    @Generated
    public Map<String, ConnectorNamespace> getConnectorNamespaces() {
        return this.connectorNamespaces;
    }

    @Generated
    public void setLocalhost(boolean isLocalhost) {
        this.isLocalhost = isLocalhost;
    }

    @Generated
    public void setIpmitoolCommand(String ipmitoolCommand) {
        this.ipmitoolCommand = ipmitoolCommand;
    }

    @Generated
    public void setIpmiExecutionCount(int ipmiExecutionCount) {
        this.ipmiExecutionCount = ipmiExecutionCount;
    }

    @Generated
    public void setPossibleWmiNamespaces(Set<String> possibleWmiNamespaces) {
        this.possibleWmiNamespaces = possibleWmiNamespaces;
    }

    @Generated
    public void setPossibleWbemNamespaces(Set<String> possibleWbemNamespaces) {
        this.possibleWbemNamespaces = possibleWbemNamespaces;
    }

    @Generated
    public void setVCenterTicket(String vCenterTicket) {
        this.vCenterTicket = vCenterTicket;
    }

    @Generated
    public void setOsCommandExecutesLocally(boolean osCommandExecutesLocally) {
        this.osCommandExecutesLocally = osCommandExecutesLocally;
    }

    @Generated
    public void setOsCommandExecutesRemotely(boolean osCommandExecutesRemotely) {
        this.osCommandExecutesRemotely = osCommandExecutesRemotely;
    }

    @Generated
    public void setMustCheckSshStatus(boolean mustCheckSshStatus) {
        this.mustCheckSshStatus = mustCheckSshStatus;
    }

    @Generated
    public void setConnectorNamespaces(Map<String, ConnectorNamespace> connectorNamespaces) {
        this.connectorNamespaces = connectorNamespaces;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostProperties)) {
            return false;
        }
        HostProperties other = (HostProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLocalhost() != other.isLocalhost()) {
            return false;
        }
        if (this.getIpmiExecutionCount() != other.getIpmiExecutionCount()) {
            return false;
        }
        if (this.isOsCommandExecutesLocally() != other.isOsCommandExecutesLocally()) {
            return false;
        }
        if (this.isOsCommandExecutesRemotely() != other.isOsCommandExecutesRemotely()) {
            return false;
        }
        if (this.isMustCheckSshStatus() != other.isMustCheckSshStatus()) {
            return false;
        }
        String this$ipmitoolCommand = this.getIpmitoolCommand();
        String other$ipmitoolCommand = other.getIpmitoolCommand();
        if (this$ipmitoolCommand == null ? other$ipmitoolCommand != null : !this$ipmitoolCommand.equals(other$ipmitoolCommand)) {
            return false;
        }
        Set<String> this$possibleWmiNamespaces = this.getPossibleWmiNamespaces();
        Set<String> other$possibleWmiNamespaces = other.getPossibleWmiNamespaces();
        if (this$possibleWmiNamespaces == null ? other$possibleWmiNamespaces != null : !((Object)this$possibleWmiNamespaces).equals(other$possibleWmiNamespaces)) {
            return false;
        }
        Set<String> this$possibleWbemNamespaces = this.getPossibleWbemNamespaces();
        Set<String> other$possibleWbemNamespaces = other.getPossibleWbemNamespaces();
        if (this$possibleWbemNamespaces == null ? other$possibleWbemNamespaces != null : !((Object)this$possibleWbemNamespaces).equals(other$possibleWbemNamespaces)) {
            return false;
        }
        String this$vCenterTicket = this.getVCenterTicket();
        String other$vCenterTicket = other.getVCenterTicket();
        if (this$vCenterTicket == null ? other$vCenterTicket != null : !this$vCenterTicket.equals(other$vCenterTicket)) {
            return false;
        }
        Map<String, ConnectorNamespace> this$connectorNamespaces = this.getConnectorNamespaces();
        Map<String, ConnectorNamespace> other$connectorNamespaces = other.getConnectorNamespaces();
        return !(this$connectorNamespaces == null ? other$connectorNamespaces != null : !((Object)this$connectorNamespaces).equals(other$connectorNamespaces));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLocalhost() ? 79 : 97);
        result = result * 59 + this.getIpmiExecutionCount();
        result = result * 59 + (this.isOsCommandExecutesLocally() ? 79 : 97);
        result = result * 59 + (this.isOsCommandExecutesRemotely() ? 79 : 97);
        result = result * 59 + (this.isMustCheckSshStatus() ? 79 : 97);
        String $ipmitoolCommand = this.getIpmitoolCommand();
        result = result * 59 + ($ipmitoolCommand == null ? 43 : $ipmitoolCommand.hashCode());
        Set<String> $possibleWmiNamespaces = this.getPossibleWmiNamespaces();
        result = result * 59 + ($possibleWmiNamespaces == null ? 43 : ((Object)$possibleWmiNamespaces).hashCode());
        Set<String> $possibleWbemNamespaces = this.getPossibleWbemNamespaces();
        result = result * 59 + ($possibleWbemNamespaces == null ? 43 : ((Object)$possibleWbemNamespaces).hashCode());
        String $vCenterTicket = this.getVCenterTicket();
        result = result * 59 + ($vCenterTicket == null ? 43 : $vCenterTicket.hashCode());
        Map<String, ConnectorNamespace> $connectorNamespaces = this.getConnectorNamespaces();
        result = result * 59 + ($connectorNamespaces == null ? 43 : ((Object)$connectorNamespaces).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostProperties(isLocalhost=" + this.isLocalhost() + ", ipmitoolCommand=" + this.getIpmitoolCommand() + ", ipmiExecutionCount=" + this.getIpmiExecutionCount() + ", possibleWmiNamespaces=" + String.valueOf(this.getPossibleWmiNamespaces()) + ", possibleWbemNamespaces=" + String.valueOf(this.getPossibleWbemNamespaces()) + ", vCenterTicket=" + this.getVCenterTicket() + ", osCommandExecutesLocally=" + this.isOsCommandExecutesLocally() + ", osCommandExecutesRemotely=" + this.isOsCommandExecutesRemotely() + ", mustCheckSshStatus=" + this.isMustCheckSshStatus() + ", connectorNamespaces=" + String.valueOf(this.getConnectorNamespaces()) + ")";
    }

    @Generated
    public HostProperties(boolean isLocalhost, String ipmitoolCommand, int ipmiExecutionCount, Set<String> possibleWmiNamespaces, Set<String> possibleWbemNamespaces, String vCenterTicket, boolean osCommandExecutesLocally, boolean osCommandExecutesRemotely, boolean mustCheckSshStatus, Map<String, ConnectorNamespace> connectorNamespaces) {
        this.isLocalhost = isLocalhost;
        this.ipmitoolCommand = ipmitoolCommand;
        this.ipmiExecutionCount = ipmiExecutionCount;
        this.possibleWmiNamespaces = possibleWmiNamespaces;
        this.possibleWbemNamespaces = possibleWbemNamespaces;
        this.vCenterTicket = vCenterTicket;
        this.osCommandExecutesLocally = osCommandExecutesLocally;
        this.osCommandExecutesRemotely = osCommandExecutesRemotely;
        this.mustCheckSshStatus = mustCheckSshStatus;
        this.connectorNamespaces = connectorNamespaces;
    }

    @Generated
    public HostProperties() {
        this.possibleWmiNamespaces = HostProperties.$default$possibleWmiNamespaces();
        this.possibleWbemNamespaces = HostProperties.$default$possibleWbemNamespaces();
        this.connectorNamespaces = HostProperties.$default$connectorNamespaces();
    }

    @Generated
    public static class HostPropertiesBuilder {
        @Generated
        private boolean isLocalhost;
        @Generated
        private String ipmitoolCommand;
        @Generated
        private int ipmiExecutionCount;
        @Generated
        private boolean possibleWmiNamespaces$set;
        @Generated
        private Set<String> possibleWmiNamespaces$value;
        @Generated
        private boolean possibleWbemNamespaces$set;
        @Generated
        private Set<String> possibleWbemNamespaces$value;
        @Generated
        private String vCenterTicket;
        @Generated
        private boolean osCommandExecutesLocally;
        @Generated
        private boolean osCommandExecutesRemotely;
        @Generated
        private boolean mustCheckSshStatus;
        @Generated
        private boolean connectorNamespaces$set;
        @Generated
        private Map<String, ConnectorNamespace> connectorNamespaces$value;

        @Generated
        HostPropertiesBuilder() {
        }

        @Generated
        public HostPropertiesBuilder isLocalhost(boolean isLocalhost) {
            this.isLocalhost = isLocalhost;
            return this;
        }

        @Generated
        public HostPropertiesBuilder ipmitoolCommand(String ipmitoolCommand) {
            this.ipmitoolCommand = ipmitoolCommand;
            return this;
        }

        @Generated
        public HostPropertiesBuilder ipmiExecutionCount(int ipmiExecutionCount) {
            this.ipmiExecutionCount = ipmiExecutionCount;
            return this;
        }

        @Generated
        public HostPropertiesBuilder possibleWmiNamespaces(Set<String> possibleWmiNamespaces) {
            this.possibleWmiNamespaces$value = possibleWmiNamespaces;
            this.possibleWmiNamespaces$set = true;
            return this;
        }

        @Generated
        public HostPropertiesBuilder possibleWbemNamespaces(Set<String> possibleWbemNamespaces) {
            this.possibleWbemNamespaces$value = possibleWbemNamespaces;
            this.possibleWbemNamespaces$set = true;
            return this;
        }

        @Generated
        public HostPropertiesBuilder vCenterTicket(String vCenterTicket) {
            this.vCenterTicket = vCenterTicket;
            return this;
        }

        @Generated
        public HostPropertiesBuilder osCommandExecutesLocally(boolean osCommandExecutesLocally) {
            this.osCommandExecutesLocally = osCommandExecutesLocally;
            return this;
        }

        @Generated
        public HostPropertiesBuilder osCommandExecutesRemotely(boolean osCommandExecutesRemotely) {
            this.osCommandExecutesRemotely = osCommandExecutesRemotely;
            return this;
        }

        @Generated
        public HostPropertiesBuilder mustCheckSshStatus(boolean mustCheckSshStatus) {
            this.mustCheckSshStatus = mustCheckSshStatus;
            return this;
        }

        @Generated
        public HostPropertiesBuilder connectorNamespaces(Map<String, ConnectorNamespace> connectorNamespaces) {
            this.connectorNamespaces$value = connectorNamespaces;
            this.connectorNamespaces$set = true;
            return this;
        }

        @Generated
        public HostProperties build() {
            Set<String> possibleWmiNamespaces$value = this.possibleWmiNamespaces$value;
            if (!this.possibleWmiNamespaces$set) {
                possibleWmiNamespaces$value = HostProperties.$default$possibleWmiNamespaces();
            }
            Set<String> possibleWbemNamespaces$value = this.possibleWbemNamespaces$value;
            if (!this.possibleWbemNamespaces$set) {
                possibleWbemNamespaces$value = HostProperties.$default$possibleWbemNamespaces();
            }
            Map<String, ConnectorNamespace> connectorNamespaces$value = this.connectorNamespaces$value;
            if (!this.connectorNamespaces$set) {
                connectorNamespaces$value = HostProperties.$default$connectorNamespaces();
            }
            return new HostProperties(this.isLocalhost, this.ipmitoolCommand, this.ipmiExecutionCount, possibleWmiNamespaces$value, possibleWbemNamespaces$value, this.vCenterTicket, this.osCommandExecutesLocally, this.osCommandExecutesRemotely, this.mustCheckSshStatus, connectorNamespaces$value);
        }

        @Generated
        public String toString() {
            return "HostProperties.HostPropertiesBuilder(isLocalhost=" + this.isLocalhost + ", ipmitoolCommand=" + this.ipmitoolCommand + ", ipmiExecutionCount=" + this.ipmiExecutionCount + ", possibleWmiNamespaces$value=" + String.valueOf(this.possibleWmiNamespaces$value) + ", possibleWbemNamespaces$value=" + String.valueOf(this.possibleWbemNamespaces$value) + ", vCenterTicket=" + this.vCenterTicket + ", osCommandExecutesLocally=" + this.osCommandExecutesLocally + ", osCommandExecutesRemotely=" + this.osCommandExecutesRemotely + ", mustCheckSshStatus=" + this.mustCheckSshStatus + ", connectorNamespaces$value=" + String.valueOf(this.connectorNamespaces$value) + ")";
        }
    }
}

