/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.strategy.utils.SudoInformation;
import org.springframework.util.Assert;

public class OsCommandHelper {
    private static final Pattern SUDO_COMMAND_PATTERN = Pattern.compile("%\\{SUDO:([^\\}]*)\\}", 2);
    public static final BiFunction<String, String, File> TEMP_FILE_CREATOR = OsCommandHelper::createEmbeddedTempFile;

    public static Map<String, File> createOsCommandEmbeddedFiles(@NonNull String commandLine, SudoInformation sudoInformation, @NonNull Map<Integer, EmbeddedFile> commandLineEmbeddedFiles, @NonNull BiFunction<String, String, File> tempFileCreator) throws IOException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (commandLineEmbeddedFiles == null) {
            throw new IllegalArgumentException("commandLineEmbeddedFiles is marked non-null but is null");
        }
        if (tempFileCreator == null) {
            throw new IllegalArgumentException("tempFileCreator is marked non-null but is null");
        }
        HashMap<String, File> embeddedTempFiles = new HashMap<String, File>();
        try {
            Matcher matcher = MetricsHubConstants.FILE_PATTERN.matcher(commandLine);
            while (matcher.find()) {
                Integer fileNumber = Integer.parseInt(matcher.group(1));
                String fileNameRef = matcher.group();
                embeddedTempFiles.computeIfAbsent(fileNameRef, k -> {
                    EmbeddedFile embeddedFile = (EmbeddedFile)commandLineEmbeddedFiles.get(fileNumber);
                    Assert.state((embeddedFile != null ? 1 : 0) != 0, () -> "Cannot get the EmbeddedFile from the Connector. File name: " + fileNumber);
                    byte[] content = embeddedFile.getContent();
                    Assert.state((content != null ? 1 : 0) != 0, () -> "EmbeddedFile content is null. File name: " + fileNumber);
                    try {
                        return OsCommandHelper.createTempFileWithEmbeddedFileContent(embeddedFile, sudoInformation, tempFileCreator);
                    }
                    catch (IOException e) {
                        throw new TempFileCreationException(e);
                    }
                });
            }
            return Collections.unmodifiableMap(embeddedTempFiles);
        }
        catch (Exception e) {
            embeddedTempFiles.values().forEach(File::delete);
            if (e instanceof TempFileCreationException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static File createTempFileWithEmbeddedFileContent(EmbeddedFile embeddedFile, SudoInformation sudoInformation, BiFunction<String, String, File> tempFileCreator) throws IOException {
        String extension = embeddedFile.getFileExtension();
        String baseName = embeddedFile.getBaseName();
        File tempFile = tempFileCreator.apply(baseName, extension);
        Path tempFilePath = Paths.get(tempFile.getAbsolutePath(), new String[0]);
        String contentAsString = embeddedFile.getContentAsString();
        if (contentAsString.contains("%{SUDO:")) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(tempFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(OsCommandHelper.replaceSudo(contentAsString, sudoInformation));
            }
        } else {
            Files.write(tempFilePath, embeddedFile.getContent(), new OpenOption[0]);
        }
        return tempFile;
    }

    public static File createEmbeddedTempFile(String baseName, String extension) {
        try {
            return File.createTempFile("metricshub_embedded_" + baseName, extension);
        }
        catch (IOException e) {
            throw new TempFileCreationException(e);
        }
    }

    public static String replaceSudo(String text, SudoInformation sudoInformation) {
        if (text == null || text.isBlank()) {
            return text;
        }
        Optional<String> maybeSudoFile = OsCommandHelper.getFileNameFromSudoCommand(text);
        String sudoReplace = maybeSudoFile.isPresent() && sudoInformation != null && sudoInformation.isUseSudo() && sudoInformation.useSudoCommands().contains(maybeSudoFile.get()) ? sudoInformation.sudoCommand() : "";
        return maybeSudoFile.map(fileName -> text.replaceAll(StringHelper.protectCaseInsensitiveRegex(String.format("%%{SUDO:%s}", fileName)), sudoReplace)).orElse(text);
    }

    public static Optional<String> getFileNameFromSudoCommand(@NonNull String command) {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        Matcher matcher = SUDO_COMMAND_PATTERN.matcher(command);
        return matcher.find() ? Optional.ofNullable(matcher.group(1)) : Optional.empty();
    }

    @Generated
    private OsCommandHelper() {
    }

    static class TempFileCreationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TempFileCreationException(IOException cause) {
            super(cause);
        }
    }
}

