/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorIdentity;
import org.sentrysoftware.metricshub.engine.connector.model.identity.Detection;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.SimpleMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.StandardMonitorJob;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorTestResult;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionProcessor;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.ForceSerializationHelper;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectorProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectorProcessor.class);
    @NonNull
    protected TelemetryManager telemetryManager;
    @NonNull
    protected ClientsExecutor clientsExecutor;
    @NonNull
    protected Set<String> connectorIds;
    @NonNull
    protected ExtensionManager extensionManager;

    public abstract List<ConnectorTestResult> run();

    public Stream<ConnectorTestResult> runAllConnectorsDetectionCriteria(@NonNull Stream<Connector> connectors, @NonNull HostConfiguration hostConfiguration) {
        if (connectors == null) {
            throw new IllegalArgumentException("connectors is marked non-null but is null");
        }
        if (hostConfiguration == null) {
            throw new IllegalArgumentException("hostConfiguration is marked non-null but is null");
        }
        String hostname = hostConfiguration.getHostname();
        return (hostConfiguration.isSequential() ? this.runConnectorsSequentially(connectors, hostname) : this.runConnectorsSimultaneously(connectors, hostname)).stream();
    }

    private List<ConnectorTestResult> runConnectorsSequentially(@NonNull Stream<Connector> connectors, @NonNull String hostname) {
        if (connectors == null) {
            throw new IllegalArgumentException("connectors is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        ArrayList<ConnectorTestResult> connectorTestResults = new ArrayList<ConnectorTestResult>();
        connectors.forEach(connector -> connectorTestResults.add(this.runConnectorDetectionCriteria((Connector)connector, hostname)));
        return connectorTestResults;
    }

    private List<ConnectorTestResult> runConnectorsSimultaneously(@NonNull Stream<Connector> connectors, @NonNull String hostname) {
        if (connectors == null) {
            throw new IllegalArgumentException("connectors is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        ArrayList<ConnectorTestResult> connectorTestResults = new ArrayList<ConnectorTestResult>();
        List connectorTestResultsSynchronized = Collections.synchronizedList(connectorTestResults);
        ExecutorService threadsPool = Executors.newFixedThreadPool(50);
        connectors.forEach(connector -> threadsPool.execute(() -> connectorTestResultsSynchronized.add(this.runConnectorDetectionCriteria((Connector)connector, hostname))));
        threadsPool.shutdown();
        try {
            threadsPool.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("Hostname {} - Exception encountered while running connectors simultaneously.", (Object)hostname);
            log.debug("Hostname {} - Exception: ", (Object)hostname, (Object)e);
        }
        return connectorTestResults;
    }

    void updateSupersedes(@NonNull Set<String> supersedes, @NonNull ConnectorTestResult connectorTestResult) {
        if (supersedes == null) {
            throw new IllegalArgumentException("supersedes is marked non-null but is null");
        }
        if (connectorTestResult == null) {
            throw new IllegalArgumentException("connectorTestResult is marked non-null but is null");
        }
        Set<String> connectorSupersedes = connectorTestResult.getConnector().getConnectorIdentity().getDetection().getSupersedes();
        if (connectorSupersedes == null || connectorSupersedes.isEmpty()) {
            return;
        }
        supersedes.addAll(connectorSupersedes.stream().map(String::toLowerCase).collect(Collectors.toSet()));
    }

    void filterLastResortConnectors(@NonNull List<ConnectorTestResult> matchingConnectorTestResultList, @NonNull String hostname) {
        if (matchingConnectorTestResultList == null) {
            throw new IllegalArgumentException("matchingConnectorTestResultList is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        List<ConnectorTestResult> lastResortConnectorTestResultList = matchingConnectorTestResultList.stream().filter(connectorTestResult -> connectorTestResult.getConnector().getConnectorIdentity().getDetection().getOnLastResort() != null).collect(Collectors.toList());
        if (lastResortConnectorTestResultList.isEmpty()) {
            return;
        }
        List regularConnectorTestResultList = matchingConnectorTestResultList.stream().filter(connectorTestResult -> connectorTestResult.getConnector().getConnectorIdentity().getDetection().getOnLastResort() == null).collect(Collectors.toList());
        String[] connectorIdHolder = new String[1];
        lastResortConnectorTestResultList.forEach(lastResortConnectorTestResult -> {
            boolean hasLastResortMonitor = regularConnectorTestResultList.stream().anyMatch(regularConnectorTestResult -> this.hasLastResortMonitorJob(hostname, connectorIdHolder, (ConnectorTestResult)regularConnectorTestResult, (ConnectorTestResult)lastResortConnectorTestResult));
            if (hasLastResortMonitor) {
                matchingConnectorTestResultList.remove(lastResortConnectorTestResult);
                log.info("Hostname {} - {} is a \"last resort\" connector and its components are already discovered thanks to connector {}. Connector is therefore discarded.", new Object[]{hostname, lastResortConnectorTestResult.getConnector().getCompiledFilename(), connectorIdHolder[0]});
            } else {
                regularConnectorTestResultList.add(lastResortConnectorTestResult);
            }
        });
    }

    private boolean hasLastResortMonitorJob(String hostname, String[] connectorIdHolder, ConnectorTestResult regularConnectorTestResult, ConnectorTestResult lastResortConnectorTestResult) {
        Map<String, MonitorJob> monitorJobs = regularConnectorTestResult.getConnector().getMonitors();
        connectorIdHolder[0] = regularConnectorTestResult.getConnector().getCompiledFilename();
        if (monitorJobs == null || monitorJobs.isEmpty()) {
            log.warn("Hostname {} - {} connector detection. On last resort filter: Connector {} has no monitors.", new Object[]{hostname, hostname, connectorIdHolder[0]});
            return false;
        }
        return monitorJobs.entrySet().stream().anyMatch(monitorJobEntry -> {
            boolean hasLastResortMonitorType = lastResortConnectorTestResult.getConnector().getConnectorIdentity().getDetection().getOnLastResort().equals(monitorJobEntry.getKey());
            if (!hasLastResortMonitorType) {
                return false;
            }
            MonitorJob monitorJob = (MonitorJob)monitorJobEntry.getValue();
            if (monitorJob != null) {
                if (monitorJob instanceof SimpleMonitorJob) {
                    SimpleMonitorJob simpleMonitorJob = (SimpleMonitorJob)monitorJob;
                    return simpleMonitorJob.getSimple() != null && simpleMonitorJob.getSimple().getMapping() != null;
                }
                if (monitorJob instanceof StandardMonitorJob) {
                    StandardMonitorJob standardMonitorJob = (StandardMonitorJob)monitorJob;
                    return standardMonitorJob.getDiscovery() != null && standardMonitorJob.getDiscovery().getMapping() != null;
                }
            }
            return false;
        });
    }

    protected CriterionTestResult processCriterion(Criterion criterion, Connector connector) {
        CriterionProcessor criterionProcessor = new CriterionProcessor(this.clientsExecutor, this.telemetryManager, connector.getConnectorIdentity().getCompiledFilename(), this.extensionManager);
        Supplier<CriterionTestResult> executable = () -> criterionProcessor.test(criterion);
        if (criterion.isForceSerialization()) {
            return ForceSerializationHelper.forceSerialization(executable, this.telemetryManager, connector.getCompiledFilename(), criterion, "criterion", CriterionTestResult.empty());
        }
        return executable.get();
    }

    protected boolean isConnectorContainedInSet(@NonNull Connector connector, @NonNull Set<String> connectorIdSet) {
        if (connector == null) {
            throw new IllegalArgumentException("connector is marked non-null but is null");
        }
        if (connectorIdSet == null) {
            throw new IllegalArgumentException("connectorIdSet is marked non-null but is null");
        }
        ConnectorIdentity connectorIdentity = connector.getConnectorIdentity();
        if (connectorIdentity == null) {
            return false;
        }
        String connectorId = connectorIdentity.getCompiledFilename();
        return connectorId != null && connectorIdSet.contains(connectorId);
    }

    public ConnectorTestResult runConnectorDetectionCriteria(Connector connector, String hostname) {
        Detection detection = connector.getConnectorIdentity().getDetection();
        ConnectorTestResult connectorTestResult = ConnectorTestResult.builder().connector(connector).build();
        if (detection == null) {
            log.warn("Hostname {} - The connector {} DOES NOT match the platform as it has no detection to test.", (Object)hostname, (Object)connector.getConnectorIdentity().getCompiledFilename());
            return connectorTestResult;
        }
        List<Criterion> criteria = detection.getCriteria();
        if (criteria == null || criteria.isEmpty()) {
            log.warn("Hostname {} - The connector {} DOES NOT match the platform as it has no criteria to test.", (Object)hostname, (Object)connector.getConnectorIdentity().getCompiledFilename());
            return connectorTestResult;
        }
        for (Criterion criterion : criteria) {
            CriterionTestResult criterionTestResult = this.processCriterion(criterion, connector);
            if (!criterionTestResult.isSuccess()) {
                log.debug("Hostname {} - Detected failed criterion for connector {}. Message: {}.", new Object[]{hostname, connector.getConnectorIdentity().getCompiledFilename(), criterionTestResult.getMessage()});
            }
            connectorTestResult.getCriterionTestResults().add(criterionTestResult);
        }
        return connectorTestResult;
    }

    @Generated
    public AbstractConnectorProcessor(@NonNull TelemetryManager telemetryManager, @NonNull ClientsExecutor clientsExecutor, @NonNull Set<String> connectorIds, @NonNull ExtensionManager extensionManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (connectorIds == null) {
            throw new IllegalArgumentException("connectorIds is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
        this.clientsExecutor = clientsExecutor;
        this.connectorIds = connectorIds;
        this.extensionManager = extensionManager;
    }

    @Generated
    public AbstractConnectorProcessor() {
    }
}

