/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.SqlTableDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlTable;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class InternalDbQuerySource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=SqlTableDeserializer.class)
    @NonNull
    private List<SqlTable> tables = new ArrayList<SqlTable>();
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String query;

    @JsonCreator
    public InternalDbQuerySource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf, @JsonProperty(value="tables", required=true) @NonNull List<SqlTable> tables, @JsonProperty(value="query", required=true) @NonNull String query) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (tables == null) {
            throw new IllegalArgumentException("tables is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.tables = tables;
        this.query = query;
    }

    @Override
    public InternalDbQuerySource copy() {
        return InternalDbQuerySource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).tables(this.tables != null ? (List)this.tables.stream().map(SqlTable::copy).collect(Collectors.toCollection(ArrayList::new)) : null).query(this.query).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        if (this.tables != null && !this.tables.isEmpty()) {
            String tablesString = this.tables.stream().map(SqlTable::toString).collect(Collectors.joining("\n"));
            StringHelper.addNonNull(stringJoiner, "- tables=", tablesString);
        }
        StringHelper.addNonNull(stringJoiner, "- query=", this.query);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static InternalDbQuerySourceBuilder builder() {
        return new InternalDbQuerySourceBuilder();
    }

    @NonNull
    @Generated
    public List<SqlTable> getTables() {
        return this.tables;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=SqlTableDeserializer.class)
    @Generated
    public void setTables(@NonNull List<SqlTable> tables) {
        if (tables == null) {
            throw new IllegalArgumentException("tables is marked non-null but is null");
        }
        this.tables = tables;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public InternalDbQuerySource() {
    }

    @Generated
    public InternalDbQuerySource(@NonNull List<SqlTable> tables, String query) {
        if (tables == null) {
            throw new IllegalArgumentException("tables is marked non-null but is null");
        }
        this.tables = tables;
        this.query = query;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalDbQuerySource)) {
            return false;
        }
        InternalDbQuerySource other = (InternalDbQuerySource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<SqlTable> this$tables = this.getTables();
        List<SqlTable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InternalDbQuerySource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<SqlTable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    @Generated
    public static class InternalDbQuerySourceBuilder {
        @Generated
        private List<SqlTable> tables;
        @Generated
        private String query;
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        InternalDbQuerySourceBuilder() {
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=SqlTableDeserializer.class)
        @Generated
        public InternalDbQuerySourceBuilder tables(@NonNull List<SqlTable> tables) {
            if (tables == null) {
                throw new IllegalArgumentException("tables is marked non-null but is null");
            }
            this.tables = tables;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=NonBlankDeserializer.class)
        @Generated
        public InternalDbQuerySourceBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public InternalDbQuerySource build() {
            return new InternalDbQuerySource(this.tables, this.query);
        }

        @Generated
        public String toString() {
            return "InternalDbQuerySource.InternalDbQuerySourceBuilder(tables=" + String.valueOf(this.tables) + ", query=" + this.query + ")";
        }

        @JsonProperty(value="type")
        @Generated
        public InternalDbQuerySourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public InternalDbQuerySourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public InternalDbQuerySourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public InternalDbQuerySourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public InternalDbQuerySourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }
    }
}

