/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.identity.criterion;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.StringJoiner;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public abstract class SnmpCriterion
extends Criterion {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String oid;
    private String expectedResult;

    protected SnmpCriterion(String type, boolean forceSerialization, @NonNull String oid, String expectedResult) {
        super(type, forceSerialization);
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        this.oid = oid;
        this.expectedResult = expectedResult;
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        if (!this.oid.isBlank()) {
            stringJoiner.add(new StringBuilder("- OID: ").append(this.oid));
        }
        if (this.expectedResult != null && !this.expectedResult.isBlank()) {
            stringJoiner.add(new StringBuilder("- ExpectedResult: ").append(this.expectedResult));
        }
        return stringJoiner.toString();
    }

    @NonNull
    @Generated
    public String getOid() {
        return this.oid;
    }

    @Generated
    public String getExpectedResult() {
        return this.expectedResult;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setOid(@NonNull String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        this.oid = oid;
    }

    @Generated
    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Generated
    public SnmpCriterion() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpCriterion)) {
            return false;
        }
        SnmpCriterion other = (SnmpCriterion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oid = this.getOid();
        String other$oid = other.getOid();
        if (this$oid == null ? other$oid != null : !this$oid.equals(other$oid)) {
            return false;
        }
        String this$expectedResult = this.getExpectedResult();
        String other$expectedResult = other.getExpectedResult();
        return !(this$expectedResult == null ? other$expectedResult != null : !this$expectedResult.equals(other$expectedResult));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpCriterion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oid = this.getOid();
        result = result * 59 + ($oid == null ? 43 : $oid.hashCode());
        String $expectedResult = this.getExpectedResult();
        result = result * 59 + ($expectedResult == null ? 43 : $expectedResult.hashCode());
        return result;
    }
}

