/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractMapDeserializer<T>
extends JsonDeserializer<Map<String, T>> {
    public Map<String, T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return this.emptyMap();
        }
        Map map = (Map)parser.readValueAs(this.getTypeReference());
        if (map == null) {
            return this.emptyMap();
        }
        if (!this.isValidMap(map)) {
            throw new InvalidFormatException(parser, this.messageOnInvalidMap(parser.getCurrentName()), (Object)map, Map.class);
        }
        if (this.isExpectedInstance(map)) {
            return map;
        }
        return this.fromMap(map);
    }

    protected abstract String messageOnInvalidMap(String var1);

    protected abstract Map<String, T> fromMap(Map<String, T> var1);

    protected abstract boolean isExpectedInstance(Map<String, T> var1);

    protected abstract Map<String, T> emptyMap();

    protected abstract boolean isValidMap(Map<String, T> var1);

    protected abstract TypeReference<Map<String, T>> getTypeReference();
}

