/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.EscapeType;
import org.sentrysoftware.metricshub.engine.common.helpers.JUtils;
import org.sentrysoftware.metricshub.engine.common.helpers.MacroType;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;

public class MacrosUpdater {
    private static final Pattern MACRO_PATTERN = Pattern.compile("[$%]\\{(esc\\(([a-zA-Z0-9]+)\\))?(::)?([A-Z0-9_-]+)\\}");

    public static String update(String text, String username, char[] password, String authenticationToken, @NonNull String hostname, boolean maskPasswords) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (text == null || text.isEmpty()) {
            return "";
        }
        String passwordAsString = password != null ? String.valueOf(password) : "";
        username = username != null ? username : "";
        authenticationToken = authenticationToken != null ? authenticationToken : "";
        String updatedContent = text;
        if (updatedContent.contains("%{") || updatedContent.contains("${")) {
            Map<String, String> simpleMacroNameToField = Map.of(MacroType.USERNAME.name(), username, MacroType.PASSWORD.name(), maskPasswords ? "********" : passwordAsString, MacroType.HOSTNAME.name(), hostname, MacroType.AUTHENTICATIONTOKEN.name(), authenticationToken);
            Matcher matcher = MACRO_PATTERN.matcher(text);
            while (matcher.find()) {
                String escapeType = matcher.group(2);
                String macroName = matcher.group(4);
                updatedContent = MacrosUpdater.processMacro(updatedContent, matcher.group(0), macroName, escapeType, simpleMacroNameToField);
            }
        }
        return updatedContent;
    }

    private static String processMacro(String content, String matchedMacro, String macroName, String escapeType, Map<String, String> macroNameField) {
        String updatedContent = content;
        updatedContent = macroName.startsWith(MacroType.PASSWORD_BASE64.name()) ? MacrosUpdater.replacePasswordBase64(updatedContent, escapeType, matchedMacro, macroNameField) : (macroName.startsWith(MacroType.BASIC_AUTH_BASE64.name()) ? MacrosUpdater.replaceBasicAuthBase64MacroValue(updatedContent, escapeType, matchedMacro, macroNameField) : (macroName.startsWith(MacroType.SHA256_AUTH.name()) ? MacrosUpdater.replaceSha256MacroValue(updatedContent, escapeType, matchedMacro, macroNameField) : MacrosUpdater.updateSimpleMacro(updatedContent, matchedMacro, macroName, escapeType, macroNameField)));
        return updatedContent;
    }

    private static String updateSimpleMacro(String content, String matchedMacro, String macroName, String escapeType, Map<String, String> macroNameField) {
        String replacement = macroNameField.getOrDefault(macroName, "");
        String maybeEscapedReplacement = escapeType != null ? MacrosUpdater.escapeReplacement(replacement, escapeType) : replacement;
        return MacrosUpdater.protectAndReplaceMatchedMacro(content, matchedMacro, maybeEscapedReplacement);
    }

    protected static String protectAndReplaceMatchedMacro(String content, String matchedMacro, String maybeEscapedReplacement) {
        String protectedMatchedMacro = StringHelper.protectCaseInsensitiveRegex(matchedMacro);
        return content.replaceAll(protectedMatchedMacro, Matcher.quoteReplacement(maybeEscapedReplacement));
    }

    private static String escapeReplacement(String replacement, String escapeType) {
        return Optional.ofNullable(EscapeType.fromString(escapeType)).map(type -> type.escape(replacement)).orElse(replacement);
    }

    private static String replaceBasicAuthBase64MacroValue(String valueToUpdate, String escapeType, String matchedMacro, Map<String, String> macroNameField) {
        String formattedBasicAuthString = String.format("%s:%s", macroNameField.get(MacroType.USERNAME.name()), macroNameField.get(MacroType.PASSWORD.name()));
        String escapedValue = MacrosUpdater.escapeReplacement(Base64.getEncoder().encodeToString(formattedBasicAuthString.getBytes(StandardCharsets.UTF_8)), escapeType);
        return MacrosUpdater.protectAndReplaceMatchedMacro(valueToUpdate, matchedMacro, escapedValue);
    }

    private static String replaceSha256MacroValue(String valueToUpdate, String escapeType, String matchedMacro, Map<String, String> macroNameField) {
        String authenticationToken = macroNameField.get(MacroType.AUTHENTICATIONTOKEN.name());
        if (authenticationToken == null || authenticationToken.isEmpty()) {
            return MacrosUpdater.protectAndReplaceMatchedMacro(valueToUpdate, matchedMacro, "");
        }
        String escapedHashedToken = MacrosUpdater.escapeReplacement(JUtils.encodeSha256(authenticationToken), escapeType);
        return MacrosUpdater.protectAndReplaceMatchedMacro(valueToUpdate, matchedMacro, escapedHashedToken);
    }

    private static String replacePasswordBase64(String valueToUpdate, String escapeType, String matchedMacro, Map<String, String> macroNameField) {
        String escapedValue = MacrosUpdater.escapeReplacement(Base64.getEncoder().encodeToString(macroNameField.get(MacroType.PASSWORD.name()).getBytes(StandardCharsets.UTF_8)), escapeType);
        return MacrosUpdater.protectAndReplaceMatchedMacro(valueToUpdate, matchedMacro, escapedValue);
    }

    static String escapeJsonSpecialCharacters(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    static String escapeUrlSpecialCharacters(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8).replace("+", "%20");
    }

    static String escapeRegexSpecialCharacters(String value) {
        return Pattern.quote(value);
    }

    static String escapeXmlSpecialCharacters(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    static String escapeWindowsCmdSpecialCharacters(String value) {
        return value.replace("^", "^^").replace("&", "^&").replace("|", "^|").replace("<", "^<").replace(">", "^>").replace("%", "^%").replace("(", "^(").replace(")", "^)").replace("\"", "^\"");
    }

    static String escapePowershellSpecialCharacters(String value) {
        return value.replace("0", "`0").replace("`n", "``n").replace("`t", "``t").replace("`r", "``r").replace("#", "`#").replace("[", "`[").replace("]", "`]").replace("(", "`(").replace(")", "`)").replace("{", "`{").replace("}", "`}").replace("$", "`$").replace("'", "''").replace("\"", "`\"").replace(".", "`.");
    }

    static String escapeBashSpecialCharacters(String value) {
        return value.replace("'", "\\'").replace("\"", "\\\"").replace("\\", "\\\\").replace("$", "\\$").replace("!", "\\!").replace("*", "\\*").replace("?", "\\?").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("|", "\\|").replace("&", "\\&").replace("<", "\\<").replace(">", "\\>").replace("~", "\\~").replace(";", "\\;").replace("\n", "\\n");
    }

    static String escapeSqlSpecialCharacters(String value) {
        return value.replace("'", "''").replace("\"", "\\\"").replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    @Generated
    private MacrosUpdater() {
    }
}

