/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public enum KnownMonitorType {
    CONNECTOR("connector"),
    HOST("host"),
    BATTERY("battery"),
    BLADE("blade"),
    CPU("cpu"),
    DISK_CONTROLLER("disk_controller"),
    ENCLOSURE("enclosure"),
    FAN("fan"),
    GPU("gpu"),
    LED("led"),
    LOGICAL_DISK("logical_disk"),
    LUN("lun"),
    MEMORY("memory"),
    NETWORK("network"),
    OTHER_DEVICE("other_device"),
    PHYSICAL_DISK("physical_disk"),
    POWER_SUPPLY("power_supply"),
    ROBOTICS("robotics"),
    TAPE_DRIVE("tape_drive"),
    TEMPERATURE("temperature"),
    VM("vm"),
    VOLTAGE("voltage");

    private String key;
    public static final Set<String> KEYS;

    public static Optional<KnownMonitorType> fromString(String monitorType) {
        return Stream.of(KnownMonitorType.values()).filter(type -> type.key.equalsIgnoreCase(monitorType)).findFirst();
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    private KnownMonitorType(String key) {
        this.key = key;
    }

    static {
        KEYS = Stream.of(KnownMonitorType.values()).map(KnownMonitorType::getKey).collect(Collectors.toSet());
    }
}

