/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.xflat.types;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.sentrysoftware.xflat.types.SearchPathElement;
import org.sentrysoftware.xflat.types.SearchPathElementAttribute;
import org.sentrysoftware.xflat.types.SearchPathElementProperty;

public class SearchPathNode {
    private static final int IS_BEFORE = -1;
    private static final int IS_AFTER = 1;
    private final SearchPathElement element;
    private final Set<SearchPathNode> nexts = new TreeSet<SearchPathNode>(SearchPathNode::compare);

    public SearchPathNode(SearchPathElement element) {
        this.element = element;
    }

    public void addNode(SearchPathNode element) {
        this.nexts.add(element);
    }

    public SearchPathElement getElement() {
        return this.element;
    }

    public Set<SearchPathNode> getNexts() {
        return this.nexts;
    }

    public int hashCode() {
        return Objects.hash(this.element, this.nexts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPathNode)) {
            return false;
        }
        SearchPathNode other = (SearchPathNode)obj;
        return Objects.equals(this.element, other.element) && Objects.equals(this.nexts, other.nexts);
    }

    public String toString() {
        return "SearchPathNode [element=" + this.element + ", nexts=" + this.nexts + "]";
    }

    private static int compare(SearchPathNode node1, SearchPathNode node2) {
        if (node1.getElement() instanceof SearchPathElementAttribute && !(node2.getElement() instanceof SearchPathElementAttribute)) {
            return -1;
        }
        if (!(node1.getElement() instanceof SearchPathElementAttribute) && node2.getElement() instanceof SearchPathElementAttribute) {
            return 1;
        }
        if (node1.getElement() instanceof SearchPathElementProperty && node2.getElement() instanceof SearchPathElement) {
            return -1;
        }
        if (node1.getElement() instanceof SearchPathElement && node2.getElement() instanceof SearchPathElementProperty) {
            return 1;
        }
        return node1.getElement().getName().compareToIgnoreCase(node2.getElement().getName());
    }
}

