/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.alert.AlertRule;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.telemetry.Resource;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;

public class Monitor {
    private Map<String, AbstractMetric> metrics;
    private Map<String, String> attributes;
    private Map<String, String> conditionalCollection;
    private Map<String, String> legacyTextParameters;
    private Map<String, List<AlertRule>> alertRules;
    private Resource resource;
    private Long discoveryTime;
    private String type;
    private String id;
    @JsonProperty(value="is_endpoint")
    private boolean isEndpoint;

    public <T extends AbstractMetric> T getMetric(String metricName, Class<T> type) {
        return (T)((AbstractMetric)type.cast(this.metrics.get(metricName)));
    }

    public AbstractMetric getMetric(String metricName) {
        return this.metrics.get(metricName);
    }

    public void addMetric(String metricName, AbstractMetric metric) {
        this.metrics.put(metricName, metric);
    }

    public void addAttributes(@NonNull Map<String, String> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is marked non-null but is null");
        }
        this.attributes.putAll(attributes);
    }

    public void addConditionalCollection(Map<String, String> conditionalCollection) {
        this.conditionalCollection.putAll(conditionalCollection);
    }

    public void addLegacyParameters(Map<String, String> legacyTextParameters) {
        this.legacyTextParameters.putAll(legacyTextParameters);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public boolean isMetricDeactivated(String key) {
        return "".equals(this.conditionalCollection.get(key));
    }

    public boolean isEndpointHost() {
        return KnownMonitorType.HOST.getKey().equals(this.type) && this.isEndpoint();
    }

    public void setIsEndpoint(boolean isEndpoint) {
        this.isEndpoint = isEndpoint;
    }

    public void setAsEndpoint() {
        this.setIsEndpoint(true);
    }

    @Generated
    private static Map<String, AbstractMetric> $default$metrics() {
        return new HashMap<String, AbstractMetric>();
    }

    @Generated
    private static Map<String, String> $default$attributes() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Map<String, String> $default$conditionalCollection() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Map<String, String> $default$legacyTextParameters() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Map<String, List<AlertRule>> $default$alertRules() {
        return new HashMap<String, List<AlertRule>>();
    }

    @Generated
    public static MonitorBuilder builder() {
        return new MonitorBuilder();
    }

    @Generated
    public Map<String, AbstractMetric> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, String> getConditionalCollection() {
        return this.conditionalCollection;
    }

    @Generated
    public Map<String, String> getLegacyTextParameters() {
        return this.legacyTextParameters;
    }

    @Generated
    public Map<String, List<AlertRule>> getAlertRules() {
        return this.alertRules;
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public Long getDiscoveryTime() {
        return this.discoveryTime;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean isEndpoint() {
        return this.isEndpoint;
    }

    @Generated
    public void setMetrics(Map<String, AbstractMetric> metrics) {
        this.metrics = metrics;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setConditionalCollection(Map<String, String> conditionalCollection) {
        this.conditionalCollection = conditionalCollection;
    }

    @Generated
    public void setLegacyTextParameters(Map<String, String> legacyTextParameters) {
        this.legacyTextParameters = legacyTextParameters;
    }

    @Generated
    public void setAlertRules(Map<String, List<AlertRule>> alertRules) {
        this.alertRules = alertRules;
    }

    @Generated
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Generated
    public void setDiscoveryTime(Long discoveryTime) {
        this.discoveryTime = discoveryTime;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Monitor)) {
            return false;
        }
        Monitor other = (Monitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEndpoint() != other.isEndpoint()) {
            return false;
        }
        Long this$discoveryTime = this.getDiscoveryTime();
        Long other$discoveryTime = other.getDiscoveryTime();
        if (this$discoveryTime == null ? other$discoveryTime != null : !((Object)this$discoveryTime).equals(other$discoveryTime)) {
            return false;
        }
        Map<String, AbstractMetric> this$metrics = this.getMetrics();
        Map<String, AbstractMetric> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, String> this$conditionalCollection = this.getConditionalCollection();
        Map<String, String> other$conditionalCollection = other.getConditionalCollection();
        if (this$conditionalCollection == null ? other$conditionalCollection != null : !((Object)this$conditionalCollection).equals(other$conditionalCollection)) {
            return false;
        }
        Map<String, String> this$legacyTextParameters = this.getLegacyTextParameters();
        Map<String, String> other$legacyTextParameters = other.getLegacyTextParameters();
        if (this$legacyTextParameters == null ? other$legacyTextParameters != null : !((Object)this$legacyTextParameters).equals(other$legacyTextParameters)) {
            return false;
        }
        Map<String, List<AlertRule>> this$alertRules = this.getAlertRules();
        Map<String, List<AlertRule>> other$alertRules = other.getAlertRules();
        if (this$alertRules == null ? other$alertRules != null : !((Object)this$alertRules).equals(other$alertRules)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Monitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEndpoint() ? 79 : 97);
        Long $discoveryTime = this.getDiscoveryTime();
        result = result * 59 + ($discoveryTime == null ? 43 : ((Object)$discoveryTime).hashCode());
        Map<String, AbstractMetric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, String> $conditionalCollection = this.getConditionalCollection();
        result = result * 59 + ($conditionalCollection == null ? 43 : ((Object)$conditionalCollection).hashCode());
        Map<String, String> $legacyTextParameters = this.getLegacyTextParameters();
        result = result * 59 + ($legacyTextParameters == null ? 43 : ((Object)$legacyTextParameters).hashCode());
        Map<String, List<AlertRule>> $alertRules = this.getAlertRules();
        result = result * 59 + ($alertRules == null ? 43 : ((Object)$alertRules).hashCode());
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Monitor(metrics=" + String.valueOf(this.getMetrics()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", conditionalCollection=" + String.valueOf(this.getConditionalCollection()) + ", legacyTextParameters=" + String.valueOf(this.getLegacyTextParameters()) + ", alertRules=" + String.valueOf(this.getAlertRules()) + ", resource=" + String.valueOf(this.getResource()) + ", discoveryTime=" + this.getDiscoveryTime() + ", type=" + this.getType() + ", id=" + this.getId() + ", isEndpoint=" + this.isEndpoint() + ")";
    }

    @Generated
    public Monitor(Map<String, AbstractMetric> metrics, Map<String, String> attributes, Map<String, String> conditionalCollection, Map<String, String> legacyTextParameters, Map<String, List<AlertRule>> alertRules, Resource resource, Long discoveryTime, String type, String id, boolean isEndpoint) {
        this.metrics = metrics;
        this.attributes = attributes;
        this.conditionalCollection = conditionalCollection;
        this.legacyTextParameters = legacyTextParameters;
        this.alertRules = alertRules;
        this.resource = resource;
        this.discoveryTime = discoveryTime;
        this.type = type;
        this.id = id;
        this.isEndpoint = isEndpoint;
    }

    @Generated
    public Monitor() {
        this.metrics = Monitor.$default$metrics();
        this.attributes = Monitor.$default$attributes();
        this.conditionalCollection = Monitor.$default$conditionalCollection();
        this.legacyTextParameters = Monitor.$default$legacyTextParameters();
        this.alertRules = Monitor.$default$alertRules();
    }

    @Generated
    public static class MonitorBuilder {
        @Generated
        private boolean metrics$set;
        @Generated
        private Map<String, AbstractMetric> metrics$value;
        @Generated
        private boolean attributes$set;
        @Generated
        private Map<String, String> attributes$value;
        @Generated
        private boolean conditionalCollection$set;
        @Generated
        private Map<String, String> conditionalCollection$value;
        @Generated
        private boolean legacyTextParameters$set;
        @Generated
        private Map<String, String> legacyTextParameters$value;
        @Generated
        private boolean alertRules$set;
        @Generated
        private Map<String, List<AlertRule>> alertRules$value;
        @Generated
        private Resource resource;
        @Generated
        private Long discoveryTime;
        @Generated
        private String type;
        @Generated
        private String id;
        @Generated
        private boolean isEndpoint;

        @Generated
        MonitorBuilder() {
        }

        @Generated
        public MonitorBuilder metrics(Map<String, AbstractMetric> metrics) {
            this.metrics$value = metrics;
            this.metrics$set = true;
            return this;
        }

        @Generated
        public MonitorBuilder attributes(Map<String, String> attributes) {
            this.attributes$value = attributes;
            this.attributes$set = true;
            return this;
        }

        @Generated
        public MonitorBuilder conditionalCollection(Map<String, String> conditionalCollection) {
            this.conditionalCollection$value = conditionalCollection;
            this.conditionalCollection$set = true;
            return this;
        }

        @Generated
        public MonitorBuilder legacyTextParameters(Map<String, String> legacyTextParameters) {
            this.legacyTextParameters$value = legacyTextParameters;
            this.legacyTextParameters$set = true;
            return this;
        }

        @Generated
        public MonitorBuilder alertRules(Map<String, List<AlertRule>> alertRules) {
            this.alertRules$value = alertRules;
            this.alertRules$set = true;
            return this;
        }

        @Generated
        public MonitorBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public MonitorBuilder discoveryTime(Long discoveryTime) {
            this.discoveryTime = discoveryTime;
            return this;
        }

        @Generated
        public MonitorBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MonitorBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="is_endpoint")
        @Generated
        public MonitorBuilder isEndpoint(boolean isEndpoint) {
            this.isEndpoint = isEndpoint;
            return this;
        }

        @Generated
        public Monitor build() {
            Map<String, AbstractMetric> metrics$value = this.metrics$value;
            if (!this.metrics$set) {
                metrics$value = Monitor.$default$metrics();
            }
            Map<String, String> attributes$value = this.attributes$value;
            if (!this.attributes$set) {
                attributes$value = Monitor.$default$attributes();
            }
            Map<String, String> conditionalCollection$value = this.conditionalCollection$value;
            if (!this.conditionalCollection$set) {
                conditionalCollection$value = Monitor.$default$conditionalCollection();
            }
            Map<String, String> legacyTextParameters$value = this.legacyTextParameters$value;
            if (!this.legacyTextParameters$set) {
                legacyTextParameters$value = Monitor.$default$legacyTextParameters();
            }
            Map<String, List<AlertRule>> alertRules$value = this.alertRules$value;
            if (!this.alertRules$set) {
                alertRules$value = Monitor.$default$alertRules();
            }
            return new Monitor(metrics$value, attributes$value, conditionalCollection$value, legacyTextParameters$value, alertRules$value, this.resource, this.discoveryTime, this.type, this.id, this.isEndpoint);
        }

        @Generated
        public String toString() {
            return "Monitor.MonitorBuilder(metrics$value=" + String.valueOf(this.metrics$value) + ", attributes$value=" + String.valueOf(this.attributes$value) + ", conditionalCollection$value=" + String.valueOf(this.conditionalCollection$value) + ", legacyTextParameters$value=" + String.valueOf(this.legacyTextParameters$value) + ", alertRules$value=" + String.valueOf(this.alertRules$value) + ", resource=" + String.valueOf(this.resource) + ", discoveryTime=" + this.discoveryTime + ", type=" + this.type + ", id=" + this.id + ", isEndpoint=" + this.isEndpoint + ")";
        }
    }
}

