/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CopySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.InternalDbQuerySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.JawkSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SqlSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.StaticSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableJoinSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableUnionSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.extension.ICompositeSourceScriptExtension;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.extension.ISourceComputationExtension;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceProcessor
implements ISourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceProcessor.class);
    private TelemetryManager telemetryManager;
    private String connectorId;
    private ClientsExecutor clientsExecutor;
    private ExtensionManager extensionManager;

    @Override
    @WithSpan(value="Source Copy Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") CopySource copySource) {
        String hostname = this.telemetryManager.getHostname();
        if (copySource == null) {
            log.error("Hostname {} - CopySource cannot be null, the CopySource operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        String copyFrom = copySource.getFrom();
        if (copyFrom == null || copyFrom.isEmpty()) {
            log.error("Hostname {} - CopySource reference cannot be null. Returning an empty table for source {}.", (Object)hostname, (Object)copySource);
            return SourceTable.empty();
        }
        SourceTable sourceTable = new SourceTable();
        Optional<SourceTable> maybeOrigin = SourceTable.lookupSourceTable(copyFrom, this.connectorId, this.telemetryManager);
        if (maybeOrigin.isEmpty()) {
            return SourceTable.empty();
        }
        SourceTable origin = maybeOrigin.get();
        List<List<String>> table = origin.getTable().stream().map(ArrayList::new).filter(row -> !row.isEmpty()).collect(Collectors.toList());
        sourceTable.setTable(table);
        if (origin.getRawData() != null) {
            sourceTable.setRawData(origin.getRawData());
        }
        SourceProcessor.logSourceCopy(this.connectorId, copyFrom, copySource.getKey(), sourceTable, hostname);
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source HTTP Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") HttpSource httpSource) {
        return this.processSourceThroughExtension(httpSource);
    }

    private SourceTable processSourceThroughExtension(Source source) {
        Optional<IProtocolExtension> maybeExtension = this.extensionManager.findSourceExtension(source, this.telemetryManager);
        return maybeExtension.map(extension -> extension.processSource(source, this.connectorId, this.telemetryManager)).orElseGet(SourceTable::empty);
    }

    private SourceTable processSourceComputationThroughExtension(Source source) {
        Optional<ISourceComputationExtension> maybeExtension = this.extensionManager.findSourceComputationExtension(source);
        return maybeExtension.map(extension -> extension.processSource(source, this.connectorId, this.telemetryManager)).orElseGet(SourceTable::empty);
    }

    private SourceTable processCompositeSourceScriptThroughExtension(Source source) {
        Optional<ICompositeSourceScriptExtension> maybeExtension = this.extensionManager.findCompositeSourceScriptExtension(source);
        return maybeExtension.map(extension -> extension.processSource(source, this.connectorId, this.telemetryManager, this)).orElseGet(SourceTable::empty);
    }

    @Override
    @WithSpan(value="Source IPMI Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") IpmiSource ipmiSource) {
        String hostname = this.telemetryManager.getHostname();
        if (ipmiSource == null) {
            log.error("Hostname {} - IPMI Source cannot be null, the IPMI operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        DeviceKind hostType = this.telemetryManager.getHostConfiguration().getHostType();
        if (DeviceKind.WINDOWS.equals((Object)hostType) || DeviceKind.LINUX.equals((Object)hostType) || DeviceKind.SOLARIS.equals((Object)hostType) || DeviceKind.OOB.equals((Object)hostType)) {
            return this.processSourceThroughExtension(ipmiSource);
        }
        log.info("Hostname {} - Failed to process IPMI source. {} is an unsupported OS for IPMI. Returning an empty table.", (Object)hostname, (Object)hostType.name());
        return SourceTable.empty();
    }

    @Override
    @WithSpan(value="Source OS Command Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") CommandLineSource commandLineSource) {
        return this.processSourceThroughExtension(commandLineSource);
    }

    @Override
    @WithSpan(value="Source SNMP Get Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") SnmpGetSource snmpGetSource) {
        return this.processSourceThroughExtension(snmpGetSource);
    }

    @Override
    @WithSpan(value="Source SNMP Table Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") SnmpTableSource snmpTableSource) {
        return this.processSourceThroughExtension(snmpTableSource);
    }

    @Override
    @WithSpan(value="Source Static Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") StaticSource staticSource) {
        String hostname = this.telemetryManager.getHostname();
        if (staticSource == null) {
            log.error("Hostname {} - Static Source cannot be null, the StaticSource operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        String staticValue = staticSource.getValue();
        if (staticValue == null || staticValue.isEmpty()) {
            log.error("Hostname {} - Static Source reference cannot be null. Returning an empty table for source {}.", (Object)hostname, (Object)staticSource);
            return SourceTable.empty();
        }
        log.debug("Hostname {} - Got Static Source value [{}] referenced in source [{}].", new Object[]{hostname, staticValue, staticSource.getKey()});
        SourceTable sourceTable = new SourceTable();
        Optional<SourceTable> maybeStaticTable = SourceTable.lookupSourceTable(staticValue, this.connectorId, this.telemetryManager);
        if (maybeStaticTable.isEmpty()) {
            return SourceTable.empty();
        }
        List<List<String>> table = maybeStaticTable.get().getTable().stream().map(ArrayList::new).filter(row -> !row.isEmpty()).collect(Collectors.toList());
        sourceTable.setTable(table);
        sourceTable.setRawData(SourceTable.tableToCsv(sourceTable.getTable(), ";", false));
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source TableJoin Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") TableJoinSource tableJoinSource) {
        String hostname = this.telemetryManager.getHostname();
        if (tableJoinSource == null) {
            log.error("Hostname {} - Table Join Source cannot be null, the Table Join will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        if (tableJoinSource.getLeftTable() == null) {
            log.debug("Hostname {} - Left table cannot be null, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        Optional<SourceTable> maybeLeftTable = SourceTable.lookupSourceTable(tableJoinSource.getLeftTable(), this.connectorId, this.telemetryManager);
        if (maybeLeftTable.isEmpty()) {
            log.debug("Hostname {} - Reference to Left table cannot be found, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        if (tableJoinSource.getRightTable() == null) {
            log.debug("Hostname {} - Right table cannot be null, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        Optional<SourceTable> maybeRightTable = SourceTable.lookupSourceTable(tableJoinSource.getRightTable(), this.connectorId, this.telemetryManager);
        if (maybeRightTable.isEmpty()) {
            log.debug("Hostname {} - Reference to Right table cannot be found, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        if (tableJoinSource.getLeftKeyColumn() < 1 || tableJoinSource.getRightKeyColumn() < 1) {
            log.error("Hostname {} - Invalid key column number (leftKeyColumnNumber={}, rightKeyColumnNumber={}).", new Object[]{tableJoinSource.getLeftKeyColumn(), tableJoinSource.getDefaultRightLine(), hostname});
            return SourceTable.empty();
        }
        SourceTable leftTable = maybeLeftTable.get();
        SourceTable rightTable = maybeRightTable.get();
        SourceProcessor.logTableJoin(tableJoinSource.getKey(), tableJoinSource.getLeftTable(), tableJoinSource.getRightTable(), leftTable, rightTable, hostname);
        List<List<String>> executeTableJoin = this.clientsExecutor.executeTableJoin(leftTable.getTable(), rightTable.getTable(), tableJoinSource.getLeftKeyColumn(), tableJoinSource.getRightKeyColumn(), SourceTable.lineToList(tableJoinSource.getDefaultRightLine(), ";"), "wbem".equalsIgnoreCase(tableJoinSource.getKeyType()), true);
        SourceTable sourceTable = new SourceTable();
        if (executeTableJoin != null) {
            sourceTable.setTable(executeTableJoin);
        }
        return sourceTable;
    }

    private static void logTableJoin(String sourceKey, String leftSourceKey, String rightSourceKey, SourceTable leftTable, SourceTable rightTable, String hostname) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("Hostname {} - Table Join Source [{}]:\nLeft table [{}]:\n{}\nRight table [{}]:\n{}\n", new Object[]{hostname, sourceKey, leftSourceKey, TextTableHelper.generateTextTable(leftTable.getHeaders(), leftTable.getTable()), rightSourceKey, TextTableHelper.generateTextTable(rightTable.getHeaders(), rightTable.getTable())});
    }

    @Override
    @WithSpan(value="Source TableUnion Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") TableUnionSource tableUnionSource) {
        String hostname = this.telemetryManager.getHostname();
        if (tableUnionSource == null) {
            log.warn("Hostname {} - Table Union Source cannot be null, the Table Union operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        List<String> unionTables = tableUnionSource.getTables();
        if (unionTables == null) {
            log.debug("Hostname {} - Table list in the Union cannot be null, the Union operation {} will return an empty result.", (Object)hostname, (Object)tableUnionSource);
            return SourceTable.empty();
        }
        List sourceTablesToConcat = unionTables.stream().map(key -> SourceTable.lookupSourceTable(key, this.connectorId, this.telemetryManager)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        SourceTable sourceTable = new SourceTable();
        List<List<String>> executeTableUnion = sourceTablesToConcat.stream().map(SourceTable::getTable).flatMap(Collection::stream).collect(Collectors.toList());
        sourceTable.setTable(executeTableUnion);
        String rawData = sourceTablesToConcat.stream().map(SourceTable::getRawData).filter(Objects::nonNull).collect(Collectors.joining("\n")).replace("\n\n", "\n");
        sourceTable.setRawData(rawData);
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source WBEM HTTP Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") WbemSource wbemSource) {
        return this.processSourceThroughExtension(wbemSource);
    }

    @Override
    @WithSpan(value="Source WMI Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") WmiSource wmiSource) {
        return this.processSourceThroughExtension(wmiSource);
    }

    private static void logSourceCopy(String connectorId, String parentSourceKey, String childSourceKey, SourceTable sourceTable, String hostname) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (sourceTable.getRawData() != null && (sourceTable.getTable() == null || sourceTable.getTable().isEmpty())) {
            log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nRaw result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, sourceTable.getRawData()});
            return;
        }
        if (sourceTable.getRawData() == null) {
            log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nTable result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
            return;
        }
        log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nRaw result:\n{}\nTable result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, sourceTable.getRawData(), TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
    }

    @Override
    @WithSpan(value="Source InternalDbQuerySource Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") InternalDbQuerySource internalDbQuery) {
        return this.processSourceComputationThroughExtension(internalDbQuery);
    }

    @Override
    @WithSpan(value="Source JawkSource Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") JawkSource jawkSource) {
        return this.processCompositeSourceScriptThroughExtension(jawkSource);
    }

    @Override
    @WithSpan(value="Source SQL Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") SqlSource sqlSource) {
        return this.processSourceThroughExtension(sqlSource);
    }

    @Generated
    public static SourceProcessorBuilder builder() {
        return new SourceProcessorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setClientsExecutor(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceProcessor)) {
            return false;
        }
        SourceProcessor other = (SourceProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        if (this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        return !(this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceProcessor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ")";
    }

    @Generated
    public SourceProcessor(TelemetryManager telemetryManager, String connectorId, ClientsExecutor clientsExecutor, ExtensionManager extensionManager) {
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.clientsExecutor = clientsExecutor;
        this.extensionManager = extensionManager;
    }

    @Generated
    public SourceProcessor() {
    }

    @Generated
    public static class SourceProcessorBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        SourceProcessorBuilder() {
        }

        @Generated
        public SourceProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public SourceProcessorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public SourceProcessorBuilder clientsExecutor(ClientsExecutor clientsExecutor) {
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public SourceProcessorBuilder extensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public SourceProcessor build() {
            return new SourceProcessor(this.telemetryManager, this.connectorId, this.clientsExecutor, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "SourceProcessor.SourceProcessorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

