/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.security;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.security.MetricsHubSecurityException;

public class CryptoCipher {
    public static final int GCM_IV_LENGTH = 16;
    public static final int GCM_TAG_LENGTH = 16;
    public static final int ITERATIONS = 2333;
    public static final int KEY_LENGTH = 32;
    public static final String MASTER_KEY = "bWFzdGVyLWtleQ==";
    private static final byte[] IV = "c2VudHJ5aXY=".getBytes();
    private static final String CIPHER_ALGO = "AES/GCM/NoPadding";

    private static byte[] encrypt(byte[] plaintext, SecretKey key, byte[] iv) throws MetricsHubSecurityException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGO);
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)keySpec, gcmParameterSpec);
            return cipher.doFinal(plaintext);
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Cannot perform encryption", e);
        }
    }

    private static char[] decrypt(byte[] cipherText, SecretKey key, byte[] iv) throws MetricsHubSecurityException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGO);
            SecretKeySpec keySpec = new SecretKeySpec(key.getEncoded(), "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)keySpec, gcmParameterSpec);
            byte[] decryptedText = cipher.doFinal(cipherText);
            return CryptoCipher.bytesToChars(decryptedText);
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Cannot perform decryption", e);
        }
    }

    public static char[] generateRandomMasterKey() throws MetricsHubSecurityException {
        try {
            byte[] salt = CryptoCipher.getSalt();
            char[] masterKey = MASTER_KEY.toCharArray();
            PBEKeySpec spec = new PBEKeySpec(masterKey, salt, 2333, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return CryptoCipher.bytesToChars(Base64.getEncoder().encode(skf.generateSecret(spec).getEncoded()));
        }
        catch (Exception e) {
            throw new MetricsHubSecurityException("Error while building the master key", e);
        }
    }

    public static byte[] getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[64];
        sr.nextBytes(salt);
        return salt;
    }

    public static char[] encrypt(char[] plainText, SecretKey secretKey) throws MetricsHubSecurityException {
        byte[] cipherText = CryptoCipher.encrypt(CryptoCipher.charsToBytes(plainText), secretKey, IV);
        return CryptoCipher.bytesToChars(Base64.getEncoder().encode(cipherText));
    }

    public static char[] decrypt(char[] crypted, SecretKey secretKey) {
        try {
            byte[] decodedCrypt = Base64.getDecoder().decode(CryptoCipher.charsToBytes(crypted));
            return CryptoCipher.decrypt(decodedCrypt, secretKey, IV);
        }
        catch (Exception e) {
            return crypted;
        }
    }

    public static byte[] charsToBytes(char[] chars) {
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars));
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.limit());
    }

    public static char[] bytesToChars(byte[] bytes) {
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
        return Arrays.copyOf(charBuffer.array(), charBuffer.limit());
    }

    @Generated
    private CryptoCipher() {
    }
}

