/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;

public class ExtendsProcessor
extends AbstractNodeProcessor {
    @NonNull
    private Path connectorDirectory;
    @NonNull
    private ObjectMapper mapper;

    public ExtendsProcessor(@NonNull Path connectorDirectory, @NonNull ObjectMapper mapper, AbstractNodeProcessor next) {
        super(next);
        if (connectorDirectory == null) {
            throw new IllegalArgumentException("connectorDirectory is marked non-null but is null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is marked non-null but is null");
        }
        this.connectorDirectory = connectorDirectory;
        this.mapper = mapper;
    }

    @Override
    public JsonNode processNode(JsonNode node) throws IOException {
        return this.doMerge(node);
    }

    private JsonNode doMerge(JsonNode node) throws IOException {
        JsonNode extNode = node.get("extends");
        JsonNode result = node;
        if (extNode != null && extNode.isArray()) {
            ArrayNode extNodeArray = (ArrayNode)extNode;
            Iterator<JsonNode> iter = extNodeArray.iterator();
            JsonNode extended = null;
            if (iter.hasNext()) {
                extended = this.doMerge(this.getJsonNode(iter));
                while (iter.hasNext()) {
                    JsonNode extendedNext = this.doMerge(this.getJsonNode(iter));
                    ExtendsProcessor.merge(extended, extendedNext);
                }
            }
            extNodeArray.removeAll();
            if (extended != null) {
                result = ExtendsProcessor.merge(extended, node);
            }
        }
        return result;
    }

    private JsonNode getJsonNode(Iterator<JsonNode> iter) throws IOException {
        File connectorPathFile;
        Path connectorsDirectoryPath;
        String connectorRelativePath = iter.next().asText() + ".yaml";
        if (!connectorRelativePath.startsWith(".") && (connectorsDirectoryPath = FileHelper.findConnectorsDirectory(this.connectorDirectory.toUri())) != null && (connectorPathFile = connectorsDirectoryPath.resolve(connectorRelativePath).normalize().toFile()) != null && connectorPathFile.exists()) {
            return this.mapper.readTree(connectorPathFile);
        }
        Path connectorPath = this.connectorDirectory.resolve(connectorRelativePath).normalize();
        return this.mapper.readTree(Files.newInputStream(connectorPath, new OpenOption[0]));
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator<String> fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isArray() && updateNode.get(fieldName).isArray()) {
                ExtendsProcessor.mergeJsonArray(updateNode, fieldName, jsonNode);
                continue;
            }
            if (jsonNode != null && jsonNode.isObject()) {
                ExtendsProcessor.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            ObjectNode objectNode = (ObjectNode)mainNode;
            JsonNode value = updateNode.get(fieldName);
            objectNode.set(fieldName, value);
        }
        return mainNode;
    }

    private static void mergeJsonArray(JsonNode updateNode, String fieldName, JsonNode jsonNode) {
        ArrayNode mainArray = (ArrayNode)jsonNode;
        ArrayNode extendedArray = (ArrayNode)updateNode.get(fieldName);
        if (mainArray.size() != 0 && mainArray.get(0).isObject()) {
            for (int i = 0; i < extendedArray.size(); ++i) {
                mainArray.add(extendedArray.get(i));
            }
        } else {
            mainArray.removeAll();
            mainArray.addAll(extendedArray);
        }
    }

    @Generated
    public static ExtendsProcessorBuilder builder() {
        return new ExtendsProcessorBuilder();
    }

    @NonNull
    @Generated
    public Path getConnectorDirectory() {
        return this.connectorDirectory;
    }

    @NonNull
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public void setConnectorDirectory(@NonNull Path connectorDirectory) {
        if (connectorDirectory == null) {
            throw new IllegalArgumentException("connectorDirectory is marked non-null but is null");
        }
        this.connectorDirectory = connectorDirectory;
    }

    @Generated
    public void setMapper(@NonNull ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is marked non-null but is null");
        }
        this.mapper = mapper;
    }

    @Override
    @Generated
    public String toString() {
        return "ExtendsProcessor(connectorDirectory=" + String.valueOf(this.getConnectorDirectory()) + ", mapper=" + String.valueOf(this.getMapper()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendsProcessor)) {
            return false;
        }
        ExtendsProcessor other = (ExtendsProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Path this$connectorDirectory = this.getConnectorDirectory();
        Path other$connectorDirectory = other.getConnectorDirectory();
        if (this$connectorDirectory == null ? other$connectorDirectory != null : !((Object)this$connectorDirectory).equals(other$connectorDirectory)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtendsProcessor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Path $connectorDirectory = this.getConnectorDirectory();
        result = result * 59 + ($connectorDirectory == null ? 43 : ((Object)$connectorDirectory).hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    @Generated
    public static class ExtendsProcessorBuilder {
        @Generated
        private Path connectorDirectory;
        @Generated
        private ObjectMapper mapper;
        @Generated
        private AbstractNodeProcessor next;

        @Generated
        ExtendsProcessorBuilder() {
        }

        @Generated
        public ExtendsProcessorBuilder connectorDirectory(@NonNull Path connectorDirectory) {
            if (connectorDirectory == null) {
                throw new IllegalArgumentException("connectorDirectory is marked non-null but is null");
            }
            this.connectorDirectory = connectorDirectory;
            return this;
        }

        @Generated
        public ExtendsProcessorBuilder mapper(@NonNull ObjectMapper mapper) {
            if (mapper == null) {
                throw new IllegalArgumentException("mapper is marked non-null but is null");
            }
            this.mapper = mapper;
            return this;
        }

        @Generated
        public ExtendsProcessorBuilder next(AbstractNodeProcessor next) {
            this.next = next;
            return this;
        }

        @Generated
        public ExtendsProcessor build() {
            return new ExtendsProcessor(this.connectorDirectory, this.mapper, this.next);
        }

        @Generated
        public String toString() {
            return "ExtendsProcessor.ExtendsProcessorBuilder(connectorDirectory=" + String.valueOf(this.connectorDirectory) + ", mapper=" + String.valueOf(this.mapper) + ", next=" + String.valueOf(this.next) + ")";
        }
    }
}

