/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.TranslationTableDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ITranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.IComputeProcessor;

public class Translate
extends Compute {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private Integer column;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TranslationTableDeserializer.class)
    @NonNull
    private ITranslationTable translationTable;

    @JsonCreator
    public Translate(@JsonProperty(value="type") String type, @JsonProperty(value="column", required=true) @NonNull Integer column, @JsonProperty(value="translationTable", required=true) @NonNull ITranslationTable translationTable) {
        super(type);
        if (column == null) {
            throw new IllegalArgumentException("column is marked non-null but is null");
        }
        if (translationTable == null) {
            throw new IllegalArgumentException("translationTable is marked non-null but is null");
        }
        this.column = column;
        this.translationTable = translationTable;
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- column=", this.column);
        StringHelper.addNonNull(stringJoiner, "- translationTable=", this.translationTable);
        return stringJoiner.toString();
    }

    @Override
    public Translate copy() {
        return Translate.builder().type(this.type).column(this.column).translationTable(this.translationTable).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.translationTable.update(updater);
    }

    @Override
    public void accept(IComputeProcessor computeProcessor) {
        computeProcessor.process(this);
    }

    @Generated
    public static TranslateBuilder builder() {
        return new TranslateBuilder();
    }

    @NonNull
    @Generated
    public Integer getColumn() {
        return this.column;
    }

    @NonNull
    @Generated
    public ITranslationTable getTranslationTable() {
        return this.translationTable;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setColumn(@NonNull Integer column) {
        if (column == null) {
            throw new IllegalArgumentException("column is marked non-null but is null");
        }
        this.column = column;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TranslationTableDeserializer.class)
    @Generated
    public void setTranslationTable(@NonNull ITranslationTable translationTable) {
        if (translationTable == null) {
            throw new IllegalArgumentException("translationTable is marked non-null but is null");
        }
        this.translationTable = translationTable;
    }

    @Generated
    public Translate() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Translate)) {
            return false;
        }
        Translate other = (Translate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$column = this.getColumn();
        Integer other$column = other.getColumn();
        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
            return false;
        }
        ITranslationTable this$translationTable = this.getTranslationTable();
        ITranslationTable other$translationTable = other.getTranslationTable();
        return !(this$translationTable == null ? other$translationTable != null : !this$translationTable.equals(other$translationTable));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Translate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        ITranslationTable $translationTable = this.getTranslationTable();
        result = result * 59 + ($translationTable == null ? 43 : $translationTable.hashCode());
        return result;
    }

    @Generated
    public static class TranslateBuilder {
        @Generated
        private String type;
        @Generated
        private Integer column;
        @Generated
        private ITranslationTable translationTable;

        @Generated
        TranslateBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public TranslateBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="column", required=true)
        @Generated
        public TranslateBuilder column(@NonNull Integer column) {
            if (column == null) {
                throw new IllegalArgumentException("column is marked non-null but is null");
            }
            this.column = column;
            return this;
        }

        @JsonProperty(value="translationTable", required=true)
        @Generated
        public TranslateBuilder translationTable(@NonNull ITranslationTable translationTable) {
            if (translationTable == null) {
                throw new IllegalArgumentException("translationTable is marked non-null but is null");
            }
            this.translationTable = translationTable;
            return this;
        }

        @Generated
        public Translate build() {
            return new Translate(this.type, this.column, this.translationTable);
        }

        @Generated
        public String toString() {
            return "Translate.TranslateBuilder(type=" + this.type + ", column=" + this.column + ", translationTable=" + String.valueOf(this.translationTable) + ")";
        }
    }
}

