/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.common.IEntryConcatMethod;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CopySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.InternalDbQuerySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.JawkSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SqlSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.StaticSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableJoinSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableUnionSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CopySource.class, name="copy"), @JsonSubTypes.Type(value=HttpSource.class, name="http"), @JsonSubTypes.Type(value=IpmiSource.class, name="ipmi"), @JsonSubTypes.Type(value=CommandLineSource.class, name="commandLine"), @JsonSubTypes.Type(value=JawkSource.class, name="awk"), @JsonSubTypes.Type(value=SnmpGetSource.class, name="snmpGet"), @JsonSubTypes.Type(value=SnmpTableSource.class, name="snmpTable"), @JsonSubTypes.Type(value=InternalDbQuerySource.class, name="internalDbQuery"), @JsonSubTypes.Type(value=StaticSource.class, name="static"), @JsonSubTypes.Type(value=TableJoinSource.class, name="tableJoin"), @JsonSubTypes.Type(value=TableUnionSource.class, name="tableUnion"), @JsonSubTypes.Type(value=WbemSource.class, name="wbem"), @JsonSubTypes.Type(value=WmiSource.class, name="wmi"), @JsonSubTypes.Type(value=SqlSource.class, name="sql")})
public abstract class Source
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String type;
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Compute> computes = new ArrayList<Compute>();
    protected boolean forceSerialization;
    protected String key;
    protected ExecuteForEachEntryOf executeForEachEntryOf;
    private Set<String> references = new HashSet<String>();

    protected Source(String type, List<Compute> computes, boolean forceSerialization, String key, ExecuteForEachEntryOf executeForEachEntryOf) {
        this.type = type;
        this.computes = computes == null ? new ArrayList() : computes;
        this.forceSerialization = forceSerialization;
        this.key = key;
        this.executeForEachEntryOf = executeForEachEntryOf;
        this.references = new HashSet<String>();
    }

    public abstract Source copy();

    public abstract void update(UnaryOperator<String> var1);

    public abstract SourceTable accept(ISourceProcessor var1);

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(new StringBuilder("- ").append(this.key).append(".type=").append(this.getClass().getSimpleName()));
        StringHelper.addNonNull(stringJoiner, "- forceSerialization=", this.forceSerialization);
        StringHelper.addNonNull(stringJoiner, "", this.executeForEachEntryOf != null ? this.executeForEachEntryOf.toString() : null);
        return stringJoiner.toString();
    }

    public boolean isExecuteForEachEntryOf() {
        return this.executeForEachEntryOf != null && this.executeForEachEntryOf.getSource() != null && !this.executeForEachEntryOf.getSource().isBlank();
    }

    public IEntryConcatMethod getEntryConcatMethod() {
        return this.executeForEachEntryOf != null ? this.executeForEachEntryOf.getConcatMethod() : null;
    }

    public String getExecuteForEachEntryOf() {
        return this.executeForEachEntryOf != null ? this.executeForEachEntryOf.getSource() : null;
    }

    public Integer getSleepExecuteForEachEntryOf() {
        return this.executeForEachEntryOf != null ? this.executeForEachEntryOf.getSleep() : null;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public List<Compute> getComputes() {
        return this.computes;
    }

    @Generated
    public boolean isForceSerialization() {
        return this.forceSerialization;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Set<String> getReferences() {
        return this.references;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setComputes(List<Compute> computes) {
        this.computes = computes;
    }

    @Generated
    public void setForceSerialization(boolean forceSerialization) {
        this.forceSerialization = forceSerialization;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setExecuteForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
        this.executeForEachEntryOf = executeForEachEntryOf;
    }

    @Generated
    public void setReferences(Set<String> references) {
        this.references = references;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForceSerialization() != other.isForceSerialization()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Compute> this$computes = this.getComputes();
        List<Compute> other$computes = other.getComputes();
        if (this$computes == null ? other$computes != null : !((Object)this$computes).equals(other$computes)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$executeForEachEntryOf = this.getExecuteForEachEntryOf();
        String other$executeForEachEntryOf = other.getExecuteForEachEntryOf();
        if (this$executeForEachEntryOf == null ? other$executeForEachEntryOf != null : !this$executeForEachEntryOf.equals(other$executeForEachEntryOf)) {
            return false;
        }
        Set<String> this$references = this.getReferences();
        Set<String> other$references = other.getReferences();
        return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Source;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceSerialization() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Compute> $computes = this.getComputes();
        result = result * 59 + ($computes == null ? 43 : ((Object)$computes).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $executeForEachEntryOf = this.getExecuteForEachEntryOf();
        result = result * 59 + ($executeForEachEntryOf == null ? 43 : $executeForEachEntryOf.hashCode());
        Set<String> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        return result;
    }

    @Generated
    public Source() {
    }
}

