/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.identity.criterion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.StringJoiner;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public class SqlCriterion
extends Criterion {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String query;
    private String expectedResult;
    private String errorMessage;

    @JsonCreator
    public SqlCriterion(@JsonProperty(value="type") String type, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="query") @NonNull String query, @JsonProperty(value="expectedResult") String expectedResult, @JsonProperty(value="errorMessage") String errorMessage) {
        super(type, forceSerialization);
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
        this.expectedResult = expectedResult;
        this.errorMessage = errorMessage;
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(new StringBuilder("- Query ").append(this.query));
        if (this.expectedResult != null && !this.expectedResult.isBlank()) {
            stringJoiner.add(new StringBuilder("- ExpectedResult: ").append(this.expectedResult));
        }
        if (this.errorMessage != null && !this.errorMessage.isBlank()) {
            stringJoiner.add(new StringBuilder("- ErrorMessage: ").append(this.errorMessage));
        }
        return stringJoiner.toString();
    }

    @Generated
    public static SqlCriterionBuilder builder() {
        return new SqlCriterionBuilder();
    }

    @NonNull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getExpectedResult() {
        return this.expectedResult;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setQuery(@NonNull String query) {
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
    }

    @Generated
    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public SqlCriterion() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlCriterion)) {
            return false;
        }
        SqlCriterion other = (SqlCriterion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$expectedResult = this.getExpectedResult();
        String other$expectedResult = other.getExpectedResult();
        if (this$expectedResult == null ? other$expectedResult != null : !this$expectedResult.equals(other$expectedResult)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlCriterion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $expectedResult = this.getExpectedResult();
        result = result * 59 + ($expectedResult == null ? 43 : $expectedResult.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @Generated
    public static class SqlCriterionBuilder {
        @Generated
        private String type;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String query;
        @Generated
        private String expectedResult;
        @Generated
        private String errorMessage;

        @Generated
        SqlCriterionBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public SqlCriterionBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public SqlCriterionBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="query")
        @Generated
        public SqlCriterionBuilder query(@NonNull String query) {
            if (query == null) {
                throw new IllegalArgumentException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        @JsonProperty(value="expectedResult")
        @Generated
        public SqlCriterionBuilder expectedResult(String expectedResult) {
            this.expectedResult = expectedResult;
            return this;
        }

        @JsonProperty(value="errorMessage")
        @Generated
        public SqlCriterionBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Generated
        public SqlCriterion build() {
            return new SqlCriterion(this.type, this.forceSerialization, this.query, this.expectedResult, this.errorMessage);
        }

        @Generated
        public String toString() {
            return "SqlCriterion.SqlCriterionBuilder(type=" + this.type + ", forceSerialization=" + this.forceSerialization + ", query=" + this.query + ", expectedResult=" + this.expectedResult + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

