/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;

public class EmbeddedFile
implements Serializable {
    private static final long serialVersionUID = -197665338834839387L;
    private byte[] content;
    private String filename;
    private Integer id;

    public EmbeddedFile copy() {
        return EmbeddedFile.builder().content(this.content).filename(this.filename).id(this.id).build();
    }

    public String description() {
        return String.format("EmbeddedFile %d: %s", this.id, this.filename != null ? this.filename : "<inline>");
    }

    public void update(UnaryOperator<String> updater) {
        if (this.content != null) {
            this.content = ((String)updater.apply(this.getContentAsString())).getBytes(StandardCharsets.UTF_8);
        }
    }

    public static EmbeddedFile fromString(@NonNull String value, @NonNull Charset charset) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is marked non-null but is null");
        }
        return EmbeddedFile.builder().content(value.getBytes(charset)).build();
    }

    public static EmbeddedFile fromString(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        return EmbeddedFile.fromString(value, StandardCharsets.UTF_8);
    }

    public String getContentAsString(@NonNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is marked non-null but is null");
        }
        return new String(this.content, charset);
    }

    public String getContentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public String getFileExtension() {
        if (this.filename != null) {
            return FileHelper.getExtension(this.filename);
        }
        return "";
    }

    public String getBaseName() {
        if (this.filename != null) {
            return FileHelper.getBaseName(this.filename);
        }
        return "";
    }

    @Generated
    public static EmbeddedFileBuilder builder() {
        return new EmbeddedFileBuilder();
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddedFile)) {
            return false;
        }
        EmbeddedFile other = (EmbeddedFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmbeddedFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmbeddedFile(content=" + Arrays.toString(this.getContent()) + ", filename=" + this.getFilename() + ", id=" + this.getId() + ")";
    }

    @Generated
    public EmbeddedFile(byte[] content, String filename, Integer id) {
        this.content = content;
        this.filename = filename;
        this.id = id;
    }

    @Generated
    public EmbeddedFile() {
    }

    @Generated
    public static class EmbeddedFileBuilder {
        @Generated
        private byte[] content;
        @Generated
        private String filename;
        @Generated
        private Integer id;

        @Generated
        EmbeddedFileBuilder() {
        }

        @Generated
        public EmbeddedFileBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        @Generated
        public EmbeddedFileBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Generated
        public EmbeddedFileBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @Generated
        public EmbeddedFile build() {
            return new EmbeddedFile(this.content, this.filename, this.id);
        }

        @Generated
        public String toString() {
            return "EmbeddedFile.EmbeddedFileBuilder(content=" + Arrays.toString(this.content) + ", filename=" + this.filename + ", id=" + this.id + ")";
        }
    }
}

