/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class VersionHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionHelper.class);
    private static final String VERSION_REGEX_DELIMITER = "\\.";

    private VersionHelper() {
    }

    public static String getClassVersion() {
        ClassPathResource resource = new ClassPathResource("engine.properties");
        Properties properties = new Properties();
        try {
            InputStream inputStream = resource.getInputStream();
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException ioException) {
            log.error(ioException.getMessage(), (Throwable)ioException);
        }
        return properties.getProperty("engine.version");
    }

    public static boolean isVersionLessThanOtherVersion(String version, String otherVersion) {
        return VersionHelper.compareVersions(version, otherVersion) < 0;
    }

    public static int compareVersions(String version1, String version2) {
        version1 = VersionHelper.normalizeVersion(version1);
        version2 = VersionHelper.normalizeVersion(version2);
        String[] version1Splits = version1.split(VERSION_REGEX_DELIMITER);
        String[] version2Splits = version2.split(VERSION_REGEX_DELIMITER);
        int maxLengthOfVersionSplits = Math.max(version1Splits.length, version2Splits.length);
        for (int i = 0; i < maxLengthOfVersionSplits; ++i) {
            Integer v2;
            Integer v1 = i < version1Splits.length ? Integer.parseInt(version1Splits[i]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i < version2Splits.length ? Integer.parseInt(version2Splits[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static String normalizeVersion(String version) {
        if (version == null) {
            return "0";
        }
        String normalized = version.replaceAll("[^\\d\\.]", "");
        return normalized.trim().isEmpty() ? "0" : normalized;
    }
}

