/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.MacrosUpdater;

public enum EscapeType {
    JSON(MacrosUpdater::escapeJsonSpecialCharacters),
    XML(MacrosUpdater::escapeXmlSpecialCharacters),
    URL(MacrosUpdater::escapeUrlSpecialCharacters),
    REGEX(MacrosUpdater::escapeRegexSpecialCharacters),
    WINDOWS(MacrosUpdater::escapeWindowsCmdSpecialCharacters),
    CMD(MacrosUpdater::escapeWindowsCmdSpecialCharacters),
    POWERSHELL(MacrosUpdater::escapePowershellSpecialCharacters),
    LINUX(MacrosUpdater::escapeBashSpecialCharacters),
    BASH(MacrosUpdater::escapeBashSpecialCharacters),
    SQL(MacrosUpdater::escapeSqlSpecialCharacters);

    private final UnaryOperator<String> escapeFunction;

    public String escape(String input) {
        return (String)this.escapeFunction.apply(input);
    }

    public static EscapeType fromString(String escapeType) {
        for (EscapeType type : EscapeType.values()) {
            if (!type.name().equalsIgnoreCase(escapeType)) continue;
            return type;
        }
        return null;
    }

    @Generated
    private EscapeType(UnaryOperator<String> escapeFunction) {
        this.escapeFunction = escapeFunction;
    }
}

