/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.jrt;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sentrysoftware.jawk.intermediate.UninitializedObject;
import org.sentrysoftware.jawk.jrt.AssocArray;
import org.sentrysoftware.jawk.jrt.AwkRuntimeException;
import org.sentrysoftware.jawk.jrt.CharacterTokenizer;
import org.sentrysoftware.jawk.jrt.DataPump;
import org.sentrysoftware.jawk.jrt.PartitioningReader;
import org.sentrysoftware.jawk.jrt.RegexTokenizer;
import org.sentrysoftware.jawk.jrt.SingleCharacterTokenizer;
import org.sentrysoftware.jawk.jrt.VariableManager;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.slf4j.Logger;

public class JRT {
    private static final Logger LOG = AwkLogger.getLogger(JRT.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").indexOf("Windows") >= 0;
    private VariableManager vm;
    private Map<String, Process> output_processes = new HashMap<String, Process>();
    private Map<String, PrintStream> output_streams = new HashMap<String, PrintStream>();
    private PartitioningReader partitioningReader = null;
    private String inputLine = null;
    private List<String> input_fields = new ArrayList<String>(100);
    private AssocArray arglist_aa = null;
    private int arglist_idx;
    private boolean has_filenames = false;
    private static final UninitializedObject BLANK = new UninitializedObject();
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;
    private static final Integer MINUS_ONE = -1;
    private String jrt_input_string;
    private Map<String, PartitioningReader> file_readers = new HashMap<String, PartitioningReader>();
    private Map<String, PartitioningReader> command_readers = new HashMap<String, PartitioningReader>();
    private Map<String, Process> command_processes = new HashMap<String, Process>();
    private Map<String, PrintStream> outputFiles = new HashMap<String, PrintStream>();

    public JRT(VariableManager vm) {
        this.vm = vm;
    }

    public final void assignInitialVariables(Map<String, Object> initial_var_map) {
        assert (initial_var_map != null);
        for (Map.Entry<String, Object> var2 : initial_var_map.entrySet()) {
            this.vm.assignVariable(var2.getKey(), var2.getValue());
        }
    }

    public static void assignEnvironmentVariables(AssocArray aa) {
        assert (aa.keySet().isEmpty());
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> var2 : env.entrySet()) {
            aa.put(var2.getKey(), (Object)var2.getValue());
        }
    }

    public static String toAwkString(Object o, String convfmt, Locale locale) {
        if (o instanceof Number) {
            double d = ((Number)o).doubleValue();
            if (d == (double)((long)d)) {
                return Long.toString((long)d);
            }
            try {
                String s = String.format(locale, convfmt, d);
                if ((s.indexOf(46) > -1 || s.indexOf(44) > -1) && s.indexOf(101) + s.indexOf(69) == -2) {
                    while (s.endsWith("0")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (s.endsWith(".") || s.endsWith(",")) {
                        s = s.substring(0, s.length() - 1);
                    }
                }
                return s;
            }
            catch (UnknownFormatConversionException ufce) {
                return "";
            }
        }
        return o.toString();
    }

    public static String toAwkStringForOutput(Object o, String ofmt, Locale locale) {
        if (!(o instanceof Number)) {
            try {
                o = Double.parseDouble(o.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return JRT.toAwkString(o, ofmt, locale);
    }

    public static double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        String s = o.toString();
        int length = s.length();
        if (length > 26) {
            length = 26;
        }
        while (length > 0) {
            try {
                return Double.parseDouble(s.substring(0, length));
            }
            catch (NumberFormatException nfe) {
                --length;
            }
        }
        return 0.0;
    }

    public static long toLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        String s = o.toString();
        int length = s.length();
        if (length > 20) {
            length = 20;
        }
        while (length > 0) {
            try {
                return Long.parseLong(s.substring(0, length));
            }
            catch (NumberFormatException nfe) {
                --length;
            }
        }
        return 0L;
    }

    public static boolean compare2(Object o1, Object o2, int mode) {
        char o2FirstChar;
        char o1FirstChar;
        String o1String = o1.toString();
        String o2String = o2.toString();
        if (o1 instanceof UninitializedObject) {
            if (o2 instanceof UninitializedObject || "".equals(o2String) || "0".equals(o2String)) {
                return mode == 0;
            }
            return mode < 0;
        }
        if (o2 instanceof UninitializedObject) {
            if ("".equals(o1String) || "0".equals(o1String)) {
                return mode == 0;
            }
            return mode > 0;
        }
        if (!(o1 instanceof Number) && !o1String.isEmpty() && (o1FirstChar = o1String.charAt(0)) >= '0' && o1FirstChar <= '9') {
            try {
                o1 = Double.parseDouble(o1String);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!(o2 instanceof Number) && !o2String.isEmpty() && (o2FirstChar = o2String.charAt(0)) >= '0' && o2FirstChar <= '9') {
            try {
                o2 = Double.parseDouble(o2String);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (mode < 0) {
                return ((Number)o1).doubleValue() < ((Number)o2).doubleValue();
            }
            if (mode == 0) {
                return ((Number)o1).doubleValue() == ((Number)o2).doubleValue();
            }
            return ((Number)o1).doubleValue() > ((Number)o2).doubleValue();
        }
        if (mode == 0) {
            return o1String.equals(o2String);
        }
        if (mode < 0) {
            return o1String.compareTo(o2String) < 0;
        }
        return o1String.compareTo(o2String) > 0;
    }

    public static Object inc(Object o) {
        double ans;
        assert (o != null);
        if (o instanceof Number) {
            ans = ((Number)o).doubleValue() + 1.0;
        } else {
            try {
                ans = Double.parseDouble(o.toString()) + 1.0;
            }
            catch (NumberFormatException nfe) {
                ans = 1.0;
            }
        }
        if (ans == (double)((long)ans)) {
            return (long)ans;
        }
        return ans;
    }

    public static Object dec(Object o) {
        double ans;
        if (o instanceof Number) {
            ans = ((Number)o).doubleValue() - 1.0;
        } else {
            try {
                ans = Double.parseDouble(o.toString()) - 1.0;
            }
            catch (NumberFormatException nfe) {
                ans = 1.0;
            }
        }
        if (ans == (double)((long)ans)) {
            return (long)ans;
        }
        return ans;
    }

    public final boolean toBoolean(Object o) {
        boolean val2;
        if (o instanceof Integer) {
            val2 = (Integer)o != 0;
        } else if (o instanceof Long) {
            val2 = (Long)o != 0L;
        } else if (o instanceof Double) {
            val2 = (Double)o != 0.0;
        } else if (o instanceof String) {
            val2 = o.toString().length() > 0;
        } else if (o instanceof UninitializedObject) {
            val2 = false;
        } else if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            String s = this.inputLine == null ? "" : this.inputLine;
            Matcher matcher = pattern.matcher(s);
            val2 = matcher.find();
        } else {
            throw new Error("Unknown operand_stack type: " + o.getClass() + " for value " + o);
        }
        return val2;
    }

    public static int split(Object array, Object string, String convfmt, Locale locale) {
        return JRT.splitWorker(new StringTokenizer(JRT.toAwkString(string, convfmt, locale)), (AssocArray)array);
    }

    public static int split(Object fs, Object array, Object string, String convfmt, Locale locale) {
        String fs_string = JRT.toAwkString(fs, convfmt, locale);
        if (fs_string.equals(" ")) {
            return JRT.splitWorker(new StringTokenizer(JRT.toAwkString(string, convfmt, locale)), (AssocArray)array);
        }
        if (fs_string.equals("")) {
            return JRT.splitWorker(new CharacterTokenizer(JRT.toAwkString(string, convfmt, locale)), (AssocArray)array);
        }
        if (fs_string.length() == 1) {
            return JRT.splitWorker(new SingleCharacterTokenizer(JRT.toAwkString(string, convfmt, locale), fs_string.charAt(0)), (AssocArray)array);
        }
        return JRT.splitWorker(new RegexTokenizer(JRT.toAwkString(string, convfmt, locale), fs_string), (AssocArray)array);
    }

    private static int splitWorker(Enumeration<Object> e, AssocArray aa) {
        int cnt = 0;
        aa.clear();
        while (e.hasMoreElements()) {
            aa.put(++cnt, e.nextElement());
        }
        return cnt;
    }

    public PartitioningReader getPartitioningReader() {
        return this.partitioningReader;
    }

    public String getInputLine() {
        return this.inputLine;
    }

    public void setInputLine(String inputLine) {
        this.inputLine = inputLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean jrtConsumeInput(InputStream input, boolean for_getline, Locale locale) throws IOException {
        if (this.arglist_aa == null) {
            Object arglist_obj = this.vm.getARGV();
            this.arglist_aa = (AssocArray)arglist_obj;
            this.arglist_idx = 1;
            int argc = (int)JRT.toDouble(this.vm.getARGC());
            for (long i = 1L; i < (long)argc; ++i) {
                Object namevalue_or_filename_object;
                String namevalue_or_filename;
                if (!this.arglist_aa.isIn(i) || (namevalue_or_filename = JRT.toAwkString(namevalue_or_filename_object = this.arglist_aa.get(i), this.vm.getCONVFMT().toString(), locale)).indexOf(61) != -1) continue;
                this.has_filenames = true;
                break;
            }
        }
        while (true) {
            try {
                while (true) {
                    if (this.partitioningReader == null) {
                        int argc = (int)JRT.toDouble(this.vm.getARGC());
                        Object o = BLANK;
                        while (this.arglist_idx <= argc) {
                            o = this.arglist_aa.get(this.arglist_idx);
                            ++this.arglist_idx;
                            if (o instanceof UninitializedObject || o.toString().isEmpty()) continue;
                        }
                        if (!(o instanceof UninitializedObject) && !o.toString().isEmpty()) {
                            String name_value_or_filename = JRT.toAwkString(o, this.vm.getCONVFMT().toString(), locale);
                            if (name_value_or_filename.indexOf(61) == -1) {
                                this.partitioningReader = new PartitioningReader(new FileReader(name_value_or_filename), this.vm.getRS().toString(), true);
                                this.vm.setFILENAME(name_value_or_filename);
                                this.vm.resetFNR();
                            } else {
                                this.setFilelistVariable(name_value_or_filename);
                                if (this.has_filenames) continue;
                                this.partitioningReader = new PartitioningReader(new InputStreamReader(input), this.vm.getRS().toString());
                                this.vm.setFILENAME("");
                            }
                        } else {
                            if (this.has_filenames) return false;
                            this.partitioningReader = new PartitioningReader(new InputStreamReader(input), this.vm.getRS().toString());
                            this.vm.setFILENAME("");
                        }
                    } else if (this.inputLine == null) {
                        if (!this.has_filenames) return false;
                        int argc = (int)JRT.toDouble(this.vm.getARGC());
                        Object o = BLANK;
                        while (this.arglist_idx <= argc) {
                            o = this.arglist_aa.get(this.arglist_idx);
                            ++this.arglist_idx;
                            if (o instanceof UninitializedObject || o.toString().isEmpty()) continue;
                        }
                        if (o instanceof UninitializedObject || o.toString().isEmpty()) return false;
                        String name_value_or_filename = JRT.toAwkString(o, this.vm.getCONVFMT().toString(), locale);
                        if (name_value_or_filename.indexOf(61) == -1) {
                            this.partitioningReader = new PartitioningReader(new FileReader(name_value_or_filename), this.vm.getRS().toString(), true);
                            this.vm.setFILENAME(name_value_or_filename);
                            this.vm.resetFNR();
                        } else {
                            this.setFilelistVariable(name_value_or_filename);
                            this.vm.incNR();
                            continue;
                        }
                    }
                    this.inputLine = this.partitioningReader.readRecord();
                    if (this.inputLine != null) break;
                }
                if (!for_getline) {
                    this.jrtParseFields();
                }
                this.vm.incNR();
                if (!this.partitioningReader.fromFilenameList()) return true;
                this.vm.incFNR();
                return true;
            }
            catch (IOException ioe) {
                LOG.warn("IO Exception", (Throwable)ioe);
                continue;
            }
            break;
        }
    }

    private void setFilelistVariable(String name_value) {
        Object obj;
        int eq_idx = name_value.indexOf(61);
        assert (eq_idx >= 0);
        if (eq_idx == 0) {
            throw new IllegalArgumentException("Must have a non-blank variable name in a name=value variable assignment argument.");
        }
        String name = name_value.substring(0, eq_idx);
        String value = name_value.substring(eq_idx + 1);
        try {
            obj = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            try {
                obj = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe2) {
                obj = value;
            }
        }
        this.vm.assignVariable(name, obj);
    }

    public void jrtParseFields() {
        String fs_string = this.vm.getFS().toString();
        Enumeration<Object> tokenizer = fs_string.equals(" ") ? new StringTokenizer(this.inputLine) : (fs_string.length() == 1 ? new SingleCharacterTokenizer(this.inputLine, fs_string.charAt(0)) : (fs_string.equals("") ? new CharacterTokenizer(this.inputLine) : new RegexTokenizer(this.inputLine, fs_string)));
        assert (this.inputLine != null);
        this.input_fields.clear();
        this.input_fields.add(this.inputLine);
        while (tokenizer.hasMoreElements()) {
            this.input_fields.add((String)tokenizer.nextElement());
        }
        this.recalculateNF();
    }

    private void recalculateNF() {
        this.vm.setNF(this.input_fields.size() - 1);
    }

    private static int toFieldNumber(Object o) {
        int fieldnum;
        if (o instanceof Number) {
            fieldnum = ((Number)o).intValue();
        } else {
            try {
                fieldnum = (int)Double.parseDouble(o.toString());
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Field $(" + o.toString() + ") is incorrect.");
            }
        }
        return fieldnum;
    }

    public Object jrtGetInputField(Object fieldnum_obj) {
        return this.jrtGetInputField(JRT.toFieldNumber(fieldnum_obj));
    }

    public Object jrtGetInputField(int fieldnum) {
        if (fieldnum < this.input_fields.size()) {
            String retval = this.input_fields.get(fieldnum);
            assert (retval != null);
            return retval;
        }
        return BLANK;
    }

    public String jrtSetInputField(Object value_obj, int field_num) {
        assert (field_num >= 1);
        assert (value_obj != null);
        String value = value_obj.toString();
        if (value_obj instanceof UninitializedObject) {
            if (field_num < this.input_fields.size()) {
                this.input_fields.set(field_num, "");
            }
        } else {
            for (int i = this.input_fields.size() - 1; i < field_num; ++i) {
                this.input_fields.add("");
            }
            this.input_fields.set(field_num, value);
        }
        this.rebuildDollarZeroFromFields();
        this.recalculateNF();
        return value;
    }

    private void rebuildDollarZeroFromFields() {
        StringBuilder new_dollar_zero_sb = new StringBuilder();
        String ofs = this.vm.getOFS().toString();
        for (int i = 1; i < this.input_fields.size(); ++i) {
            if (i > 1) {
                new_dollar_zero_sb.append(ofs);
            }
            new_dollar_zero_sb.append(this.input_fields.get(i));
        }
        this.input_fields.set(0, new_dollar_zero_sb.toString());
    }

    public Integer jrtConsumeFileInputForGetline(String filename) {
        try {
            if (this.jrtConsumeFileInput(filename)) {
                return ONE;
            }
            this.jrt_input_string = "";
            return ZERO;
        }
        catch (IOException ioe) {
            this.jrt_input_string = "";
            return MINUS_ONE;
        }
    }

    public Integer jrtConsumeCommandInputForGetline(String cmd_string) {
        try {
            if (this.jrtConsumeCommandInput(cmd_string)) {
                return ONE;
            }
            this.jrt_input_string = "";
            return ZERO;
        }
        catch (IOException ioe) {
            this.jrt_input_string = "";
            return MINUS_ONE;
        }
    }

    public String jrtGetInputString() {
        return this.jrt_input_string;
    }

    public Map<String, PrintStream> getOutputFiles() {
        return this.outputFiles;
    }

    public final PrintStream jrtGetPrintStream(String filename, boolean append) {
        PrintStream ps = this.outputFiles.get(filename);
        if (ps == null) {
            try {
                ps = new PrintStream(new FileOutputStream(filename, append), true);
                this.outputFiles.put(filename, ps);
            }
            catch (IOException ioe) {
                throw new AwkRuntimeException("Cannot open " + filename + " for writing: " + ioe);
            }
        }
        assert (ps != null);
        return ps;
    }

    public boolean jrtConsumeFileInput(String filename) throws IOException {
        PartitioningReader pr = this.file_readers.get(filename);
        if (pr == null) {
            try {
                pr = new PartitioningReader(new FileReader(filename), this.vm.getRS().toString());
                this.file_readers.put(filename, pr);
                this.vm.setFILENAME(filename);
            }
            catch (IOException ioe) {
                LOG.warn("IO Exception", (Throwable)ioe);
                this.file_readers.remove(filename);
                throw ioe;
            }
        }
        this.inputLine = pr.readRecord();
        if (this.inputLine == null) {
            return false;
        }
        this.jrt_input_string = this.inputLine;
        this.vm.incNR();
        return true;
    }

    private static Process spawnProcess(String cmd) throws IOException {
        Process p;
        if (IS_WINDOWS) {
            ProcessBuilder pb = new ProcessBuilder(("cmd.exe /c " + cmd).split("[ \t]+"));
            p = pb.start();
        } else {
            ProcessBuilder pb = new ProcessBuilder(cmd.split("[ \t]+"));
            p = pb.start();
        }
        return p;
    }

    public boolean jrtConsumeCommandInput(String cmd) throws IOException {
        PartitioningReader pr = this.command_readers.get(cmd);
        if (pr == null) {
            try {
                Process p = JRT.spawnProcess(cmd);
                p.getOutputStream().close();
                DataPump.dump(cmd, p.getErrorStream(), System.err);
                this.command_processes.put(cmd, p);
                pr = new PartitioningReader(new InputStreamReader(p.getInputStream()), this.vm.getRS().toString());
                this.command_readers.put(cmd, pr);
                this.vm.setFILENAME("");
            }
            catch (IOException ioe) {
                LOG.warn("IO Exception", (Throwable)ioe);
                this.command_readers.remove(cmd);
                Process p = this.command_processes.get(cmd);
                this.command_processes.remove(cmd);
                if (p != null) {
                    p.destroy();
                }
                throw ioe;
            }
        }
        this.inputLine = pr.readRecord();
        if (this.inputLine == null) {
            return false;
        }
        this.jrt_input_string = this.inputLine;
        this.vm.incNR();
        return true;
    }

    public PrintStream jrtSpawnForOutput(String cmd) {
        PrintStream ps = this.output_streams.get(cmd);
        if (ps == null) {
            Process p;
            try {
                p = JRT.spawnProcess(cmd);
                DataPump.dump(cmd, p.getErrorStream(), System.err);
                DataPump.dump(cmd, p.getInputStream(), System.out);
            }
            catch (IOException ioe) {
                throw new AwkRuntimeException("Can't spawn " + cmd + ": " + ioe);
            }
            this.output_processes.put(cmd, p);
            ps = new PrintStream(p.getOutputStream(), true);
            this.output_streams.put(cmd, ps);
        }
        return ps;
    }

    public Integer jrtClose(String filename) {
        boolean b1 = this.jrtCloseFileReader(filename);
        boolean b2 = this.jrtCloseCommandReader(filename);
        boolean b3 = this.jrtCloseOutputFile(filename);
        boolean b4 = this.jrtCloseOutputStream(filename);
        return b1 || b2 || b3 || b4 ? ZERO : MINUS_ONE;
    }

    public void jrtCloseAll() {
        HashSet<String> set = new HashSet<String>();
        for (String s : this.file_readers.keySet()) {
            set.add(s);
        }
        for (String s : this.command_readers.keySet()) {
            set.add(s);
        }
        for (String s : this.outputFiles.keySet()) {
            set.add(s);
        }
        for (String s : this.output_streams.keySet()) {
            set.add(s);
        }
        for (String s : set) {
            this.jrtClose(s);
        }
    }

    private boolean jrtCloseOutputFile(String filename) {
        PrintStream ps = this.outputFiles.get(filename);
        if (ps != null) {
            ps.close();
            this.outputFiles.remove(filename);
        }
        return ps != null;
    }

    private boolean jrtCloseOutputStream(String cmd) {
        Process p = this.output_processes.get(cmd);
        PrintStream ps = this.output_streams.get(cmd);
        if (ps == null) {
            return false;
        }
        assert (p != null);
        this.output_processes.remove(cmd);
        this.output_streams.remove(cmd);
        ps.close();
        if (!IS_WINDOWS) {
            try {
                p.waitFor();
                p.exitValue();
            }
            catch (InterruptedException ie) {
                throw new AwkRuntimeException("Caught exception while waiting for process exit: " + ie);
            }
        }
        return true;
    }

    private boolean jrtCloseFileReader(String filename) {
        PartitioningReader pr = this.file_readers.get(filename);
        if (pr == null) {
            return false;
        }
        this.file_readers.remove(filename);
        try {
            pr.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean jrtCloseCommandReader(String cmd) {
        Process p = this.command_processes.get(cmd);
        PartitioningReader pr = this.command_readers.get(cmd);
        if (pr == null) {
            return false;
        }
        assert (p != null);
        this.command_readers.remove(cmd);
        this.command_processes.remove(cmd);
        try {
            pr.close();
            if (!IS_WINDOWS) {
                try {
                    p.waitFor();
                    p.exitValue();
                }
                catch (InterruptedException ie) {
                    throw new AwkRuntimeException("Caught exception while waiting for process exit: " + ie);
                }
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static Integer jrtSystem(String cmd) {
        try {
            Process p = JRT.spawnProcess(cmd);
            p.getOutputStream().close();
            DataPump.dump(cmd, p.getErrorStream(), System.err);
            DataPump.dump(cmd, p.getInputStream(), System.out);
            try {
                int retcode = p.waitFor();
                return retcode;
            }
            catch (InterruptedException ie) {
                return p.exitValue();
            }
        }
        catch (IOException ioe) {
            LOG.warn("IO Exception", (Throwable)ioe);
            return MINUS_ONE;
        }
    }

    public static String sprintfNoCatch(Locale locale, String fmt_arg, Object ... arr) throws IllegalFormatException {
        return String.format(locale, fmt_arg, arr);
    }

    public static void printfNoCatch(Locale locale, String fmt_arg, Object ... arr) {
        System.out.print(JRT.sprintfNoCatch(locale, fmt_arg, arr));
    }

    public static void printfNoCatch(PrintStream ps, Locale locale, String fmt_arg, Object ... arr) {
        ps.print(JRT.sprintfNoCatch(locale, fmt_arg, arr));
    }

    public static Integer replaceFirst(Object orig_value_obj, Object repl_obj, Object ere_obj, StringBuffer sb, String convfmt, Locale locale) {
        String orig_value = JRT.toAwkString(orig_value_obj, convfmt, locale);
        String repl = JRT.toAwkString(repl_obj, convfmt, locale);
        String ere = JRT.toAwkString(ere_obj, convfmt, locale);
        repl = Matcher.quoteReplacement(repl);
        sb.setLength(0);
        sb.append(orig_value.replaceFirst(ere, repl));
        if (sb.toString().equals(orig_value)) {
            return ZERO;
        }
        return ONE;
    }

    public static Integer replaceAll(Object orig_value_obj, Object repl_obj, Object ere_obj, StringBuffer sb, String convfmt, Locale locale) {
        String orig_value = JRT.toAwkString(orig_value_obj, convfmt, locale);
        String repl = JRT.toAwkString(repl_obj, convfmt, locale);
        String ere = JRT.toAwkString(ere_obj, convfmt, locale);
        repl = Matcher.quoteReplacement(repl);
        sb.setLength(0);
        Pattern p = Pattern.compile(ere);
        Matcher m = p.matcher(orig_value);
        int cnt = 0;
        while (m.find()) {
            ++cnt;
            m.appendReplacement(sb, repl);
        }
        m.appendTail(sb);
        return cnt;
    }

    public static String substr(Object startpos_obj, String str) {
        int startpos = (int)JRT.toDouble(startpos_obj);
        if (startpos <= 0) {
            throw new AwkRuntimeException("2nd arg to substr must be a positive integer");
        }
        if (startpos > str.length()) {
            return "";
        }
        return str.substring(startpos - 1);
    }

    public static String substr(Object size_obj, Object startpos_obj, String str) {
        int startpos = (int)JRT.toDouble(startpos_obj);
        if (startpos <= 0) {
            throw new AwkRuntimeException("2nd arg to substr must be a positive integer");
        }
        if (startpos > str.length()) {
            return "";
        }
        int size = (int)JRT.toDouble(size_obj);
        if (size < 0) {
            throw new AwkRuntimeException("3nd arg to substr must be a non-negative integer");
        }
        if (startpos + size > str.length()) {
            return str.substring(startpos - 1);
        }
        return str.substring(startpos - 1, startpos + size - 1);
    }

    public static int timeSeed() {
        long l = new Date().getTime();
        long l2 = l % 86400000L;
        int seed = (int)l2;
        return seed;
    }

    public static Random newRandom(int seed) {
        return new Random(seed);
    }

    public void applyRS(Object rs_obj) {
        if (this.partitioningReader != null) {
            this.partitioningReader.setRecordSeparator(rs_obj.toString());
        }
    }
}

