/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source.compute;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.FilterResultHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.common.ConversionType;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.connector.model.common.ITranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.common.ReferenceTranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.common.TranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.AbstractConcat;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.AbstractMatchingLines;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Add;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.And;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Append;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ArrayTranslate;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Awk;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Convert;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Divide;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.DuplicateColumn;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ExcludeMatchingLines;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Extract;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ExtractPropertyFromWbemPath;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Json2Csv;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.KeepColumns;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.KeepOnlyMatchingLines;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Multiply;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.PerBitTranslation;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Prepend;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Replace;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Substring;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Subtract;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Translate;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Xml2Csv;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.IComputeProcessor;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeProcessor
implements IComputeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeProcessor.class);
    private TelemetryManager telemetryManager;
    private String connectorId;
    private ClientsExecutor clientsExecutor;
    private String sourceKey;
    private String hostname;
    private SourceTable sourceTable;
    private Integer index;
    private static final Map<Class<? extends Compute>, BiFunction<String, String, String>> MATH_FUNCTIONS_MAP;
    private static final Pattern NUMBER_PATTERN;
    private static final Function<ComputeValue, String> GET_VALUE_FROM_ROW;
    private static final Function<ComputeValue, String> GET_VALUE;

    @Override
    @WithSpan(value="Compute ArrayTranslate Exec")
    public void process(@SpanAttribute(value="compute.definition") ArrayTranslate arrayTranslate) {
        String resultSeparator;
        if (arrayTranslate == null) {
            log.warn("Hostname {} - The Source (Array Translate) to visit is null, the array translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        ITranslationTable translationTable = arrayTranslate.getTranslationTable();
        if (translationTable == null) {
            log.warn("Hostname {} - Translation Table is null, the array translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        Map<String, String> translations = this.findTranslations(translationTable);
        if (translations == null) {
            log.warn("Hostname {} - The Translation Map is null, the array translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int column = arrayTranslate.getColumn();
        if (column < 1) {
            log.warn("Hostname {} - The column number to translate cannot be < 1, the translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int columnIndex = column - 1;
        String arraySeparator = arrayTranslate.getArraySeparator();
        if (arraySeparator == null || "|".equals(arraySeparator)) {
            arraySeparator = "\\|";
        }
        if ((resultSeparator = arrayTranslate.getResultSeparator()) == null) {
            resultSeparator = "|";
        }
        String defaultTranslation = translations.get("default");
        ArrayList<List<String>> resultTable = new ArrayList<List<String>>();
        for (List<String> row : this.sourceTable.getTable()) {
            if (columnIndex >= row.size()) {
                log.warn("Hostname {} - The index of the column is {} but the row size is {}, the translate computation cannot be performed.", new Object[]{this.hostname, column, row.size()});
                return;
            }
            ArrayList<String> resultRow = new ArrayList<String>(row);
            String arrayValue = row.get(columnIndex);
            if (arrayValue != null) {
                String[] splitArrayValue = arrayValue.split(arraySeparator);
                String translatedArrayValue = Arrays.stream(splitArrayValue).map(value -> translations.getOrDefault(value.toLowerCase(), defaultTranslation)).filter(value -> value != null && !value.isBlank()).collect(Collectors.joining(resultSeparator));
                resultRow.set(columnIndex, translatedArrayValue);
            }
            resultTable.add(resultRow);
        }
        this.sourceTable.setTable(resultTable);
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute And Exec")
    public void process(@SpanAttribute(value="compute.definition") And and) {
        if (and == null) {
            log.warn("Hostname {} - Compute Operation (And) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        String operand2 = and.getValue();
        if (and.getColumn() == null || operand2 == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (And) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)and);
            return;
        }
        int columnIndex = and.getColumn() - 1;
        if (columnIndex < 0) {
            log.warn("Hostname {} - The index of the column to which apply the And operation cannot be < 1, the And computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int colOperand2 = ComputeProcessor.getColumnIndex(operand2);
        for (List<String> line : this.sourceTable.getTable()) {
            try {
                if (columnIndex >= line.size()) continue;
                line.set(columnIndex, String.valueOf((long)Double.parseDouble(line.get(columnIndex)) & (colOperand2 == -1 ? (long)Double.parseDouble(operand2) : (long)Double.parseDouble(line.get(colOperand2)))));
            }
            catch (NumberFormatException e) {
                log.warn("Hostname {} - Data is not correctly formatted.", (Object)this.hostname);
            }
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute Add Exec")
    public void process(@SpanAttribute(value="compute.definition") Add add) {
        if (add == null) {
            log.warn("Hostname {} - Compute Operation (Add) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer columnIndex = add.getColumn();
        String operand2 = add.getValue();
        if (columnIndex == null || operand2 == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (Add) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)add);
            return;
        }
        if (columnIndex < 1) {
            log.warn("Hostname {} - The index of the column to add cannot be < 1, the addition computation cannot be performed.", (Object)this.hostname);
            return;
        }
        this.performMathematicalOperation(add, columnIndex, operand2);
    }

    @Override
    @WithSpan(value="Compute Awk Exec")
    public void process(@SpanAttribute(value="compute.definition") Awk awk) {
        Optional<EmbeddedFile> maybeEmbeddedFile;
        if (awk == null) {
            log.warn("Hostname {} - Compute Operation (Awk) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        String script = awk.getScript();
        if (!MetricsHubConstants.FILE_PATTERN.matcher(script).find()) {
            maybeEmbeddedFile = Optional.of(EmbeddedFile.fromString(script));
        } else {
            try {
                maybeEmbeddedFile = EmbeddedFileHelper.findEmbeddedFile(awk.getScript(), this.telemetryManager.getEmbeddedFiles(this.connectorId), this.hostname, this.connectorId);
            }
            catch (Exception exception) {
                log.warn("Hostname {} - Compute Operation (Awk) script {} has not been set correctly, the table remains unchanged.", (Object)this.hostname, (Object)awk);
                return;
            }
        }
        if (maybeEmbeddedFile.isEmpty()) {
            log.warn("Hostname {} - Compute Operation (Awk) script {} embedded file can't be found, the table remains unchanged.", (Object)this.hostname, (Object)awk);
            return;
        }
        String input = this.sourceTable.getRawData() == null || this.sourceTable.getRawData().isEmpty() ? SourceTable.tableToCsv(this.sourceTable.getTable(), ";", true) : this.sourceTable.getRawData();
        String computeKey = String.format("%s -> computes[%d]", this.sourceKey, this.index);
        EmbeddedFile embeddedFile = maybeEmbeddedFile.get();
        String awkScript = embeddedFile.getContentAsString();
        log.debug("Hostname {} - Compute Operation [{}]. AWK Script:\n{}\n", new Object[]{this.hostname, computeKey, awkScript});
        try {
            String awkResult = this.clientsExecutor.executeAwkScript(awkScript, input);
            if (awkResult == null || awkResult.isEmpty()) {
                log.warn("Hostname {} - {} Compute Operation (Awk) result is {}, the table will be empty.", new Object[]{this.hostname, computeKey, awkResult == null ? "null" : "empty"});
                this.sourceTable.setTable(Collections.emptyList());
                return;
            }
            List<String> lines = SourceTable.lineToList(awkResult, "\n");
            List<String> filterLines = FilterResultHelper.filterLines(lines, null, null, awk.getExclude(), awk.getKeep());
            if (awk.getSeparators() == null || awk.getSeparators().isEmpty()) {
                log.info("Hostname {} - No separators indicated in Awk operation, the result remains unchanged.", (Object)this.hostname);
            }
            List<String> awkResultLines = FilterResultHelper.selectedColumns(filterLines, awk.getSeparators(), awk.getSelectColumns() == null ? "" : awk.getSelectColumns().replaceAll("\\s+", ""));
            awkResult = awkResultLines.stream().map(line -> line.endsWith(";") ? line : line + ";").collect(Collectors.joining("\n"));
            this.sourceTable.setRawData(awkResult);
            this.sourceTable.setTable(SourceTable.csvToTable(awkResult, ";"));
        }
        catch (Exception e) {
            ComputeProcessor.logComputeError(this.connectorId, computeKey, "AWK: " + embeddedFile.description(), e, this.hostname);
        }
    }

    @Override
    @WithSpan(value="Compute Convert Exec")
    public void process(@SpanAttribute(value="compute.definition") Convert convert) {
        if (!ComputeProcessor.checkConvert(convert)) {
            log.warn("Hostname {} - The convert {} is not valid, the table remains unchanged.", (Object)this.hostname, (Object)convert);
            return;
        }
        Integer columnIndex = convert.getColumn() - 1;
        ConversionType conversionType = convert.getConversion();
        if (ConversionType.HEX_2_DEC.equals((Object)conversionType)) {
            this.convertHex2Dec(columnIndex);
        } else if (ConversionType.ARRAY_2_SIMPLE_STATUS.equals((Object)conversionType)) {
            this.convertArray2SimpleStatus(columnIndex);
        }
    }

    static boolean checkConvert(Convert convert) {
        return convert != null && convert.getColumn() >= 1;
    }

    void convertHex2Dec(Integer columnIndex) {
        this.sourceTable.getTable().forEach(row -> {
            String value;
            if (columnIndex < row.size() && MetricsHubConstants.HEXA_PATTERN.matcher(value = ((String)row.get(columnIndex)).replace("0x", "").replace(":", "").replaceAll("\\s*", "")).matches()) {
                row.set(columnIndex, String.valueOf(Long.parseLong(value, 16)));
                return;
            }
            log.warn("Hostname {} - Could not perform Hex2Dec conversion compute on row {} at index {}.", new Object[]{this.hostname, row, columnIndex});
        });
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    void convertArray2SimpleStatus(Integer columnIndex) {
        this.sourceTable.getTable().forEach(row -> {
            if (columnIndex < row.size()) {
                String value = PslUtils.nthArg((String)row.get(columnIndex), "1-", "|", "\n");
                row.set(columnIndex, ComputeProcessor.getWorstStatus(value.split("\n")));
            }
            log.warn("Hostname {} - Could not perform Array2SimpleStatus conversion compute on row {} at index {}.", new Object[]{this.hostname, row, columnIndex});
        });
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    static String getWorstStatus(String[] values) {
        String status = "UNKNOWN";
        for (String value : values) {
            if ("failed".equalsIgnoreCase(value)) {
                return "failed";
            }
            if ("degraded".equalsIgnoreCase(value)) {
                status = "degraded";
                continue;
            }
            if (!"ok".equalsIgnoreCase(value) || !"UNKNOWN".equals(status)) continue;
            status = "ok";
        }
        return status;
    }

    @Override
    @WithSpan(value="Compute Divide Exec")
    public void process(@SpanAttribute(value="compute.definition") Divide divide) {
        if (divide == null) {
            log.warn("Hostname {} - Compute Operation (Divide) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        if (divide.getColumn() == null || divide.getValue() == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (Divide) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)divide);
            return;
        }
        Integer columnIndex = divide.getColumn();
        String divideBy = divide.getValue();
        if (columnIndex < 1) {
            log.warn("Hostname {} - The index of the column to divide cannot be < 1, the division computation cannot be performed.", (Object)this.hostname);
            return;
        }
        this.performMathematicalOperation(divide, columnIndex, divideBy);
    }

    @Override
    @WithSpan(value="Compute DuplicateColumn Exec")
    public void process(@SpanAttribute(value="compute.definition") DuplicateColumn duplicateColumn) {
        if (duplicateColumn == null) {
            log.warn("Hostname {} - Duplicate Column object is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        if (duplicateColumn.getColumn() == null || duplicateColumn.getColumn() == 0) {
            log.warn("Hostname {} - The column index in DuplicateColumn cannot be null or 0, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        int columnIndex = duplicateColumn.getColumn() - 1;
        for (List<String> elementList : this.sourceTable.getTable()) {
            if (columnIndex < 0 || columnIndex >= elementList.size()) continue;
            elementList.add(columnIndex, elementList.get(columnIndex));
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute ExcludeMatchingLines Exec")
    public void process(@SpanAttribute(value="compute.definition") ExcludeMatchingLines excludeMatchingLines) {
        this.processAbstractMatchingLines(excludeMatchingLines);
    }

    private void processAbstractMatchingLines(AbstractMatchingLines abstractMatchingLines) {
        if (this.isConsistentMatchingLinesInfo(abstractMatchingLines)) {
            String pslRegexp;
            int columnIndex = abstractMatchingLines.getColumn() - 1;
            String abstractMatchingLinesValueList = abstractMatchingLines.getValueList();
            Set<String> valueSet = null;
            if (abstractMatchingLinesValueList != null) {
                valueSet = this.buildCaseInsensitiveValueSet(abstractMatchingLinesValueList);
            }
            Predicate<String> pslPredicate = (pslRegexp = abstractMatchingLines.getRegExp()) != null && !pslRegexp.isEmpty() ? this.getPredicate(pslRegexp, abstractMatchingLines) : null;
            Predicate<String> valuePredicate = valueSet != null && !valueSet.isEmpty() ? this.getPredicate(valueSet, abstractMatchingLines) : null;
            List<List<String>> filteredTable = this.sourceTable.getTable().stream().filter(line -> !(columnIndex >= line.size() || pslPredicate != null && !pslPredicate.test((String)line.get(columnIndex)) || valuePredicate != null && !valuePredicate.test((String)line.get(columnIndex)))).collect(Collectors.toList());
            this.sourceTable.setTable(filteredTable);
            this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
        }
    }

    private Set<String> buildCaseInsensitiveValueSet(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (value.indexOf(",") >= 0) {
            return Stream.of(value.split(",")).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        }
        TreeSet<String> singletonSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        singletonSet.add(value);
        return singletonSet;
    }

    private boolean isConsistentMatchingLinesInfo(AbstractMatchingLines abstractMatchingLines) {
        return abstractMatchingLines != null && abstractMatchingLines.getColumn() != null && abstractMatchingLines.getColumn() > 0 && this.sourceTable != null && this.sourceTable.getTable() != null && !this.sourceTable.getTable().isEmpty();
    }

    private Predicate<String> getPredicate(String pslRegexp, AbstractMatchingLines abstractMatchingLines) {
        Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex(pslRegexp), 2);
        return abstractMatchingLines instanceof KeepOnlyMatchingLines ? value -> pattern.matcher((CharSequence)value).find() : value -> !pattern.matcher((CharSequence)value).find();
    }

    private Predicate<String> getPredicate(Set<String> valueSet, AbstractMatchingLines abstractMatchingLines) {
        return abstractMatchingLines instanceof KeepOnlyMatchingLines ? value -> value != null && valueSet.contains(value) : value -> value != null && !valueSet.contains(value);
    }

    @Override
    @WithSpan(value="Compute Extract Exec")
    public void process(@SpanAttribute(value="compute.definition") Extract extract) {
        if (extract == null) {
            log.warn("Hostname {} - Extract object is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer column = extract.getColumn();
        if (column == null || column < 1) {
            log.warn("Hostname {} - The column number in Extract cannot be {}, the table remains unchanged.", (Object)this.hostname, (Object)column);
            return;
        }
        Integer subColumn = extract.getSubColumn();
        if (subColumn == null || subColumn < 1) {
            log.warn("Hostname {} - The sub-column number in Extract cannot be {}, the table remains unchanged.", (Object)this.hostname, (Object)subColumn);
            return;
        }
        String subSeparators = extract.getSubSeparators();
        if (subSeparators == null || subSeparators.isEmpty()) {
            log.warn("Hostname {} - The sub-columns separators in Extract cannot be null or empty, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        int columnIndex = column - 1;
        ArrayList<List<String>> resultTable = new ArrayList<List<String>>();
        for (List<String> row : this.sourceTable.getTable()) {
            if (columnIndex >= row.size()) {
                log.warn("Hostname {} - Invalid column index: {}. The table remains unchanged.", (Object)this.hostname, (Object)column);
                return;
            }
            String text = row.get(columnIndex);
            if (text == null) {
                log.warn("Hostname {} - Value at column {} cannot be null, the table remains unchanged.", (Object)this.hostname, (Object)column);
                return;
            }
            String extractedValue = PslUtils.nthArgf(text, String.valueOf(subColumn), subSeparators, null);
            ArrayList<String> resultRow = new ArrayList<String>(row);
            resultRow.set(columnIndex, extractedValue);
            resultTable.add(resultRow);
        }
        this.sourceTable.setTable(resultTable);
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute ExtractPropertyFromWbemPath Exec")
    public void process(@SpanAttribute(value="compute.definition") ExtractPropertyFromWbemPath extractPropertyFromWbemPath) {
        if (extractPropertyFromWbemPath == null) {
            log.warn("Hostname {} - Compute Operation (ExtractPropertyFromWbemPath) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer columnIndex = extractPropertyFromWbemPath.getColumn();
        String property = extractPropertyFromWbemPath.getProperty();
        if (columnIndex < 1) {
            log.warn("Hostname {} - Arguments in Compute Operation (ExtractPropertyFromWbemPath) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)extractPropertyFromWbemPath);
            return;
        }
        Integer n = columnIndex;
        columnIndex = columnIndex - 1;
        block0: for (List list : this.sourceTable.getTable()) {
            if (columnIndex >= list.size()) continue;
            String columnValue = (String)list.get(columnIndex);
            for (String objectPath : columnValue.split(",")) {
                String[] splitedValue = objectPath.split("=", 2);
                String key = splitedValue[0];
                if (key.length() < property.length() || !".".concat(key).toLowerCase().endsWith(".".concat(property).toLowerCase())) continue;
                list.set(columnIndex, splitedValue[1].replace("\"", "").trim());
                continue block0;
            }
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute Json2Csv Exec")
    public void process(@SpanAttribute(value="compute.definition") Json2Csv json2csv) {
        if (json2csv == null) {
            log.warn("Hostname {} - Compute Operation (Json2CSV) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        try {
            ArrayList<String> jsonToCsvProperties = new ArrayList<String>(Arrays.asList(json2csv.getProperties().split(";")));
            String json2csvResult = this.clientsExecutor.executeJson2Csv(this.sourceTable.getRawData(), json2csv.getEntryKey(), jsonToCsvProperties, json2csv.getSeparator());
            if (json2csvResult != null && !json2csvResult.isEmpty()) {
                this.sourceTable.setRawData(json2csvResult);
                this.sourceTable.setTable(SourceTable.csvToTable(json2csvResult, json2csv.getSeparator()));
            }
        }
        catch (Exception e) {
            ComputeProcessor.logComputeError(this.connectorId, String.format("%s -> computes[%d]", this.sourceKey, this.index), "Json2CSV", e, this.hostname);
        }
    }

    private static void logComputeError(String connectorId, String computeKey, String context, Throwable throwable, String hostname) {
        if (log.isErrorEnabled()) {
            log.error("Hostname {} - Compute Operation [{}] has failed. Context [{}]. Connector [{}]. Errors:\n{}\n", new Object[]{hostname, computeKey, context, connectorId, StringHelper.getStackMessages(throwable)});
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Hostname %s - Compute Operation [%s] has failed. Context [%s]. Connector [%s]. Stack trace:", hostname, computeKey, context, connectorId), throwable);
        }
    }

    @Override
    @WithSpan(value="Compute KeepColumns Exec")
    public void process(@SpanAttribute(value="compute.definition") KeepColumns keepColumns) {
        if (keepColumns == null) {
            log.warn("Hostname {} - KeepColumns object is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        List columnNumbers = null;
        try {
            columnNumbers = Stream.of(keepColumns.getColumnNumbers().split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException numberFormatException) {
            ComputeProcessor.logComputeError(this.connectorId, String.format("%s -> computes[%d]", this.sourceKey, this.index), "KeepColumns", numberFormatException, this.hostname);
            return;
        }
        if (columnNumbers == null || columnNumbers.isEmpty()) {
            log.warn("Hostname {} - The column number list in KeepColumns cannot be null or empty. The table remains unchanged.", (Object)this.hostname);
            return;
        }
        ArrayList<List<String>> resultTable = new ArrayList<List<String>>();
        columnNumbers = columnNumbers.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
        for (List<String> row : this.sourceTable.getTable()) {
            ArrayList<String> resultRow = new ArrayList<String>();
            for (Integer columnIndex : columnNumbers) {
                if (columnIndex < 1 || columnIndex > row.size()) {
                    log.warn("Hostname {} - Invalid index for a {}-sized row: {}. The table remains unchanged.", new Object[]{this.hostname, row.size(), columnIndex});
                    return;
                }
                resultRow.add(row.get(columnIndex - 1));
            }
            resultTable.add(resultRow);
        }
        this.sourceTable.setTable(resultTable);
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute KeepOnlyMatchingLines Exec")
    public void process(@SpanAttribute(value="compute.definition") KeepOnlyMatchingLines keepOnlyMatchingLines) {
        this.processAbstractMatchingLines(keepOnlyMatchingLines);
    }

    @Override
    @WithSpan(value="Compute Prepend Exec")
    public void process(@SpanAttribute(value="compute.definition") Prepend prepend) {
        this.processAbstractConcat(prepend);
    }

    @Override
    @WithSpan(value="Compute Multiply Exec")
    public void process(@SpanAttribute(value="compute.definition") Multiply multiply) {
        if (multiply == null) {
            log.warn("Hostname {} - Compute Operation (Multiply) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer columnIndex = multiply.getColumn();
        String operand2 = multiply.getValue();
        if (columnIndex == null || operand2 == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (Multiply) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)multiply);
            return;
        }
        if (columnIndex < 1) {
            log.warn("Hostname {} - The index of the column to multiply cannot be < 1, the multiplication computation cannot be performed.", (Object)this.hostname);
            return;
        }
        this.performMathematicalOperation(multiply, columnIndex, operand2);
    }

    @Override
    @WithSpan(value="Compute PerBitTranslation Exec")
    public void process(@SpanAttribute(value="compute.definition") PerBitTranslation perBitTranslation) {
        List bitList;
        if (perBitTranslation == null) {
            log.warn("Hostname {} - The Source (Per Bit Translation) to visit is null, the Per Bit Translation computation cannot be performed.", (Object)this.hostname);
            return;
        }
        ITranslationTable translationTable = perBitTranslation.getTranslationTable();
        if (translationTable == null) {
            log.warn("Hostname {} - Translation Table is null, the array translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        Map<String, String> translations = this.findTranslations(translationTable);
        if (translations == null) {
            log.warn("Hostname {} - The Translation Map is null, the array translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int columnIndex = perBitTranslation.getColumn() - 1;
        if (columnIndex < 0) {
            log.warn("Hostname {} - The index of the column to translate cannot be < 1, the Per Bit Translation computation cannot be performed.", (Object)this.hostname);
            return;
        }
        try {
            bitList = Arrays.asList(perBitTranslation.getBitList().split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (Exception exception) {
            ComputeProcessor.logComputeError(this.connectorId, String.format("%s -> computes[%d]", this.sourceKey, this.index), "PerBitTranslation", exception, this.hostname);
            return;
        }
        for (List<String> line : this.sourceTable.getTable()) {
            long valueToBeReplacedLong;
            if (columnIndex >= line.size()) continue;
            try {
                valueToBeReplacedLong = (long)Double.parseDouble(line.get(columnIndex));
            }
            catch (NumberFormatException e) {
                log.warn("Hostname {} - Data is not correctly formatted.", (Object)this.hostname);
                return;
            }
            String columnResult = bitList.stream().map(bit -> String.format("%d,%d", bit, ((long)((int)Math.pow(2.0, bit.intValue())) & valueToBeReplacedLong) != 0L ? 1 : 0)).map(translations::get).filter(value -> value != null && !value.isBlank()).collect(Collectors.joining(" - "));
            line.set(columnIndex, columnResult);
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute Replace Exec")
    public void process(@SpanAttribute(value="compute.definition") Replace replace) {
        if (replace == null) {
            log.warn("Hostname {} - Compute Operation (Replace) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer columnToReplace = replace.getColumn();
        String strToReplace = replace.getExistingValue();
        String replacement = replace.getNewValue();
        if (columnToReplace == null || strToReplace == null || replacement == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (Replace): {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)replace);
            return;
        }
        if (columnToReplace < 1) {
            log.warn("Hostname {} - The index of the column to replace cannot be < 1, the replacement computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int columnIndex = columnToReplace - 1;
        if (MetricsHubConstants.COLUMN_PATTERN.matcher(replacement).matches()) {
            int replacementColumnIndex = ComputeProcessor.getColumnIndex(replacement);
            if (!this.sourceTable.getTable().isEmpty()) {
                if (MetricsHubConstants.COLUMN_PATTERN.matcher(strToReplace).matches()) {
                    int strToReplaceColumnIndex = ComputeProcessor.getColumnIndex(strToReplace);
                    this.sourceTable.getTable().forEach(line -> {
                        if (this.validateSizeAndIndices(line.size(), columnIndex, replacementColumnIndex, strToReplaceColumnIndex)) {
                            line.set(columnIndex, ((String)line.get(columnIndex)).replace((CharSequence)line.get(strToReplaceColumnIndex), (CharSequence)line.get(replacementColumnIndex)));
                        }
                    });
                } else {
                    this.sourceTable.getTable().forEach(line -> {
                        if (this.validateSizeAndIndices(line.size(), columnIndex, replacementColumnIndex)) {
                            line.set(columnIndex, ((String)line.get(columnIndex)).replace(strToReplace, (CharSequence)line.get(replacementColumnIndex)));
                        }
                    });
                }
            }
        } else if (MetricsHubConstants.COLUMN_PATTERN.matcher(strToReplace).matches()) {
            int strToReplaceColumnIndex = ComputeProcessor.getColumnIndex(strToReplace);
            if (!this.sourceTable.getTable().isEmpty()) {
                this.sourceTable.getTable().forEach(line -> {
                    if (this.validateSizeAndIndices(line.size(), columnIndex, strToReplaceColumnIndex)) {
                        line.set(columnIndex, ((String)line.get(columnIndex)).replace((CharSequence)line.get(strToReplaceColumnIndex), replacement));
                    }
                });
            }
        } else {
            this.sourceTable.getTable().forEach(line -> {
                if (this.validateSizeAndIndices(line.size(), columnIndex)) {
                    line.set(columnIndex, ((String)line.get(columnIndex)).replace(strToReplace, replacement));
                }
            });
        }
        this.sourceTable.setTable(SourceTable.csvToTable(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false), ";"));
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    boolean validateSizeAndIndices(int collectionSize, int ... indices) {
        for (int indexValue : indices) {
            if (indexValue >= 0 && indexValue < collectionSize) continue;
            return false;
        }
        return true;
    }

    @Override
    @WithSpan(value="Compute Append Exec")
    public void process(@SpanAttribute(value="compute.definition") Append append) {
        this.processAbstractConcat(append);
    }

    @Override
    @WithSpan(value="Compute Subtract Exec")
    public void process(@SpanAttribute(value="compute.definition") Subtract subtract) {
        if (subtract == null) {
            log.warn("Hostname {} - Compute Operation (Subtract) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        Integer columnIndex = subtract.getColumn();
        String operand2 = subtract.getValue();
        if (columnIndex == null || operand2 == null) {
            log.warn("Hostname {} - Arguments in Compute Operation (Subtract) : {} are wrong, the table remains unchanged.", (Object)this.hostname, (Object)subtract);
            return;
        }
        if (columnIndex < 1) {
            log.warn("Hostname {} - The index of the column to add cannot be < 1, the addition computation cannot be performed.", (Object)this.hostname);
            return;
        }
        this.performMathematicalOperation(subtract, columnIndex, operand2);
    }

    @Override
    @WithSpan(value="Compute Substring Exec")
    public void process(@SpanAttribute(value="compute.definition") Substring substring) {
        if (!ComputeProcessor.checkSubstring(substring)) {
            log.warn("Hostname {} - The substring {} is not valid, the table remains unchanged.", (Object)this.hostname, (Object)substring);
            return;
        }
        String start = substring.getStart();
        String length = substring.getLength();
        Integer startColumnIndex = ComputeProcessor.getColumnIndex(start);
        if (!ComputeProcessor.checkValueAndColumnIndexConsistency(start, startColumnIndex)) {
            log.warn("Hostname {} - Inconsistent substring start value {}, the table remains unchanged.", (Object)this.hostname, (Object)start);
            return;
        }
        Integer lengthColumnIndex = ComputeProcessor.getColumnIndex(length);
        if (!ComputeProcessor.checkValueAndColumnIndexConsistency(length, lengthColumnIndex)) {
            log.warn("Hostname {} - Inconsistent substring length value {}, the table remains unchanged.", (Object)this.hostname, (Object)length);
            return;
        }
        this.performSubstring(substring.getColumn() - 1, start, startColumnIndex, length, lengthColumnIndex);
    }

    static boolean checkValueAndColumnIndexConsistency(String value, Integer foreignColumnIndex) {
        return foreignColumnIndex >= 0 || NUMBER_PATTERN.matcher(value).matches();
    }

    static boolean checkSubstring(Substring substring) {
        return substring != null && substring.getColumn() >= 1;
    }

    void performSubstring(int columnIndex, String start, int startColumnIndex, String end, int endColumnIndex) {
        Function<ComputeValue, String> startFunction = ComputeProcessor.getValueFunction(startColumnIndex);
        Function<ComputeValue, String> endFunction = ComputeProcessor.getValueFunction(endColumnIndex);
        this.sourceTable.getTable().forEach(row -> {
            if (columnIndex < row.size()) {
                Integer endIndex;
                String columnValue = (String)row.get(columnIndex);
                Integer beginIndex = ComputeProcessor.transformToIntegerValue((String)startFunction.apply(new ComputeValue((List<String>)row, startColumnIndex, start)));
                if (ComputeProcessor.checkSubstringArguments(beginIndex, endIndex = ComputeProcessor.transformToIntegerValue((String)endFunction.apply(new ComputeValue((List<String>)row, endColumnIndex, end))), columnValue.length())) {
                    row.set(columnIndex, columnValue.substring(beginIndex - 1, endIndex));
                    return;
                }
                log.warn("Hostname {} - Substring arguments are not valid: start={}, end={}, startColumnIndex={}, endColumnIndex={}, computed beginIndex={}, computed endIndex={}, row={}, columnValue={}", new Object[]{this.hostname, start, end, startColumnIndex, endColumnIndex, beginIndex, endIndex, row, columnValue});
            }
            log.warn("Hostname {} - Cannot perform substring on row {} on column index {}", new Object[]{this.hostname, row, columnIndex});
        });
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    static boolean checkSubstringArguments(Integer begin, Integer end, int length) {
        return begin != null && end != null && begin - 1 >= 0 && begin - 1 <= end && end <= length;
    }

    static Function<ComputeValue, String> getValueFunction(int foreignColumnIndex) {
        return foreignColumnIndex >= 0 ? GET_VALUE_FROM_ROW : GET_VALUE;
    }

    static Integer transformToIntegerValue(String value) {
        if (value != null && MetricsHubConstants.DOUBLE_PATTERN.matcher(value).matches()) {
            return (int)Double.parseDouble(value);
        }
        return null;
    }

    @Override
    @WithSpan(value="Compute Translate Exec")
    public void process(@SpanAttribute(value="compute.definition") Translate translate) {
        if (translate == null) {
            log.warn("Hostname {} - The Source (Translate) to visit is null, the translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        ITranslationTable translationTable = translate.getTranslationTable();
        if (translationTable == null) {
            log.warn("Hostname {} - Translation Table is null, the translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        Map<String, String> translations = this.findTranslations(translationTable);
        if (translations == null) {
            log.warn("Hostname {} - The Translation Map is null, the translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        int columnIndex = translate.getColumn() - 1;
        if (columnIndex < 0) {
            log.warn("Hostname {} - The index of the column to translate cannot be < 1, the translate computation cannot be performed.", (Object)this.hostname);
            return;
        }
        boolean needSerialization = false;
        String defaultTranslation = translations.get("default");
        for (List<String> line : this.sourceTable.getTable()) {
            if (columnIndex >= line.size()) continue;
            String valueToBeReplaced = line.get(columnIndex).toLowerCase();
            String newValue = translations.getOrDefault(valueToBeReplaced, defaultTranslation);
            if (newValue != null) {
                line.set(columnIndex, newValue);
                needSerialization = needSerialization || newValue.contains(";");
                continue;
            }
            log.warn("Hostname {} - The Translation Map {} does not contain the following value {} or default.", new Object[]{this.hostname, translationTable, valueToBeReplaced});
        }
        if (needSerialization) {
            this.sourceTable.setTable(SourceTable.csvToTable(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false), ";"));
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    @Override
    @WithSpan(value="Compute Xml2Csv Exec")
    public void process(@SpanAttribute(value="compute.definition") Xml2Csv xml2csv) {
        if (xml2csv == null) {
            log.warn("Hostname {} - Compute Operation (Xml2Csv) is null, the table remains unchanged.", (Object)this.hostname);
            return;
        }
        try {
            List<List<String>> xmlResult = this.clientsExecutor.executeXmlParsing(this.sourceTable.getRawData(), xml2csv.getProperties(), xml2csv.getRecordTag());
            if (xmlResult != null && !xmlResult.isEmpty()) {
                this.sourceTable.setTable(xmlResult);
                this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
            }
        }
        catch (Exception e) {
            ComputeProcessor.logComputeError(this.connectorId, String.format("%s -> computes[%d]", this.sourceKey, this.index), "Xml2Csv", e, this.hostname);
        }
    }

    private void performMathematicalOperation(Compute computeOperation, Integer column, String operand2) {
        int operandByIndex;
        Integer columnIndex;
        block6: {
            if (!MATH_FUNCTIONS_MAP.containsKey(computeOperation.getClass())) {
                log.warn("Hostname {} - The compute operation must be one of : Add, Subtract, Multiply, Divide.", (Object)this.hostname);
                return;
            }
            columnIndex = column - 1;
            operandByIndex = -1;
            Matcher matcher = MetricsHubConstants.COLUMN_PATTERN.matcher(operand2);
            if (matcher.matches()) {
                try {
                    operandByIndex = Integer.parseInt(matcher.group(1)) - 1;
                    if (operandByIndex < 0) {
                        log.warn("Hostname {} - The operand2 column index cannot be < 1, the {} computation cannot be performed, the table remains unchanged.", (Object)this.hostname, computeOperation.getClass());
                        return;
                    }
                    break block6;
                }
                catch (NumberFormatException e) {
                    log.warn("Hostname {} - NumberFormatException: {} is not a correct operand2 for {}, the table remains unchanged.", new Object[]{this.hostname, operand2, computeOperation});
                    log.debug("Hostname {} - Stack trace:", (Object)this.hostname, (Object)e);
                    return;
                }
            }
            if (!MetricsHubConstants.DOUBLE_PATTERN.matcher(operand2).matches()) {
                log.warn("Hostname {} - operand2 is not a number: {}, the table remains unchanged.", (Object)this.hostname, (Object)operand2);
                return;
            }
        }
        this.performMathComputeOnTable(computeOperation, columnIndex, operand2, operandByIndex);
    }

    private void performMathComputeOnTable(Compute computeOperation, Integer columnIndex, String operand2, int operand2Index) {
        for (List<String> line : this.sourceTable.getTable()) {
            this.performMathComputeOnLine(computeOperation, columnIndex, operand2, operand2Index, line);
        }
        this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
    }

    private void performMathComputeOnLine(Compute computeOperation, Integer columnIndex, String operand2, int operand2Index, List<String> line) {
        String operand1;
        if (columnIndex < line.size() && !(operand1 = line.get(columnIndex)).isBlank()) {
            if (operand2Index != -1) {
                if (operand2Index < line.size()) {
                    this.performMathComputeOnLine(computeOperation.getClass(), columnIndex, line, operand1, line.get(operand2Index));
                }
            } else {
                this.performMathComputeOnLine(computeOperation.getClass(), columnIndex, line, operand1, operand2);
            }
        }
    }

    private void performMathComputeOnLine(Class<? extends Compute> computeOperation, Integer columnIndex, List<String> line, String operand1, String operand2) {
        if (operand1.isBlank() || operand2.isBlank()) {
            return;
        }
        try {
            String resultFunction;
            if (MATH_FUNCTIONS_MAP.containsKey(computeOperation) && (resultFunction = MATH_FUNCTIONS_MAP.get(computeOperation).apply(operand1, operand2)) != null) {
                line.set(columnIndex, resultFunction);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Hostname {} - There is a NumberFormatException on operand 1: {} or the operand 2: {}.", new Object[]{this.hostname, operand1, operand2});
            log.debug("Hostname {} - Stack trace:", (Object)this.hostname, (Object)e);
        }
    }

    static Integer getColumnIndex(String value) {
        Matcher matcher = MetricsHubConstants.COLUMN_PATTERN.matcher(value);
        return matcher.matches() ? Integer.parseInt(matcher.group(1)) - 1 : -1;
    }

    private void processAbstractConcat(AbstractConcat abstractConcat) {
        boolean firstChecks;
        boolean bl = firstChecks = abstractConcat != null && abstractConcat.getValue() != null && abstractConcat.getColumn() != null && abstractConcat.getColumn() > 0 && this.sourceTable != null && this.sourceTable.getTable() != null && !this.sourceTable.getTable().isEmpty();
        if (firstChecks) {
            if (abstractConcat.getColumn() <= this.sourceTable.getTable().get(0).size()) {
                int columnIndex = abstractConcat.getColumn() - 1;
                String concatString = abstractConcat.getValue();
                Matcher matcher = MetricsHubConstants.COLUMN_PATTERN.matcher(concatString);
                if (matcher.matches()) {
                    int concatColumnIndex = Integer.parseInt(matcher.group(1)) - 1;
                    this.sourceTable.getTable().forEach(line -> this.concatColumns((List<String>)line, columnIndex, concatColumnIndex, abstractConcat));
                } else {
                    this.sourceTable.getTable().forEach(line -> this.concatString((List<String>)line, columnIndex, abstractConcat));
                    if (concatString.contains(";")) {
                        this.sourceTable.setTable(SourceTable.csvToTable(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false), ";"));
                    }
                }
            } else if (abstractConcat.getColumn() == this.sourceTable.getTable().get(0).size() + 1) {
                this.sourceTable.getTable().forEach(line -> line.add(abstractConcat.getValue()));
            }
            this.sourceTable.setRawData(SourceTable.tableToCsv(this.sourceTable.getTable(), ";", false));
        }
    }

    private void concatColumns(List<String> line, int columnIndex, int concatColumnIndex, AbstractConcat abstractConcat) {
        if (!this.validateSizeAndIndices(line.size(), concatColumnIndex, columnIndex)) {
            return;
        }
        String result = abstractConcat instanceof Prepend ? line.get(concatColumnIndex).concat(line.get(columnIndex)) : line.get(columnIndex).concat(line.get(concatColumnIndex));
        line.set(columnIndex, result);
    }

    private void concatString(List<String> line, int columnIndex, AbstractConcat abstractConcat) {
        if (!this.validateSizeAndIndices(line.size(), columnIndex)) {
            return;
        }
        String concatValue = abstractConcat.getValue();
        Matcher matcher = MetricsHubConstants.COLUMN_REFERENCE_PATTERN.matcher(concatValue);
        while (matcher.find()) {
            int concatColumnIndex = Integer.parseInt(matcher.group(1)) - 1;
            concatValue = concatValue.replace(matcher.group(0), line.get(concatColumnIndex));
        }
        String result = abstractConcat instanceof Prepend ? concatValue.concat(line.get(columnIndex)) : line.get(columnIndex).concat(concatValue);
        line.set(columnIndex, result);
    }

    public Map<String, String> findTranslations(ITranslationTable translation) {
        if (translation instanceof ReferenceTranslationTable) {
            ReferenceTranslationTable referenceTranslationTable = (ReferenceTranslationTable)translation;
            Connector connector = this.telemetryManager.getConnectorStore().getStore().get(this.connectorId);
            if (connector != null && connector.getTranslations() != null) {
                TranslationTable translationTable = connector.getTranslations().get(referenceTranslationTable.getTableId());
                if (translationTable == null) {
                    return null;
                }
                return translationTable.getTranslations();
            }
        }
        return ((TranslationTable)translation).getTranslations();
    }

    @Generated
    public static ComputeProcessorBuilder builder() {
        return new ComputeProcessorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @Generated
    public String getSourceKey() {
        return this.sourceKey;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public SourceTable getSourceTable() {
        return this.sourceTable;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setClientsExecutor(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSourceTable(SourceTable sourceTable) {
        this.sourceTable = sourceTable;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputeProcessor)) {
            return false;
        }
        ComputeProcessor other = (ComputeProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        if (this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor)) {
            return false;
        }
        String this$sourceKey = this.getSourceKey();
        String other$sourceKey = other.getSourceKey();
        if (this$sourceKey == null ? other$sourceKey != null : !this$sourceKey.equals(other$sourceKey)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        SourceTable this$sourceTable = this.getSourceTable();
        SourceTable other$sourceTable = other.getSourceTable();
        return !(this$sourceTable == null ? other$sourceTable != null : !((Object)this$sourceTable).equals(other$sourceTable));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComputeProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        String $sourceKey = this.getSourceKey();
        result = result * 59 + ($sourceKey == null ? 43 : $sourceKey.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        SourceTable $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : ((Object)$sourceTable).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComputeProcessor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ", sourceKey=" + this.getSourceKey() + ", hostname=" + this.getHostname() + ", sourceTable=" + String.valueOf(this.getSourceTable()) + ", index=" + this.getIndex() + ")";
    }

    @Generated
    public ComputeProcessor(TelemetryManager telemetryManager, String connectorId, ClientsExecutor clientsExecutor, String sourceKey, String hostname, SourceTable sourceTable, Integer index) {
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.clientsExecutor = clientsExecutor;
        this.sourceKey = sourceKey;
        this.hostname = hostname;
        this.sourceTable = sourceTable;
        this.index = index;
    }

    @Generated
    public ComputeProcessor() {
    }

    static {
        NUMBER_PATTERN = Pattern.compile("\\d+");
        GET_VALUE_FROM_ROW = computeValue -> {
            if (computeValue.getColumnIndex() < computeValue.getRow().size()) {
                return computeValue.getRow().get(computeValue.getColumnIndex());
            }
            log.warn("Cannot get value at index {} from the row {}.", (Object)computeValue.getColumnIndex(), computeValue.getRow());
            return null;
        };
        GET_VALUE = ComputeValue::getValue;
        MATH_FUNCTIONS_MAP = Map.of(Add.class, (op1, op2) -> Double.toString(Double.parseDouble(op1) + Double.parseDouble(op2)), Subtract.class, (op1, op2) -> Double.toString(Double.parseDouble(op1) - Double.parseDouble(op2)), Multiply.class, (op1, op2) -> Double.toString(Double.parseDouble(op1) * Double.parseDouble(op2)), Divide.class, (op1, op2) -> {
            Double op2Value = Double.parseDouble(op2);
            if (op2Value != 0.0) {
                return Double.toString(Double.parseDouble(op1) / op2Value);
            }
            return null;
        });
    }

    @Generated
    public static class ComputeProcessorBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private String sourceKey;
        @Generated
        private String hostname;
        @Generated
        private SourceTable sourceTable;
        @Generated
        private Integer index;

        @Generated
        ComputeProcessorBuilder() {
        }

        @Generated
        public ComputeProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder clientsExecutor(ClientsExecutor clientsExecutor) {
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder sourceTable(SourceTable sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        @Generated
        public ComputeProcessorBuilder index(Integer index) {
            this.index = index;
            return this;
        }

        @Generated
        public ComputeProcessor build() {
            return new ComputeProcessor(this.telemetryManager, this.connectorId, this.clientsExecutor, this.sourceKey, this.hostname, this.sourceTable, this.index);
        }

        @Generated
        public String toString() {
            return "ComputeProcessor.ComputeProcessorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", sourceKey=" + this.sourceKey + ", hostname=" + this.hostname + ", sourceTable=" + String.valueOf(this.sourceTable) + ", index=" + this.index + ")";
        }
    }

    private static class ComputeValue {
        private final List<String> row;
        private final int columnIndex;
        private final String value;

        @Generated
        public ComputeValue(List<String> row, int columnIndex, String value) {
            this.row = row;
            this.columnIndex = columnIndex;
            this.value = value;
        }

        @Generated
        public List<String> getRow() {
            return this.row;
        }

        @Generated
        public int getColumnIndex() {
            return this.columnIndex;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

