/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.pre;

import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.source.OrderedSources;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSourcesStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreSourcesStrategy.class);
    private Connector connector;

    public PreSourcesStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull Connector connector, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (connector == null) {
            throw new IllegalArgumentException("connector is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.connector = connector;
    }

    @Override
    public void run() {
        String connectorId = this.connector.getCompiledFilename();
        String hostname = this.telemetryManager.getHostname();
        Map<String, Source> preSources = this.connector.getPre();
        if (preSources == null || preSources.isEmpty()) {
            log.debug("Hostname {} - Attempted to process pre-sources, but none are available for connector {}.", (Object)hostname, (Object)connectorId);
            return;
        }
        JobInfo jobInfo = JobInfo.builder().hostname(hostname).connectorId(connectorId).jobName("pre").monitorType("none").build();
        OrderedSources orderedSources = OrderedSources.builder().sources(preSources, new ArrayList<String>(), this.connector.getPreSourceDep(), jobInfo).build();
        this.processSourcesAndComputes(orderedSources.getSources(), jobInfo);
    }

    @Generated
    public static PreSourcesStrategyBuilder builder() {
        return new PreSourcesStrategyBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreSourcesStrategy)) {
            return false;
        }
        PreSourcesStrategy other = (PreSourcesStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Connector this$connector = this.connector;
        Connector other$connector = other.connector;
        return !(this$connector == null ? other$connector != null : !((Object)this$connector).equals(other$connector));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PreSourcesStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Connector $connector = this.connector;
        result = result * 59 + ($connector == null ? 43 : ((Object)$connector).hashCode());
        return result;
    }

    @Generated
    public static class PreSourcesStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private Connector connector;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        PreSourcesStrategyBuilder() {
        }

        @Generated
        public PreSourcesStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public PreSourcesStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public PreSourcesStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public PreSourcesStrategyBuilder connector(@NonNull Connector connector) {
            if (connector == null) {
                throw new IllegalArgumentException("connector is marked non-null but is null");
            }
            this.connector = connector;
            return this;
        }

        @Generated
        public PreSourcesStrategyBuilder extensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public PreSourcesStrategy build() {
            return new PreSourcesStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor, this.connector, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "PreSourcesStrategy.PreSourcesStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", connector=" + String.valueOf(this.connector) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

