/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.NetworkHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorIdentity;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.detection.AutomaticDetection;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorSelection;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorStagingManager;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.HostProperties;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.MonitorFactory;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectionStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DetectionStrategy.class);

    public DetectionStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        HostProperties hostProperties = this.telemetryManager.getHostProperties();
        if (hostConfiguration == null) {
            log.error("No host configuration provided. Skip detection.");
            return;
        }
        String hostname = hostConfiguration.getHostname();
        log.debug("Hostname {} - Start detection strategy.", (Object)hostname);
        Map<Class<? extends IConfiguration>, IConfiguration> configurations = hostConfiguration.getConfigurations();
        if (configurations == null || configurations.isEmpty()) {
            log.error("Hostname {} - No protocol configuration provided. Please check the protocol configuration for resource {}.", (Object)hostname, (Object)hostConfiguration.getHostId());
            return;
        }
        hostProperties.setLocalhost(NetworkHelper.isLocalhost(hostname));
        String configuredConnectorId = hostConfiguration.getConfiguredConnectorId();
        ConnectorStagingManager connectorStagingManager = new ConnectorStagingManager(hostname);
        ConnectorStagingManager.StagedConnectorIdentifiers stagedConnectorIdentifiers = connectorStagingManager.stage(this.telemetryManager.getConnectorStore(), hostConfiguration.getConnectors());
        ArrayList<ConnectorTestResult> connectorTestResults = new ArrayList<ConnectorTestResult>();
        if (stagedConnectorIdentifiers.isForcedStaging()) {
            connectorTestResults.addAll(new ConnectorSelection(this.telemetryManager, this.clientsExecutor, stagedConnectorIdentifiers.getForcedConnectorIds(), this.extensionManager).run());
        }
        if (stagedConnectorIdentifiers.isAutoDetectionStaged() && configuredConnectorId == null) {
            connectorTestResults.addAll(new AutomaticDetection(this.telemetryManager, this.clientsExecutor, stagedConnectorIdentifiers.getAutoDetectionConnectorIds(), this.extensionManager).run());
        }
        MonitorFactory monitorFactory = MonitorFactory.builder().telemetryManager(this.telemetryManager).discoveryTime(this.strategyTime).build();
        monitorFactory.createEndpointHostMonitor(hostProperties.isLocalhost());
        this.createConnectorMonitors(connectorTestResults);
        this.createConfiguredConnectorMonitor(configuredConnectorId);
    }

    void createConfiguredConnectorMonitor(String configuredConnectorId) {
        if (configuredConnectorId == null) {
            return;
        }
        String hostId = this.telemetryManager.getHostConfiguration().getHostId();
        HashMap<String, String> monitorAttributes = new HashMap<String, String>();
        monitorAttributes.put("id", configuredConnectorId);
        monitorAttributes.put("name", this.telemetryManager.getConnectorStore().getStore().get(configuredConnectorId).getConnectorIdentity().getDisplayName());
        monitorAttributes.put("parent.id", hostId);
        MonitorFactory monitorFactory = MonitorFactory.builder().telemetryManager(this.telemetryManager).monitorType(KnownMonitorType.CONNECTOR.getKey()).attributes(monitorAttributes).connectorId(configuredConnectorId).discoveryTime(this.strategyTime).build();
        Monitor monitor = monitorFactory.createOrUpdateMonitor(String.format("%s_%s", KnownMonitorType.CONNECTOR.getKey(), configuredConnectorId));
        this.collectConnectorStatus(true, configuredConnectorId, monitor);
    }

    void createConnectorMonitors(List<ConnectorTestResult> connectorTestResultList) {
        connectorTestResultList.forEach(connectorTestResult -> {
            this.createConnectorMonitor((ConnectorTestResult)connectorTestResult);
            this.verifySsh(connectorTestResult.getConnector());
        });
    }

    public void createConnectorMonitor(ConnectorTestResult connectorTestResult) {
        Connector connector = connectorTestResult.getConnector();
        HashMap<String, String> monitorAttributes = new HashMap<String, String>();
        String hostId = this.telemetryManager.getHostConfiguration().getHostId();
        String connectorId = connector.getCompiledFilename();
        String connectorName = connector.getConnectorIdentity().getDisplayName();
        monitorAttributes.put("id", connectorId);
        monitorAttributes.put("name", connectorName);
        monitorAttributes.put("filename", connectorId + ".yaml");
        monitorAttributes.put("applies_to_os", connector.getConnectorIdentity().getDetection().getAppliesTo().stream().map(deviceKind -> deviceKind.toString().toLowerCase()).sorted().collect(Collectors.joining(",")));
        monitorAttributes.put("parent.id", hostId);
        MonitorFactory monitorFactory = MonitorFactory.builder().telemetryManager(this.telemetryManager).monitorType(KnownMonitorType.CONNECTOR.getKey()).attributes(monitorAttributes).connectorId(connectorId).discoveryTime(this.strategyTime).build();
        Monitor monitor = monitorFactory.createOrUpdateMonitor(String.format("%s_%s", KnownMonitorType.CONNECTOR.getKey(), connectorId));
        this.collectConnectorStatus(connectorTestResult.isSuccess(), connectorId, monitor);
    }

    void verifySshSources(Set<Class<? extends Source>> sourceTypes) {
        if (sourceTypes.contains(CommandLineSource.class)) {
            this.telemetryManager.getHostProperties().setMustCheckSshStatus(true);
        }
    }

    void verifySshCriteria(List<Criterion> criteria) {
        boolean osCommandExecuteLocally = false;
        boolean osCommandExecuteRemotely = false;
        for (Criterion criterion : criteria) {
            if (criterion instanceof CommandLineCriterion) {
                CommandLineCriterion commandLineCriterion = (CommandLineCriterion)criterion;
                boolean executeLocally = commandLineCriterion.getExecuteLocally();
                osCommandExecuteLocally |= executeLocally;
                osCommandExecuteRemotely |= !executeLocally;
            }
            if (!osCommandExecuteLocally || !osCommandExecuteRemotely) continue;
            break;
        }
        this.telemetryManager.getHostProperties().setOsCommandExecutesLocally(osCommandExecuteLocally);
        this.telemetryManager.getHostProperties().setOsCommandExecutesRemotely(osCommandExecuteRemotely);
    }

    void verifySsh(Connector connector) {
        this.verifySshSources(connector.getSourceTypes());
        ConnectorIdentity connectorIdentity = connector.getConnectorIdentity();
        if (connectorIdentity != null && connectorIdentity.getDetection() != null && connectorIdentity.getDetection().getCriteria() != null) {
            this.verifySshCriteria(connectorIdentity.getDetection().getCriteria());
        }
    }

    @Generated
    public static DetectionStrategyBuilder builder() {
        return new DetectionStrategyBuilder();
    }

    @Generated
    public DetectionStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectionStrategy)) {
            return false;
        }
        DetectionStrategy other = (DetectionStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DetectionStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public static class DetectionStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        DetectionStrategyBuilder() {
        }

        @Generated
        public DetectionStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public DetectionStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public DetectionStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public DetectionStrategyBuilder extensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public DetectionStrategy build() {
            return new DetectionStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "DetectionStrategy.DetectionStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

