/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.extension;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IConnectorStoreProviderExtension;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.extension.ISourceComputationExtension;
import org.sentrysoftware.metricshub.engine.extension.IStrategyProviderExtension;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;

public class ExtensionManager {
    private List<IProtocolExtension> protocolExtensions;
    private List<IStrategyProviderExtension> strategyProviderExtensions;
    private List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions;
    private List<ISourceComputationExtension> sourceComputationExtensions;

    public static ExtensionManager empty() {
        return ExtensionManager.builder().build();
    }

    public Optional<IProtocolExtension> findCriterionExtension(Criterion criterion, TelemetryManager telemetryManager) {
        List<IProtocolExtension> criterionExtensions = this.protocolExtensions.stream().filter(extension -> telemetryManager.getHostConfiguration().getConfigurations().values().stream().anyMatch(extension::isValidConfiguration)).filter(extension -> extension.getSupportedCriteria().contains(criterion.getClass())).toList();
        return this.filterWithBusinessLogic(telemetryManager, criterionExtensions);
    }

    private Optional<IProtocolExtension> filterWithBusinessLogic(TelemetryManager telemetryManager, List<IProtocolExtension> candidateExtensions) {
        Optional<IProtocolExtension> maybeWmiExtension = this.findExtensionByType(candidateExtensions, "wmi");
        Optional<IProtocolExtension> maybeWinrmExtension = this.findExtensionByType(candidateExtensions, "winrm");
        Optional<IProtocolExtension> maybeOsCommandExtension = this.findExtensionByType(candidateExtensions, "oscommand");
        if ((maybeWmiExtension.isPresent() || maybeWinrmExtension.isPresent()) && maybeOsCommandExtension.isPresent()) {
            if (DeviceKind.WINDOWS == telemetryManager.getHostConfiguration().getHostType() && !telemetryManager.getHostProperties().isLocalhost()) {
                return Stream.of(maybeWmiExtension, maybeWinrmExtension).filter(Optional::isPresent).map(Optional::get).findFirst();
            }
            return maybeOsCommandExtension;
        }
        return candidateExtensions.stream().findFirst();
    }

    private Optional<IProtocolExtension> findExtensionByType(List<IProtocolExtension> extensions, String type) {
        return extensions.stream().filter(extension -> extension.isSupportedConfigurationType(type)).findFirst();
    }

    public Optional<IProtocolExtension> findExtensionByType(String type) {
        return this.findExtensionByType(this.protocolExtensions, type);
    }

    public Optional<IProtocolExtension> findSourceExtension(Source source, TelemetryManager telemetryManager) {
        List<IProtocolExtension> sourceExtensions = this.protocolExtensions.stream().filter(extension -> telemetryManager.getHostConfiguration().getConfigurations().values().stream().anyMatch(extension::isValidConfiguration)).filter(extension -> extension.getSupportedSources().contains(source.getClass())).toList();
        return this.filterWithBusinessLogic(telemetryManager, sourceExtensions);
    }

    public List<IProtocolExtension> findProtocolCheckExtensions(@NonNull TelemetryManager telemetryManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        return this.protocolExtensions.stream().filter(extension -> telemetryManager.getHostConfiguration().getConfigurations().values().stream().anyMatch(extension::isValidConfiguration)).collect(Collectors.toList());
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> findConfigurationToSourceMapping() {
        return this.protocolExtensions.stream().map(IProtocolExtension::getConfigurationToSourceMapping).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue));
    }

    public Optional<IConfiguration> buildConfigurationFromJsonNode(String configurationType, JsonNode configurationJsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        for (IProtocolExtension extension : this.protocolExtensions) {
            if (!extension.isSupportedConfigurationType(configurationType)) continue;
            return Optional.ofNullable(extension.buildConfiguration(configurationType, configurationJsonNode, decrypt));
        }
        return Optional.empty();
    }

    public ConnectorStore aggregateExtensionConnectorStores() {
        ConnectorStore connectorStore = new ConnectorStore();
        connectorStore.setStore(new TreeMap<String, Connector>(String.CASE_INSENSITIVE_ORDER));
        this.connectorStoreProviderExtensions.forEach(connectorStoreProviderExtension -> {
            connectorStoreProviderExtension.load();
            connectorStore.addMany(connectorStoreProviderExtension.getConnectorStore().getStore());
        });
        return connectorStore;
    }

    public Optional<ISourceComputationExtension> findSourceComputationExtension(Source source) {
        return this.sourceComputationExtensions.stream().filter(extension -> extension.isValidSource(source)).findFirst();
    }

    @Generated
    private static List<IProtocolExtension> $default$protocolExtensions() {
        return new ArrayList<IProtocolExtension>();
    }

    @Generated
    private static List<IStrategyProviderExtension> $default$strategyProviderExtensions() {
        return new ArrayList<IStrategyProviderExtension>();
    }

    @Generated
    private static List<IConnectorStoreProviderExtension> $default$connectorStoreProviderExtensions() {
        return new ArrayList<IConnectorStoreProviderExtension>();
    }

    @Generated
    private static List<ISourceComputationExtension> $default$sourceComputationExtensions() {
        return new ArrayList<ISourceComputationExtension>();
    }

    @Generated
    public static ExtensionManagerBuilder builder() {
        return new ExtensionManagerBuilder();
    }

    @Generated
    public List<IProtocolExtension> getProtocolExtensions() {
        return this.protocolExtensions;
    }

    @Generated
    public List<IStrategyProviderExtension> getStrategyProviderExtensions() {
        return this.strategyProviderExtensions;
    }

    @Generated
    public List<IConnectorStoreProviderExtension> getConnectorStoreProviderExtensions() {
        return this.connectorStoreProviderExtensions;
    }

    @Generated
    public List<ISourceComputationExtension> getSourceComputationExtensions() {
        return this.sourceComputationExtensions;
    }

    @Generated
    public void setProtocolExtensions(List<IProtocolExtension> protocolExtensions) {
        this.protocolExtensions = protocolExtensions;
    }

    @Generated
    public void setStrategyProviderExtensions(List<IStrategyProviderExtension> strategyProviderExtensions) {
        this.strategyProviderExtensions = strategyProviderExtensions;
    }

    @Generated
    public void setConnectorStoreProviderExtensions(List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions) {
        this.connectorStoreProviderExtensions = connectorStoreProviderExtensions;
    }

    @Generated
    public void setSourceComputationExtensions(List<ISourceComputationExtension> sourceComputationExtensions) {
        this.sourceComputationExtensions = sourceComputationExtensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionManager)) {
            return false;
        }
        ExtensionManager other = (ExtensionManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IProtocolExtension> this$protocolExtensions = this.getProtocolExtensions();
        List<IProtocolExtension> other$protocolExtensions = other.getProtocolExtensions();
        if (this$protocolExtensions == null ? other$protocolExtensions != null : !((Object)this$protocolExtensions).equals(other$protocolExtensions)) {
            return false;
        }
        List<IStrategyProviderExtension> this$strategyProviderExtensions = this.getStrategyProviderExtensions();
        List<IStrategyProviderExtension> other$strategyProviderExtensions = other.getStrategyProviderExtensions();
        if (this$strategyProviderExtensions == null ? other$strategyProviderExtensions != null : !((Object)this$strategyProviderExtensions).equals(other$strategyProviderExtensions)) {
            return false;
        }
        List<IConnectorStoreProviderExtension> this$connectorStoreProviderExtensions = this.getConnectorStoreProviderExtensions();
        List<IConnectorStoreProviderExtension> other$connectorStoreProviderExtensions = other.getConnectorStoreProviderExtensions();
        if (this$connectorStoreProviderExtensions == null ? other$connectorStoreProviderExtensions != null : !((Object)this$connectorStoreProviderExtensions).equals(other$connectorStoreProviderExtensions)) {
            return false;
        }
        List<ISourceComputationExtension> this$sourceComputationExtensions = this.getSourceComputationExtensions();
        List<ISourceComputationExtension> other$sourceComputationExtensions = other.getSourceComputationExtensions();
        return !(this$sourceComputationExtensions == null ? other$sourceComputationExtensions != null : !((Object)this$sourceComputationExtensions).equals(other$sourceComputationExtensions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtensionManager;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IProtocolExtension> $protocolExtensions = this.getProtocolExtensions();
        result = result * 59 + ($protocolExtensions == null ? 43 : ((Object)$protocolExtensions).hashCode());
        List<IStrategyProviderExtension> $strategyProviderExtensions = this.getStrategyProviderExtensions();
        result = result * 59 + ($strategyProviderExtensions == null ? 43 : ((Object)$strategyProviderExtensions).hashCode());
        List<IConnectorStoreProviderExtension> $connectorStoreProviderExtensions = this.getConnectorStoreProviderExtensions();
        result = result * 59 + ($connectorStoreProviderExtensions == null ? 43 : ((Object)$connectorStoreProviderExtensions).hashCode());
        List<ISourceComputationExtension> $sourceComputationExtensions = this.getSourceComputationExtensions();
        result = result * 59 + ($sourceComputationExtensions == null ? 43 : ((Object)$sourceComputationExtensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExtensionManager(protocolExtensions=" + String.valueOf(this.getProtocolExtensions()) + ", strategyProviderExtensions=" + String.valueOf(this.getStrategyProviderExtensions()) + ", connectorStoreProviderExtensions=" + String.valueOf(this.getConnectorStoreProviderExtensions()) + ", sourceComputationExtensions=" + String.valueOf(this.getSourceComputationExtensions()) + ")";
    }

    @Generated
    public ExtensionManager(List<IProtocolExtension> protocolExtensions, List<IStrategyProviderExtension> strategyProviderExtensions, List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions, List<ISourceComputationExtension> sourceComputationExtensions) {
        this.protocolExtensions = protocolExtensions;
        this.strategyProviderExtensions = strategyProviderExtensions;
        this.connectorStoreProviderExtensions = connectorStoreProviderExtensions;
        this.sourceComputationExtensions = sourceComputationExtensions;
    }

    @Generated
    public ExtensionManager() {
        this.protocolExtensions = ExtensionManager.$default$protocolExtensions();
        this.strategyProviderExtensions = ExtensionManager.$default$strategyProviderExtensions();
        this.connectorStoreProviderExtensions = ExtensionManager.$default$connectorStoreProviderExtensions();
        this.sourceComputationExtensions = ExtensionManager.$default$sourceComputationExtensions();
    }

    @Generated
    public static class ExtensionManagerBuilder {
        @Generated
        private boolean protocolExtensions$set;
        @Generated
        private List<IProtocolExtension> protocolExtensions$value;
        @Generated
        private boolean strategyProviderExtensions$set;
        @Generated
        private List<IStrategyProviderExtension> strategyProviderExtensions$value;
        @Generated
        private boolean connectorStoreProviderExtensions$set;
        @Generated
        private List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions$value;
        @Generated
        private boolean sourceComputationExtensions$set;
        @Generated
        private List<ISourceComputationExtension> sourceComputationExtensions$value;

        @Generated
        ExtensionManagerBuilder() {
        }

        @Generated
        public ExtensionManagerBuilder withProtocolExtensions(List<IProtocolExtension> protocolExtensions) {
            this.protocolExtensions$value = protocolExtensions;
            this.protocolExtensions$set = true;
            return this;
        }

        @Generated
        public ExtensionManagerBuilder withStrategyProviderExtensions(List<IStrategyProviderExtension> strategyProviderExtensions) {
            this.strategyProviderExtensions$value = strategyProviderExtensions;
            this.strategyProviderExtensions$set = true;
            return this;
        }

        @Generated
        public ExtensionManagerBuilder withConnectorStoreProviderExtensions(List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions) {
            this.connectorStoreProviderExtensions$value = connectorStoreProviderExtensions;
            this.connectorStoreProviderExtensions$set = true;
            return this;
        }

        @Generated
        public ExtensionManagerBuilder withSourceComputationExtensions(List<ISourceComputationExtension> sourceComputationExtensions) {
            this.sourceComputationExtensions$value = sourceComputationExtensions;
            this.sourceComputationExtensions$set = true;
            return this;
        }

        @Generated
        public ExtensionManager build() {
            List<IProtocolExtension> protocolExtensions$value = this.protocolExtensions$value;
            if (!this.protocolExtensions$set) {
                protocolExtensions$value = ExtensionManager.$default$protocolExtensions();
            }
            List<IStrategyProviderExtension> strategyProviderExtensions$value = this.strategyProviderExtensions$value;
            if (!this.strategyProviderExtensions$set) {
                strategyProviderExtensions$value = ExtensionManager.$default$strategyProviderExtensions();
            }
            List<IConnectorStoreProviderExtension> connectorStoreProviderExtensions$value = this.connectorStoreProviderExtensions$value;
            if (!this.connectorStoreProviderExtensions$set) {
                connectorStoreProviderExtensions$value = ExtensionManager.$default$connectorStoreProviderExtensions();
            }
            List<ISourceComputationExtension> sourceComputationExtensions$value = this.sourceComputationExtensions$value;
            if (!this.sourceComputationExtensions$set) {
                sourceComputationExtensions$value = ExtensionManager.$default$sourceComputationExtensions();
            }
            return new ExtensionManager(protocolExtensions$value, strategyProviderExtensions$value, connectorStoreProviderExtensions$value, sourceComputationExtensions$value);
        }

        @Generated
        public String toString() {
            return "ExtensionManager.ExtensionManagerBuilder(protocolExtensions$value=" + String.valueOf(this.protocolExtensions$value) + ", strategyProviderExtensions$value=" + String.valueOf(this.strategyProviderExtensions$value) + ", connectorStoreProviderExtensions$value=" + String.valueOf(this.connectorStoreProviderExtensions$value) + ", sourceComputationExtensions$value=" + String.valueOf(this.sourceComputationExtensions$value) + ")";
        }
    }
}

