/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.ConnectorDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.PostDeserializeHelper;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.EmbeddedFilesResolver;
import org.sentrysoftware.metricshub.engine.connector.parser.NodeProcessorHelper;
import org.sentrysoftware.metricshub.engine.connector.update.AvailableSourceUpdate;
import org.sentrysoftware.metricshub.engine.connector.update.CompiledFilenameUpdater;
import org.sentrysoftware.metricshub.engine.connector.update.ConnectorUpdateChain;
import org.sentrysoftware.metricshub.engine.connector.update.MonitorTaskSourceDepUpdate;
import org.sentrysoftware.metricshub.engine.connector.update.PreSourceDepUpdate;

public class ConnectorParser {
    private ConnectorDeserializer deserializer;
    private AbstractNodeProcessor processor;
    private ConnectorUpdateChain connectorUpdateChain;

    public Connector parse(File file) throws IOException {
        JsonNode node = this.deserializer.getMapper().readTree(file);
        Map<Integer, EmbeddedFile> embeddedFiles = null;
        if (this.processor != null) {
            HashMap<URI, JsonNode> parents = new HashMap<URI, JsonNode>();
            Path connectorDirectory = file.toPath().getParent();
            this.resolveParents(node, connectorDirectory.toUri(), parents);
            node = this.processor.process(node);
            EmbeddedFilesResolver embeddedFilesResolver = new EmbeddedFilesResolver(node, connectorDirectory, parents.keySet());
            embeddedFilesResolver.process();
            embeddedFiles = embeddedFilesResolver.collectEmbeddedFiles();
        }
        Connector connector = this.deserializer.deserialize((TreeNode)node);
        this.populateEmbeddedFiles(embeddedFiles, connector);
        if (this.connectorUpdateChain != null) {
            this.connectorUpdateChain.update(connector);
        }
        new CompiledFilenameUpdater(file.getName()).update(connector);
        return connector;
    }

    public Connector parse(InputStream inputStream, URI connectorFolderUri, String fileName) throws IOException {
        JsonNode node = this.deserializer.getMapper().readTree(inputStream);
        Map<Integer, EmbeddedFile> embeddedFiles = null;
        if (this.processor != null) {
            HashMap<URI, JsonNode> parents = new HashMap<URI, JsonNode>();
            this.resolveParents(node, connectorFolderUri, parents);
            node = this.processor.process(node);
            EmbeddedFilesResolver embeddedFilesResolver = new EmbeddedFilesResolver(node, Paths.get(connectorFolderUri), parents.keySet());
            embeddedFilesResolver.process();
            embeddedFiles = embeddedFilesResolver.collectEmbeddedFiles();
        }
        Connector connector = this.deserializer.deserialize((TreeNode)node);
        this.populateEmbeddedFiles(embeddedFiles, connector);
        if (this.connectorUpdateChain != null) {
            this.connectorUpdateChain.update(connector);
        }
        new CompiledFilenameUpdater(fileName).update(connector);
        return connector;
    }

    private void populateEmbeddedFiles(Map<Integer, EmbeddedFile> embeddedFiles, Connector connector) {
        if (embeddedFiles != null) {
            connector.setEmbeddedFiles(embeddedFiles);
        }
    }

    public static ConnectorParser withNodeProcessor(Path connectorDirectory) {
        ObjectMapper mapper = JsonHelper.buildYamlMapper();
        PostDeserializeHelper.addPostDeserializeSupport(mapper);
        return ConnectorParser.builder().deserializer(new ConnectorDeserializer(mapper)).processor(NodeProcessorHelper.withExtendsAndConstantsProcessor(connectorDirectory, mapper)).build();
    }

    public static ConnectorParser withNodeProcessor(Path connectorDirectory, Map<String, String> connectorVariables) {
        ObjectMapper mapper = JsonHelper.buildYamlMapper();
        PostDeserializeHelper.addPostDeserializeSupport(mapper);
        return ConnectorParser.builder().deserializer(new ConnectorDeserializer(mapper)).processor(NodeProcessorHelper.withExtendsAndTemplateVariableProcessor(connectorDirectory, mapper, connectorVariables)).build();
    }

    public static ConnectorParser withNodeProcessorAndUpdateChain(Path connectorDirectory) {
        ConnectorParser connectorParser = ConnectorParser.withNodeProcessor(connectorDirectory);
        ConnectorUpdateChain updateChain = ConnectorParser.createUpdateChain();
        connectorParser.setConnectorUpdateChain(updateChain);
        return connectorParser;
    }

    public static ConnectorParser withNodeProcessorAndUpdateChain(Path connectorDirectory, Map<String, String> connectorVariables) {
        ConnectorParser connectorParser = ConnectorParser.withNodeProcessor(connectorDirectory, connectorVariables);
        ConnectorUpdateChain updateChain = ConnectorParser.createUpdateChain();
        connectorParser.setConnectorUpdateChain(updateChain);
        return connectorParser;
    }

    public static ConnectorUpdateChain createUpdateChain() {
        AvailableSourceUpdate availableSource = new AvailableSourceUpdate();
        PreSourceDepUpdate preSourceDepUpdate = new PreSourceDepUpdate();
        MonitorTaskSourceDepUpdate monitorTaskSourceDepUpdate = new MonitorTaskSourceDepUpdate();
        availableSource.setNextUpdateChain(preSourceDepUpdate);
        preSourceDepUpdate.setNextUpdateChain(monitorTaskSourceDepUpdate);
        return availableSource;
    }

    private void resolveParents(JsonNode connector, URI connectorUri, Map<URI, JsonNode> parents) throws IOException {
        ArrayNode extended = (ArrayNode)connector.get("extends");
        if (extended == null || extended.isNull() || extended.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<URI, JsonNode>> nextEntries = new ArrayList<Map.Entry<URI, JsonNode>>();
        for (JsonNode jsonNode : extended) {
            Map.Entry<URI, JsonNode> parentEntry = this.getConnectorParentEntry(connectorUri, jsonNode.asText());
            nextEntries.add(parentEntry);
            parents.put(parentEntry.getKey(), parentEntry.getValue());
        }
        for (Map.Entry entry : nextEntries) {
            this.resolveParents((JsonNode)entry.getValue(), (URI)entry.getKey(), parents);
        }
    }

    private Map.Entry<URI, JsonNode> getConnectorParentEntry(URI connectorCurrentDir, String connectorRelativePath) throws IOException {
        Path connectorsDirectoryPath;
        Path connectorCurrentDirPath = Paths.get(connectorCurrentDir);
        Path connectorPath = connectorCurrentDirPath.resolve(connectorRelativePath + ".yaml").normalize();
        if (Files.exists(connectorPath, new LinkOption[0])) {
            return new AbstractMap.SimpleEntry<URI, JsonNode>(connectorPath.getParent().toUri(), this.deserializer.getMapper().readTree(Files.newInputStream(connectorPath, new OpenOption[0])));
        }
        if (!connectorRelativePath.startsWith(".") && (connectorsDirectoryPath = FileHelper.findConnectorsDirectory(connectorCurrentDir)) != null && Files.exists(connectorPath = connectorsDirectoryPath.resolve(connectorRelativePath + ".yaml").normalize(), new LinkOption[0])) {
            return new AbstractMap.SimpleEntry<URI, JsonNode>(connectorPath.getParent().toUri(), this.deserializer.getMapper().readTree(Files.newInputStream(connectorPath, new OpenOption[0])));
        }
        throw new IllegalStateException("Cannot get parent entry for connector path: " + connectorRelativePath);
    }

    @Generated
    public static ConnectorParserBuilder builder() {
        return new ConnectorParserBuilder();
    }

    @Generated
    public ConnectorParser(ConnectorDeserializer deserializer, AbstractNodeProcessor processor, ConnectorUpdateChain connectorUpdateChain) {
        this.deserializer = deserializer;
        this.processor = processor;
        this.connectorUpdateChain = connectorUpdateChain;
    }

    @Generated
    public ConnectorDeserializer getDeserializer() {
        return this.deserializer;
    }

    @Generated
    public ConnectorUpdateChain getConnectorUpdateChain() {
        return this.connectorUpdateChain;
    }

    @Generated
    public void setDeserializer(ConnectorDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Generated
    public void setProcessor(AbstractNodeProcessor processor) {
        this.processor = processor;
    }

    @Generated
    public void setConnectorUpdateChain(ConnectorUpdateChain connectorUpdateChain) {
        this.connectorUpdateChain = connectorUpdateChain;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorParser)) {
            return false;
        }
        ConnectorParser other = (ConnectorParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConnectorDeserializer this$deserializer = this.getDeserializer();
        ConnectorDeserializer other$deserializer = other.getDeserializer();
        if (this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer)) {
            return false;
        }
        AbstractNodeProcessor this$processor = this.getProcessor();
        AbstractNodeProcessor other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !((Object)this$processor).equals(other$processor)) {
            return false;
        }
        ConnectorUpdateChain this$connectorUpdateChain = this.getConnectorUpdateChain();
        ConnectorUpdateChain other$connectorUpdateChain = other.getConnectorUpdateChain();
        return !(this$connectorUpdateChain == null ? other$connectorUpdateChain != null : !this$connectorUpdateChain.equals(other$connectorUpdateChain));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectorDeserializer $deserializer = this.getDeserializer();
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        AbstractNodeProcessor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : ((Object)$processor).hashCode());
        ConnectorUpdateChain $connectorUpdateChain = this.getConnectorUpdateChain();
        result = result * 59 + ($connectorUpdateChain == null ? 43 : $connectorUpdateChain.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConnectorParser(deserializer=" + String.valueOf(this.getDeserializer()) + ", processor=" + String.valueOf(this.getProcessor()) + ", connectorUpdateChain=" + String.valueOf(this.getConnectorUpdateChain()) + ")";
    }

    @Generated
    public AbstractNodeProcessor getProcessor() {
        return this.processor;
    }

    @Generated
    public static class ConnectorParserBuilder {
        @Generated
        private ConnectorDeserializer deserializer;
        @Generated
        private AbstractNodeProcessor processor;
        @Generated
        private ConnectorUpdateChain connectorUpdateChain;

        @Generated
        ConnectorParserBuilder() {
        }

        @Generated
        public ConnectorParserBuilder deserializer(ConnectorDeserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @Generated
        public ConnectorParserBuilder processor(AbstractNodeProcessor processor) {
            this.processor = processor;
            return this;
        }

        @Generated
        public ConnectorParserBuilder connectorUpdateChain(ConnectorUpdateChain connectorUpdateChain) {
            this.connectorUpdateChain = connectorUpdateChain;
            return this;
        }

        @Generated
        public ConnectorParser build() {
            return new ConnectorParser(this.deserializer, this.processor, this.connectorUpdateChain);
        }

        @Generated
        public String toString() {
            return "ConnectorParser.ConnectorParserBuilder(deserializer=" + String.valueOf(this.deserializer) + ", processor=" + String.valueOf(this.processor) + ", connectorUpdateChain=" + String.valueOf(this.connectorUpdateChain) + ")";
        }
    }
}

