/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlColumn
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlColumn.class);
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String name;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String type;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private Integer number;

    public SqlColumn copy() {
        return SqlColumn.builder().name(this.name).type(this.type).number(this.number).build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SQL Column: name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", column number=");
        stringBuilder.append(this.number);
        return stringBuilder.toString();
    }

    public static SqlColumn detect(JsonNode value) {
        JsonNode numberNode;
        JsonNode typeNode;
        JsonNode nameNode = value.get("name");
        if (nameNode == null) {
            log.error("Malformed SQL Column, missing parameter 'name'.");
        }
        if ((typeNode = value.get("type")) == null) {
            log.error("Malformed SQL Column, missing parameter 'type'.");
        }
        if ((numberNode = value.get("number")) == null) {
            log.error("Malformed SQL Column, missing parameter 'number'.");
        }
        return SqlColumn.builder().name(nameNode.asText()).type(typeNode.asText()).number(numberNode.asInt()).build();
    }

    @Generated
    public static SqlColumnBuilder builder() {
        return new SqlColumnBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setNumber(Integer number) {
        this.number = number;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlColumn)) {
            return false;
        }
        SqlColumn other = (SqlColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlColumn;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public SqlColumn(String name, String type, Integer number) {
        this.name = name;
        this.type = type;
        this.number = number;
    }

    @Generated
    public SqlColumn() {
    }

    @Generated
    public static class SqlColumnBuilder {
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private Integer number;

        @Generated
        SqlColumnBuilder() {
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=NonBlankDeserializer.class)
        @Generated
        public SqlColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=NonBlankDeserializer.class)
        @Generated
        public SqlColumnBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=NonBlankDeserializer.class)
        @Generated
        public SqlColumnBuilder number(Integer number) {
            this.number = number;
            return this;
        }

        @Generated
        public SqlColumn build() {
            return new SqlColumn(this.name, this.type, this.number);
        }

        @Generated
        public String toString() {
            return "SqlColumn.SqlColumnBuilder(name=" + this.name + ", type=" + this.type + ", number=" + this.number + ")";
        }
    }
}

