/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;

public class TimeoutDeserializer
extends JsonDeserializer<Long> {
    public Long deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        Long value;
        if (parser == null) {
            return null;
        }
        String key = parser.getCurrentName();
        String str = parser.getValueAsString();
        if (str == null) {
            return null;
        }
        try {
            value = Long.parseLong(str);
        }
        catch (Exception e) {
            throw new InvalidFormatException(parser, String.format("Invalid value encountered for property '%s'. Error: %s", key, e.getMessage()), (Object)str, Integer.class);
        }
        if (value > 0L) {
            return value;
        }
        throw new InvalidFormatException(parser, String.format("Invalid negative or zero value encountered for property '%s'.", key), (Object)value, Long.class);
    }
}

