/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlColumn;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlTable;

public class SqlTableDeserializer
extends JsonDeserializer<List<SqlTable>> {
    public List<SqlTable> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return new ArrayList<SqlTable>();
        }
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ArrayList<SqlTable> sqlTables = new ArrayList<SqlTable>();
        if (node != null) {
            node.elements().forEachRemaining(tableNode -> this.createSqlTable((JsonNode)tableNode, (List<SqlTable>)sqlTables));
        }
        return sqlTables;
    }

    private void createSqlTable(JsonNode tableNode, List<SqlTable> sqlTables) {
        SqlTable sqlTable = new SqlTable();
        sqlTable.setSource(tableNode.get("source").asText());
        sqlTable.setAlias(tableNode.get("alias").asText());
        JsonNode columnsNode = tableNode.get("columns");
        ArrayList<SqlColumn> columns = new ArrayList<SqlColumn>();
        columnsNode.elements().forEachRemaining(columnNode -> columns.add(SqlColumn.detect(columnNode)));
        sqlTable.setColumns(columns);
        sqlTables.add(sqlTable);
    }
}

