/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.connector.model.metric.StateSet;

public class MetricsHubConstants {
    public static final String SEMICOLON = ";";
    public static final String COMMA = ",";
    public static final String TABLE_SEP = ";";
    public static final String EMPTY = "";
    public static final String WHITE_SPACE = " ";
    public static final String NEW_LINE = "\n";
    public static final String TAB = "\t";
    public static final String UNDERSCORE = "_";
    public static final String VERTICAL_BAR = "|";
    public static final String MONITOR_ATTRIBUTE_ID = "id";
    public static final String MONITOR_ATTRIBUTE_NAME = "name";
    public static final String MONITOR_ATTRIBUTE_CONNECTOR_ID = "connector_id";
    public static final String MONITOR_ATTRIBUTE_APPLIES_TO_OS = "applies_to_os";
    public static final String IS_ENDPOINT = "is_endpoint";
    public static final String MONITOR_ATTRIBUTE_PARENT_ID = "parent.id";
    public static final String OTHER_MONITOR_JOB_TYPES = "otherMonitorJobTypes";
    public static final Map<String, Integer> MONITOR_JOBS_PRIORITY = Map.of(KnownMonitorType.HOST.getKey(), 1, KnownMonitorType.ENCLOSURE.getKey(), 2, KnownMonitorType.BLADE.getKey(), 3, KnownMonitorType.DISK_CONTROLLER.getKey(), 4, KnownMonitorType.CPU.getKey(), 5, "otherMonitorJobTypes", 6);
    public static final String LOG_COMPUTE_KEY_SUFFIX_TEMPLATE = "%s -> computes[%d]";
    public static final String USERNAME_MACRO = "%{USERNAME}";
    public static final String PASSWORD_MACRO = "%{PASSWORD}";
    public static final String HOSTNAME_MACRO = "%{HOSTNAME}";
    public static final long DEFAULT_JOB_TIMEOUT = 300L;
    public static final int DEFAULT_LOCK_TIMEOUT = 120;
    public static final int MAX_THREADS_COUNT = 50;
    public static final long THREAD_TIMEOUT = 120L;
    public static final String STORAGE = "storage";
    public static final String HOST_TYPE_COMPUTE = "compute";
    public static final String NETWORK = "network";
    public static final Map<DeviceKind, String> HOST_TYPE_TO_OTEL_HOST_TYPE = Map.of(DeviceKind.VMS, "compute", DeviceKind.TRU64, "compute", DeviceKind.HPUX, "compute", DeviceKind.AIX, "compute", DeviceKind.LINUX, "compute", DeviceKind.OOB, "compute", DeviceKind.WINDOWS, "compute", DeviceKind.NETWORK, "network", DeviceKind.STORAGE, "storage", DeviceKind.SOLARIS, "compute");
    public static final String OTEL_HPUX_OS_TYPE = "hpux";
    public static final String OTEL_TRUE64_OS_TYPE = "true64";
    public static final String OTEL_OPENVMS_OS_TYPE = "openvms";
    public static final String OTEL_NETWORK_OS_TYPE = "network";
    public static final String OTEL_STORAGE_OS_TYPE = "storage";
    public static final String OTEL_SOLARIS_OS_TYPE = "solaris";
    public static final String OTEL_WINDOWS_OS_TYPE = "windows";
    public static final String OTEL_MANAGEMENT_OS_TYPE = "management";
    public static final String OTEL_LINUX_OS_TYPE = "linux";
    public static final String OTEL_AIX_OS_TYPE = "aix";
    public static final String OTEL_MAC_OS_X_OS_TYPE = "macosx";
    public static final String OTEL_OPEN_BSD_OS_TYPE = "openbsd";
    public static final String OTEL_NET_BSD_OS_TYPE = "netbsd";
    public static final String OTEL_FREE_BSD_OS_TYPE = "freebsd";
    public static final String OTEL_SUN_OS_TYPE = "sun";
    public static final Map<DeviceKind, String> HOST_TYPE_TO_OTEL_OS_TYPE = Map.of(DeviceKind.VMS, "openvms", DeviceKind.TRU64, "true64", DeviceKind.HPUX, "hpux", DeviceKind.AIX, "aix", DeviceKind.LINUX, "linux", DeviceKind.OOB, "management", DeviceKind.WINDOWS, "windows", DeviceKind.NETWORK, "network", DeviceKind.STORAGE, "storage", DeviceKind.SOLARIS, "solaris");
    public static final String CONNECTOR_STATUS_METRIC_KEY = "metricshub.connector.status";
    public static final String STATE_SET_METRIC_OK = "ok";
    public static final String STATE_SET_METRIC_FAILED = "failed";
    public static final MetricDefinition CONNECTOR_STATUS_METRIC_DEFINITION = MetricDefinition.builder().description("Connector operational status.").type(StateSet.builder().set(Set.of("ok", "failed")).build()).build();
    public static final String LOCALHOST = "localhost";
    public static final String HOST_NAME = "host.name";
    public static final String HOSTNAME_EXCEPTION_MESSAGE = "Hostname {} - Exception: ";
    public static final String ENGINE_PROPERTIES_FILE_NAME = "engine.properties";
    public static final String ENGINE_VERSION_PROPERTY = "engine.version";
    public static final String SUCCESSFUL_OS_DETECTION_MESSAGE = "Successful OS detection operation";
    public static final String WMI_PROCESS_QUERY = "SELECT ProcessId,Name,ParentProcessId,CommandLine FROM Win32_Process";
    public static final String WMI_DEFAULT_NAMESPACE = "root\\cimv2";
    public static final String AUTOMATIC_NAMESPACE = "automatic";
    public static final String CANT_FIND_EMBEDDED_FILE = "Can't find embedded file: ";
    public static final String ZIP = "zip";
    public static final String CONNECTORS = "connectors";
    public static final Pattern FILE_PATTERN = Pattern.compile("\\$\\{file::(.*?)\\}", 2);
    public static final Pattern SOURCE_REF_PATTERN = Pattern.compile("\\$\\{source::([^\\s\\}]+)\\}");
    public static final Pattern COLUMN_PATTERN = Pattern.compile("^\\s*\\$(\\d+)\\s*$");
    public static final Pattern COLUMN_REFERENCE_PATTERN = Pattern.compile("(?<!\\$)\\$([1-9]\\d*)");
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");
    public static final Pattern TRANSLATION_REF_PATTERN = Pattern.compile("\\$\\{translation::([^\\s]+)\\}");
    public static final Pattern HEXA_PATTERN = Pattern.compile("^[0-9A-Fa-f]+$");
    public static final String DEFAULT = "default";

    @Generated
    private MetricsHubConstants() {
    }
}

