/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class FunctionArgumentsExtractor {
    private static final Pattern TRAILING_AND_LEADING_DOUBLE_QUOTES_PATTERN = Pattern.compile("^\"(.*)\"$");

    public static List<String> extractArguments(String functionCode) {
        ArrayList<String> arguments = new ArrayList<String>();
        LinkedList<Character> parenthesesStack = new LinkedList<Character>();
        StringBuilder argumentBuilder = new StringBuilder();
        boolean insideDoubleQuotes = false;
        String input = functionCode.substring(functionCode.indexOf(40) + 1, functionCode.lastIndexOf(41)).trim();
        for (char c : input.toCharArray()) {
            if (c == '(' && !insideDoubleQuotes) {
                parenthesesStack.push(Character.valueOf(c));
            } else if (c == ')' && !insideDoubleQuotes) {
                parenthesesStack.pop();
            } else if (c == '\"') {
                boolean bl = insideDoubleQuotes = !insideDoubleQuotes;
            }
            if (c == ',' && parenthesesStack.isEmpty() && !insideDoubleQuotes) {
                arguments.add(FunctionArgumentsExtractor.normalizeArgument(argumentBuilder));
                argumentBuilder = new StringBuilder();
                continue;
            }
            argumentBuilder.append(c);
        }
        arguments.add(FunctionArgumentsExtractor.normalizeArgument(argumentBuilder));
        return arguments;
    }

    private static String normalizeArgument(StringBuilder argumentBuilder) {
        String value = argumentBuilder.toString().trim();
        Matcher matcher = TRAILING_AND_LEADING_DOUBLE_QUOTES_PATTERN.matcher(value);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return value;
    }

    @Generated
    private FunctionArgumentsExtractor() {
    }
}

