/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.client;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.sentrysoftware.jflat.JFlat;
import org.sentrysoftware.metricshub.engine.awk.AwkException;
import org.sentrysoftware.metricshub.engine.awk.AwkExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.ThreadHelper;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.tablejoin.TableJoin;
import org.sentrysoftware.xflat.XFlat;
import org.sentrysoftware.xflat.exceptions.XFlatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientsExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientsExecutor.class);
    private static final long JSON_2_CSV_TIMEOUT = 60L;
    private TelemetryManager telemetryManager;

    public List<List<String>> executeTableJoin(List<List<String>> leftTable, List<List<String>> rightTable, int leftKeyColumnNumber, int rightKeyColumnNumber, List<String> defaultRightLine, boolean wbemKeyType, boolean caseInsensitive) {
        LoggingHelper.trace(() -> log.trace("Executing Table Join request:\n- Left-table:\n{}\n- Right-table:\n{}\n", (Object)TextTableHelper.generateTextTable(leftTable), (Object)TextTableHelper.generateTextTable(rightTable)));
        List result = TableJoin.join(leftTable, rightTable, (int)leftKeyColumnNumber, (int)rightKeyColumnNumber, defaultRightLine, (boolean)wbemKeyType, (boolean)caseInsensitive);
        LoggingHelper.trace(() -> log.trace("Executed Table Join request:\n- Left-table:\n{}\n- Right-table:\n{}\n- Result:\n{}\n", new Object[]{TextTableHelper.generateTextTable(leftTable), TextTableHelper.generateTextTable(rightTable), TextTableHelper.generateTextTable(result)}));
        return result;
    }

    @WithSpan(value="AWK")
    public String executeAwkScript(@SpanAttribute(value="awk.script") String embeddedFileScript, @SpanAttribute(value="awk.input") String input) throws AwkException {
        if (embeddedFileScript == null || input == null) {
            return null;
        }
        return AwkExecutor.executeAwk(embeddedFileScript, input);
    }

    public String executeJson2Csv(String jsonSource, String jsonEntryKey, List<String> propertyList, String separator) throws InterruptedException, ExecutionException, TimeoutException {
        LoggingHelper.trace(() -> log.trace("Executing JSON to CSV conversion:\n- Json-source:\n{}\n- Json-entry-key: {}\n- Property-list: {}\n- Separator: {}\n", new Object[]{jsonSource, jsonEntryKey, propertyList, separator}));
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        Callable<String> jflatToCSV = () -> {
            try {
                JFlat jsonFlat = new JFlat(jsonSource);
                jsonFlat.parse();
                return jsonFlat.toCSV(jsonEntryKey, propertyList.toArray(new String[0]), separator).toString();
            }
            catch (IllegalArgumentException e) {
                log.error("Hostname {} - Error detected in the arguments when translating the JSON structure into CSV.", (Object)hostname);
            }
            catch (Exception e) {
                log.warn("Hostname {} - Error detected when running jsonFlat parsing:\n{}", (Object)hostname, (Object)jsonSource);
                log.debug("Hostname {} - Exception detected when running jsonFlat parsing: ", (Object)hostname, (Object)e);
            }
            return null;
        };
        String result = ThreadHelper.execute(jflatToCSV, 60L);
        LoggingHelper.trace(() -> log.trace("Executed JSON to CSV conversion:\n- Json-source:\n{}\n- Json-entry-key: {}\n- Property-list: {}\n- Separator: {}\n- Result:\n{}\n", new Object[]{jsonSource, jsonEntryKey, propertyList, separator, result}));
        return result;
    }

    public List<List<String>> executeXmlParsing(String xml, String properties, String recordTag) throws XFlatException {
        LoggingHelper.trace(() -> log.trace("Executing XML parsing:\n- Xml-source:\n{}\n- Properties: {}\n- Record-tag: {}\n", new Object[]{xml, properties, recordTag}));
        List result = XFlat.parseXml((String)xml, (String)properties, (String)recordTag);
        LoggingHelper.trace(() -> log.trace("Executed XML parsing:\n- Xml-source:\n{}\n- Properties: {}\n- Record-tag: {}\n- Result:\n{}\n", new Object[]{xml, properties, recordTag, TextTableHelper.generateTextTable(properties, (List<List<String>>)result)}));
        return result;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientsExecutor)) {
            return false;
        }
        ClientsExecutor other = (ClientsExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientsExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientsExecutor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ")";
    }

    @Generated
    public ClientsExecutor(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public ClientsExecutor() {
    }
}

