package org.sentrysoftware.metricshub.engine.strategy.utils;

/*-
 * ╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲
 * MetricsHub Engine
 * ჻჻჻჻჻჻
 * Copyright 2023 - 2024 Sentry Software
 * ჻჻჻჻჻჻
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱
 */

import java.util.Set;
import lombok.Builder;

/**
 * Represents the necessary information to manage the sudo commands.
 * This record contains settings that determine whether sudo is used, which commands require sudo,
 * and the specific sudo command to be used.
 *
 * @param isUseSudo       Indicates if sudo is to be used.
 * @param useSudoCommands A set of commands that specifically require sudo.
 * @param sudoCommand     The actual sudo command string to be used.
 */
@Builder
public record SudoInformation(boolean isUseSudo, Set<String> useSudoCommands, String sudoCommand) {
	/**
	 * Default SUDO command
	 */
	public static final String SUDO = "sudo";
}
