package org.sentrysoftware.metricshub.engine.common.exception;

/*-
 * ╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲
 * MetricsHub Engine
 * ჻჻჻჻჻჻
 * Copyright 2023 - 2024 Sentry Software
 * ჻჻჻჻჻჻
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱
 */

/**
 * This class is used to represent clients-related exceptions.
 * Clients include among others: IPMI, SNMP, SSH, WMI, WinRm, WBEM.
 */
public class ClientException extends Exception {

	/**
	 * Exception class for representing client-related exceptions.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new ClientException.
	 */
	public ClientException() {
		super();
	}

	/**
	 * Constructs a new ClientException with the specified cause.
	 *
	 * @param cause The cause of the exception.
	 */
	public ClientException(Exception cause) {
		super(cause);
	}

	/**
	 * Constructs a new ClientException with the specified detail message.
	 *
	 * @param message The detail message.
	 */
	public ClientException(String message) {
		super(message);
	}

	/**
	 * Constructs a new ClientException with the specified detail message and cause.
	 *
	 * @param message The detail message.
	 * @param cause   The cause of the exception.
	 */
	public ClientException(String message, Exception cause) {
		super(message, cause);
	}
}
