/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import org.springframework.aot.hint.AbstractTypeReference;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

final class ReflectionTypeReference
extends AbstractTypeReference {
    private final Class<?> type;

    private ReflectionTypeReference(Class<?> type) {
        super(type.getPackageName(), type.getSimpleName(), ReflectionTypeReference.getEnclosingClass(type));
        this.type = type;
    }

    @Nullable
    private static TypeReference getEnclosingClass(Class<?> type) {
        Class<?> candidate = type.isArray() ? type.getComponentType().getEnclosingClass() : type.getEnclosingClass();
        return candidate != null ? new ReflectionTypeReference(candidate) : null;
    }

    static ReflectionTypeReference of(Class<?> type) {
        return new ReflectionTypeReference(type);
    }

    @Override
    public String getCanonicalName() {
        return this.type.getCanonicalName();
    }

    @Override
    protected boolean isPrimitive() {
        return this.type.isPrimitive() || this.type.isArray() && this.type.getComponentType().isPrimitive();
    }
}

