/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.tablejoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableJoin {
    private TableJoin() {
    }

    public static String join(String leftTable, String rightTable, int leftKeyColumnNumber, int rightKeyColumnNumber, String separator, String defaultRightLine, boolean wbemKeyType, boolean caseInsensitive) throws IllegalArgumentException {
        if (separator == null || "".equals(separator)) {
            throw new IllegalArgumentException("Separator cannot be null or empty");
        }
        List<List<String>> leftTableList = TableJoin.stringToTable(leftTable, separator);
        List<List<String>> rightTableList = TableJoin.stringToTable(rightTable, separator);
        List<String> defaultRightLineList = TableJoin.lineToList(defaultRightLine, ";");
        List<List<String>> result = TableJoin.join(leftTableList, rightTableList, leftKeyColumnNumber, rightKeyColumnNumber, defaultRightLineList, wbemKeyType, caseInsensitive);
        return TableJoin.tableToString(result, separator);
    }

    protected static String tableToString(List<List<String>> table, String separator) {
        if (table != null) {
            return table.stream().filter(Objects::nonNull).map(line -> line.stream().collect(Collectors.joining(separator)) + separator).collect(Collectors.joining("\n"));
        }
        return null;
    }

    public static List<List<String>> stringToTable(String csvTable, String separator) {
        if (csvTable != null) {
            return Stream.of(csvTable.split("\n")).map(line -> TableJoin.lineToList(line, separator)).filter(line -> !line.isEmpty()).collect(Collectors.toList());
        }
        return null;
    }

    public static List<String> lineToList(String line, String separator) {
        if (line != null && !line.isEmpty()) {
            line = !line.endsWith(separator) ? line + separator : line;
            String[] split = line.split(separator, -1);
            return Stream.of(split).limit((long)split.length - 1L).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static List<List<String>> join(List<List<String>> leftTable, List<List<String>> rightTable, int leftKeyColumnNumber, int rightKeyColumnNumber, List<String> defaultRightLine, boolean wbemKeyType, boolean caseInsensitive) throws IllegalArgumentException {
        boolean handleDefaultRightLine;
        if (leftKeyColumnNumber < 1 || rightKeyColumnNumber < 1) {
            throw new IllegalArgumentException("Invalid key column number (leftKeyColumnNumber=" + leftKeyColumnNumber + ", rightKeyColumnNumber=" + rightKeyColumnNumber + ")");
        }
        if (leftTable == null) {
            return null;
        }
        boolean bl = handleDefaultRightLine = defaultRightLine != null && !defaultRightLine.isEmpty();
        if (rightTable == null && !handleDefaultRightLine) {
            return new ArrayList<List<String>>();
        }
        Map<Object, Object> rightTableLookup = null != rightTable ? rightTable.stream().filter(line -> rightKeyColumnNumber <= line.size()).collect(Collectors.toMap(line -> TableJoin.getKey(line, rightKeyColumnNumber, wbemKeyType, caseInsensitive), Function.identity(), (oldValue, newValue) -> oldValue)) : new HashMap();
        return leftTable.stream().filter(leftLine -> TableJoin.isValidLeftLine(leftKeyColumnNumber, leftLine)).map(leftLine -> TableJoin.joinLine(leftLine, leftKeyColumnNumber, defaultRightLine, wbemKeyType, caseInsensitive, handleDefaultRightLine, rightTableLookup)).filter(line -> !line.isEmpty()).collect(Collectors.toList());
    }

    public static String getKey(List<String> line, int keyColumnNumber, boolean wbemKeyType, boolean caseInsensitive) {
        String key = line.get(keyColumnNumber - 1);
        if (caseInsensitive) {
            key = key.toLowerCase();
        }
        if (wbemKeyType) {
            key = TableJoin.normalizeWbemReference(key);
        }
        return key;
    }

    public static boolean isValidLeftLine(int leftKeyColumnNumber, List<String> leftLine) {
        return leftKeyColumnNumber <= leftLine.size() && !leftLine.isEmpty() && !leftLine.get(leftKeyColumnNumber - 1).isEmpty();
    }

    public static List<String> joinLine(List<String> leftLine, int leftKeyColumnNumber, List<String> defaultRightLine, boolean wbemKeyType, boolean caseInsensitive, boolean handleDefaultRightLine, Map<String, List<String>> rightTableLookup) {
        String leftKey = TableJoin.getKey(leftLine, leftKeyColumnNumber, wbemKeyType, caseInsensitive);
        List<String> rightLine = rightTableLookup.get(leftKey);
        if (handleDefaultRightLine) {
            return Stream.concat(leftLine.stream(), rightLine != null ? rightLine.stream() : defaultRightLine.stream()).collect(Collectors.toList());
        }
        if (rightLine != null) {
            return Stream.concat(leftLine.stream(), rightLine.stream()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static String normalizeWbemReference(String wbemPath) {
        int dotIndex = wbemPath.indexOf(46);
        if (dotIndex < 1) {
            return wbemPath;
        }
        String className = wbemPath.substring(0, dotIndex);
        String keyProperties = wbemPath.substring(dotIndex + 1);
        Object[] keyPropertyArray = (keyProperties = keyProperties.replaceAll("\",", "\"\n")).split("\n");
        if (keyPropertyArray == null) {
            return wbemPath;
        }
        Arrays.sort(keyPropertyArray);
        StringBuilder result = new StringBuilder(className).append(".");
        for (Object keyPropertyItem : keyPropertyArray) {
            result.append((String)keyPropertyItem).append(".");
        }
        result.delete(result.length() - 1, result.length());
        return result.toString();
    }
}

