/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.printf4j;

import java.io.PrintStream;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Printf4J {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("(?<percent>%%)|(?<eol>%n)|(?<specifier>%(?<options>[ \\-+(#0]*)(?<width>\\*|[1-9]+|(?:[1-9][0-9]+))?(?:\\.(?<precision>[0-9]+))?(?<other>[bBhHsScCtT]|(?:L?(?<float>[eEfFgGaA]))|(?:(?:hh|h|l|ll|j|z|t)?(?<int>[diuoxX]))))");

    protected Printf4J() {
        throw new UnsupportedOperationException();
    }

    public static double toDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        String s = o.toString();
        while (s.length() > 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return 0.0;
    }

    public static long toLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public static String sprintf(Locale locale, String format, Object ... arr) {
        Matcher percentMatcher = PERCENT_PATTERN.matcher(format);
        StringBuilder formatResultBuilder = new StringBuilder();
        try (Formatter formatter = new Formatter(formatResultBuilder, locale);){
            int argumentIndex = 0;
            while (percentMatcher.find()) {
                if (percentMatcher.group("percent") != null) {
                    percentMatcher.appendReplacement(formatResultBuilder, "%");
                    continue;
                }
                if (percentMatcher.group("eol") != null) {
                    percentMatcher.appendReplacement(formatResultBuilder, "\n");
                    continue;
                }
                String formatSpecifier = percentMatcher.group("specifier");
                String options = percentMatcher.group("options");
                String width = percentMatcher.group("width");
                String precision = percentMatcher.group("precision");
                String conversion = percentMatcher.group("int");
                String prefix = "";
                if (conversion == null && (conversion = percentMatcher.group("float")) == null) {
                    conversion = percentMatcher.group("other");
                }
                if (argumentIndex >= arr.length) {
                    percentMatcher.appendReplacement(formatResultBuilder, formatSpecifier);
                    continue;
                }
                if (formatSpecifier == null) continue;
                if (options != null) {
                    if (options.indexOf(43) > -1 && "xXocsu".contains(conversion)) {
                        options = options.replace("+", "");
                    }
                    if (options.indexOf(32) > -1 && "xXocsu".contains(conversion)) {
                        options = options.replace(" ", "");
                    }
                    if (width == null) {
                        if (options.indexOf(48) > -1) {
                            options = options.replace("0", "");
                        }
                        if (options.indexOf(45) > -1) {
                            options = options.replace("-", "");
                        }
                    }
                    if (options.indexOf(48) > -1 && options.indexOf(45) > -1) {
                        options = options.replace("0", "");
                    }
                    if (options.indexOf(35) > -1) {
                        options = options.replace("#", "");
                        if ("x".equals(conversion)) {
                            prefix = "0x";
                        } else if ("X".equals(conversion)) {
                            prefix = "0X";
                        } else if ("o".equals(conversion)) {
                            prefix = "0";
                        }
                    }
                }
                if ("i".equals(conversion)) {
                    conversion = "d";
                } else if ("u".equals(conversion)) {
                    conversion = "d";
                    if (options != null) {
                        options = options.replace("+", "");
                    }
                } else if ("xXocs".contains(conversion)) {
                    options = options.replace("+", "");
                }
                if ("0".equals(width)) {
                    width = null;
                }
                if ("*".equals(width)) {
                    width = Integer.valueOf((Integer)arr[argumentIndex]).toString();
                    ++argumentIndex;
                }
                if (width != null && prefix != null) {
                    int newWidth = Integer.valueOf(width) - prefix.length();
                    if (newWidth < 0) {
                        newWidth = 0;
                    }
                    width = String.valueOf(newWidth);
                }
                if (argumentIndex >= arr.length) {
                    percentMatcher.appendReplacement(formatResultBuilder, formatSpecifier);
                    continue;
                }
                StringBuilder newFormatSpecifierBuilder = new StringBuilder(prefix);
                newFormatSpecifierBuilder.append('%');
                if (options != null) {
                    newFormatSpecifierBuilder.append(options);
                }
                if (width != null) {
                    newFormatSpecifierBuilder.append(width);
                }
                if (precision != null) {
                    newFormatSpecifierBuilder.append('.').append(precision);
                }
                newFormatSpecifierBuilder.append(conversion);
                formatSpecifier = newFormatSpecifierBuilder.toString();
                switch (conversion) {
                    case "s": {
                        percentMatcher.appendReplacement(formatResultBuilder, "");
                        formatter.format(formatSpecifier, arr[argumentIndex]);
                        break;
                    }
                    case "d": 
                    case "x": 
                    case "X": 
                    case "o": {
                        StringBuilder integerFormatStringBuilder;
                        if (precision == null) {
                            percentMatcher.appendReplacement(formatResultBuilder, "");
                            formatter.format(formatSpecifier, Printf4J.toLong(arr[argumentIndex]));
                            break;
                        }
                        if (width == null) {
                            if ("0".equals(precision)) {
                                percentMatcher.appendReplacement(formatResultBuilder, "");
                                break;
                            }
                            integerFormatStringBuilder = new StringBuilder(prefix);
                            integerFormatStringBuilder.append('%');
                            if (options != null) {
                                integerFormatStringBuilder.append(options);
                            }
                            if (options == null || !options.contains("0") && !precision.startsWith("0")) {
                                integerFormatStringBuilder.append("0");
                            }
                            if ("d".equals(conversion) && (Printf4J.toLong(arr[argumentIndex]) < 0L || options != null && options.contains("+"))) {
                                precision = Integer.toString(Integer.valueOf(precision) + 1);
                            }
                            integerFormatStringBuilder.append(precision);
                            integerFormatStringBuilder.append(conversion);
                            percentMatcher.appendReplacement(formatResultBuilder, "");
                            formatter.format(integerFormatStringBuilder.toString(), Printf4J.toLong(arr[argumentIndex]));
                            break;
                        }
                        integerFormatStringBuilder = new StringBuilder(prefix);
                        integerFormatStringBuilder.append('%');
                        if (options != null) {
                            integerFormatStringBuilder.append(options);
                        }
                        if (options == null || !options.contains("0") && !precision.startsWith("0")) {
                            integerFormatStringBuilder.append("0");
                        }
                        integerFormatStringBuilder.append(precision);
                        integerFormatStringBuilder.append(conversion);
                        percentMatcher.appendReplacement(formatResultBuilder, "");
                        String renderedPrecision = String.format(integerFormatStringBuilder.toString(), Printf4J.toLong(arr[argumentIndex]));
                        formatter.format("%" + width + "s", renderedPrecision);
                        break;
                    }
                    case "e": 
                    case "E": 
                    case "f": 
                    case "a": 
                    case "A": {
                        percentMatcher.appendReplacement(formatResultBuilder, "");
                        formatter.format(formatSpecifier, Printf4J.toDouble(arr[argumentIndex]));
                        break;
                    }
                    case "g": 
                    case "G": {
                        String tempFormatResult = String.format(locale, formatSpecifier, Printf4J.toDouble(arr[argumentIndex]));
                        if ((tempFormatResult.indexOf(46) > -1 || tempFormatResult.indexOf(44) > -1) && tempFormatResult.indexOf(101) == -1 && tempFormatResult.indexOf(69) == -1) {
                            while (tempFormatResult.endsWith("0")) {
                                tempFormatResult = tempFormatResult.substring(0, tempFormatResult.length() - 1);
                            }
                            if (tempFormatResult.endsWith(".") || tempFormatResult.endsWith(",")) {
                                tempFormatResult = tempFormatResult.substring(0, tempFormatResult.length() - 1);
                            }
                        }
                        percentMatcher.appendReplacement(formatResultBuilder, tempFormatResult);
                        break;
                    }
                    default: {
                        percentMatcher.appendReplacement(formatResultBuilder, "");
                        formatter.format(formatSpecifier, arr[argumentIndex]);
                    }
                }
                ++argumentIndex;
            }
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
        percentMatcher.appendTail(formatResultBuilder);
        return formatResultBuilder.toString();
    }

    public static String sprintf(String format, Object ... arr) {
        return Printf4J.sprintf(Locale.ENGLISH, format, arr);
    }

    public static void printf(Locale locale, String format, Object ... arr) {
        System.out.print(Printf4J.sprintf(locale, format, arr));
    }

    public static void printf(PrintStream ps, Locale locale, String format, Object ... arr) {
        ps.print(Printf4J.sprintf(locale, format, arr));
    }
}

