/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry.metric;

import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;

public class StateSetMetric
extends AbstractMetric {
    public static final String STATE_SET_METRIC_TYPE = "StateSetMetric";
    private String value;
    private String previousValue;
    private String[] stateSet;

    public StateSetMetric(String name, Long collectTime, Map<String, String> attributes, String value, String[] stateSet) {
        super(name, collectTime, attributes);
        this.value = value;
        this.stateSet = stateSet;
    }

    @Override
    public void save() {
        super.save();
        this.previousValue = this.value;
    }

    @Override
    public String getType() {
        return STATE_SET_METRIC_TYPE;
    }

    @Generated
    public static StateSetMetricBuilder builder() {
        return new StateSetMetricBuilder();
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getPreviousValue() {
        return this.previousValue;
    }

    @Generated
    public String[] getStateSet() {
        return this.stateSet;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setPreviousValue(String previousValue) {
        this.previousValue = previousValue;
    }

    @Generated
    public void setStateSet(String[] stateSet) {
        this.stateSet = stateSet;
    }

    @Generated
    public StateSetMetric() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateSetMetric)) {
            return false;
        }
        StateSetMetric other = (StateSetMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$previousValue = this.getPreviousValue();
        String other$previousValue = other.getPreviousValue();
        if (this$previousValue == null ? other$previousValue != null : !this$previousValue.equals(other$previousValue)) {
            return false;
        }
        return Arrays.deepEquals(this.getStateSet(), other.getStateSet());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StateSetMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $previousValue = this.getPreviousValue();
        result = result * 59 + ($previousValue == null ? 43 : $previousValue.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getStateSet());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "StateSetMetric(super=" + super.toString() + ", value=" + this.getValue() + ", previousValue=" + this.getPreviousValue() + ", stateSet=" + Arrays.deepToString(this.getStateSet()) + ")";
    }

    @Generated
    public static class StateSetMetricBuilder {
        @Generated
        private String name;
        @Generated
        private Long collectTime;
        @Generated
        private Map<String, String> attributes;
        @Generated
        private String value;
        @Generated
        private String[] stateSet;

        @Generated
        StateSetMetricBuilder() {
        }

        @Generated
        public StateSetMetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public StateSetMetricBuilder collectTime(Long collectTime) {
            this.collectTime = collectTime;
            return this;
        }

        @Generated
        public StateSetMetricBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public StateSetMetricBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public StateSetMetricBuilder stateSet(String[] stateSet) {
            this.stateSet = stateSet;
            return this;
        }

        @Generated
        public StateSetMetric build() {
            return new StateSetMetric(this.name, this.collectTime, this.attributes, this.value, this.stateSet);
        }

        @Generated
        public String toString() {
            return "StateSetMetric.StateSetMetricBuilder(name=" + this.name + ", collectTime=" + this.collectTime + ", attributes=" + String.valueOf(this.attributes) + ", value=" + this.value + ", stateSet=" + Arrays.deepToString(this.stateSet) + ")";
        }
    }
}

