/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.IStrategy;

public class ContextExecutor {
    private IStrategy strategy;

    public void execute() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<?> handler = executorService.submit(this.strategy);
            handler.get(this.strategy.getStrategyTimeout(), TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Generated
    public static ContextExecutorBuilder builder() {
        return new ContextExecutorBuilder();
    }

    @Generated
    public IStrategy getStrategy() {
        return this.strategy;
    }

    @Generated
    public void setStrategy(IStrategy strategy) {
        this.strategy = strategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextExecutor)) {
            return false;
        }
        ContextExecutor other = (ContextExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IStrategy this$strategy = this.getStrategy();
        IStrategy other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContextExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContextExecutor(strategy=" + String.valueOf(this.getStrategy()) + ")";
    }

    @Generated
    public ContextExecutor(IStrategy strategy) {
        this.strategy = strategy;
    }

    @Generated
    public ContextExecutor() {
    }

    @Generated
    public static class ContextExecutorBuilder {
        @Generated
        private IStrategy strategy;

        @Generated
        ContextExecutorBuilder() {
        }

        @Generated
        public ContextExecutorBuilder strategy(IStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Generated
        public ContextExecutor build() {
            return new ContextExecutor(this.strategy);
        }

        @Generated
        public String toString() {
            return "ContextExecutor.ContextExecutorBuilder(strategy=" + String.valueOf(this.strategy) + ")";
        }
    }
}

