/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;

public class TimeDeserializer
extends JsonDeserializer<Long> {
    @Override
    public Long deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return null;
        }
        try {
            return TimeDeserializer.interpretValueOf(parser.getValueAsString());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static long interpretValueOf(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        long longValue = NumberHelper.parseInt(value, -1).intValue();
        if (longValue != -1L) {
            return longValue;
        }
        Matcher matcher = Pattern.compile("\\s*(?:(\\d+)\\s*(?:years?|yrs?|y))?\\s*(?:(\\d+)\\s*(?:weeks?|wks?|w))?\\s*(?:(\\d+)\\s*(?:days?|d))?\\s*(?:(\\d+)\\s*(?:hours?|hrs?|h))?\\s*(?:(\\d+)\\s*(?:minutes?|mins?|m))?\\s*(?:(\\d+)\\s*(?:seconds?|secs?|s))?\\s*(?:(\\d+)\\s*(?:milliseconds?|millisecs?|ms))?\\s*", 2).matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not valid duration: " + value);
        }
        long years = matcher.start(1) == -1 ? 0 : Integer.parseInt(matcher.group(1));
        long weeks = matcher.start(2) == -1 ? 0 : Integer.parseInt(matcher.group(2));
        long days = matcher.start(3) == -1 ? 0 : Integer.parseInt(matcher.group(3));
        long hours = matcher.start(4) == -1 ? 0 : Integer.parseInt(matcher.group(4));
        long minutes = matcher.start(5) == -1 ? 0 : Integer.parseInt(matcher.group(5));
        long seconds = matcher.start(6) == -1 ? 0 : Integer.parseInt(matcher.group(6));
        long milliseconds = matcher.start(7) == -1 ? 0 : Integer.parseInt(matcher.group(7));
        return years * 60L * 60L * 24L * 365L + weeks * 60L * 60L * 24L * 7L + days * 60L * 60L * 24L + hours * 60L * 60L + minutes * 60L + seconds + milliseconds / 1000L;
    }
}

