/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.update;

import java.util.Map;
import java.util.regex.Pattern;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.SimpleMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.StandardMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.AbstractCollect;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Discovery;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Simple;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.update.SourceConnectorUpdateChain;

public class MonitorTaskSourceDepUpdate
extends SourceConnectorUpdateChain {
    @Override
    void doUpdate(Connector connector) {
        for (Map.Entry<String, MonitorJob> entry : connector.getMonitors().entrySet()) {
            SimpleMonitorJob simpleMonitorJob;
            Simple simple;
            String jobName = entry.getKey();
            MonitorJob job = entry.getValue();
            if (job instanceof StandardMonitorJob) {
                AbstractCollect collect;
                StandardMonitorJob standardMonitorJob = (StandardMonitorJob)job;
                Discovery discovery = standardMonitorJob.getDiscovery();
                if (discovery != null) {
                    Map<String, Source> sources = discovery.getSources();
                    discovery.setSourceDep(this.updateSourceDependency(sources, Pattern.compile(String.format("\\s*(\\$\\{source::((?i)monitors)\\.%s\\.((?i)discovery\\.sources)\\.(%s)\\})\\s*", Pattern.quote(jobName), this.getSourceIdentifiersRegex(sources)), 8), 4));
                }
                if ((collect = standardMonitorJob.getCollect()) != null) {
                    Map<String, Source> collectSources = collect.getSources();
                    collect.setSourceDep(this.updateSourceDependency(collectSources, Pattern.compile(String.format("\\s*(\\$\\{source::((?i)monitors)\\.%s\\.((?i)collect\\.sources)\\.(%s)\\})\\s*", Pattern.quote(jobName), this.getSourceIdentifiersRegex(collectSources)), 8), 4));
                }
            }
            if (!(job instanceof SimpleMonitorJob) || (simple = (simpleMonitorJob = (SimpleMonitorJob)job).getSimple()) == null) continue;
            Map<String, Source> simpleSources = simple.getSources();
            simple.setSourceDep(this.updateSourceDependency(simpleSources, Pattern.compile(String.format("\\s*(\\$\\{source::((?i)monitors)\\.%s\\.((?i)simple\\.sources)\\.(%s)\\})\\s*", Pattern.quote(jobName), this.getSourceIdentifiersRegex(simpleSources)), 8), 4));
        }
    }
}

