/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;

public class SourceKeyProcessor
extends AbstractNodeProcessor {
    private static final String SOURCE_KEY_PROPERTY = "key";
    private static final Set<String> MONITOR_JOB_TYPES;

    public SourceKeyProcessor(AbstractNodeProcessor next) {
        super(next);
    }

    public SourceKeyProcessor() {
        this(null);
    }

    @Override
    protected JsonNode processNode(JsonNode node) throws IOException {
        JsonNode monitorsNode;
        JsonNode preNode = node.get("pre");
        if (preNode != null && !preNode.isNull()) {
            preNode.fields().forEachRemaining(sourceNodeEntry -> {
                String sourceName = (String)sourceNodeEntry.getKey();
                JsonNode sourceNode = (JsonNode)sourceNodeEntry.getValue();
                ObjectNode sourceObjectNode = (ObjectNode)sourceNode;
                sourceObjectNode.set(SOURCE_KEY_PROPERTY, new TextNode(String.format("${source::pre.%s}", sourceName)));
            });
        }
        if ((monitorsNode = node.get("monitors")) != null && !monitorsNode.isNull()) {
            monitorsNode.fields().forEachRemaining(monitorEntry -> {
                String monitorName = (String)monitorEntry.getKey();
                JsonNode monitorJobsNode = (JsonNode)monitorEntry.getValue();
                monitorJobsNode.fields().forEachRemaining(monitorJobEntry -> {
                    JsonNode monitorJobNode;
                    JsonNode sourcesNode;
                    String monitorJobType = (String)monitorJobEntry.getKey();
                    if (MONITOR_JOB_TYPES.contains(monitorJobType) && (sourcesNode = (monitorJobNode = (JsonNode)monitorJobEntry.getValue()).get("sources")) != null && !sourcesNode.isNull()) {
                        sourcesNode.fields().forEachRemaining(sourceEntry -> {
                            String sourceName = (String)sourceEntry.getKey();
                            JsonNode sourceNode = (JsonNode)sourceEntry.getValue();
                            ObjectNode sourceObjectNode = (ObjectNode)sourceNode;
                            sourceObjectNode.set(SOURCE_KEY_PROPERTY, new TextNode(String.format("${source::monitors.%s.%s.sources.%s}", monitorName, monitorJobType, sourceName)));
                        });
                    }
                });
            });
        }
        return node;
    }

    static {
        LinkedHashSet<String> monitorJobTypes = new LinkedHashSet<String>();
        monitorJobTypes.addAll(Set.of("discovery", "collect", "simple"));
        MONITOR_JOB_TYPES = monitorJobTypes;
    }
}

