/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedFilesResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedFilesResolver.class);
    private final JsonNode connector;
    private final Path connectorDirectory;
    private final Set<URI> parents;
    private final Map<String, EmbeddedFile> processedEmbeddedFiles;

    public EmbeddedFilesResolver(JsonNode connector, Path connectorDirectory, Set<URI> parents) {
        this.connector = connector;
        this.connectorDirectory = connectorDirectory;
        this.parents = parents;
        this.processedEmbeddedFiles = new HashMap<String, EmbeddedFile>();
    }

    public void process() throws IOException {
        JsonParser jsonParser = this.connector.traverse();
        JsonToken token = jsonParser.nextToken();
        while (token != null) {
            String currentValue = jsonParser.getValueAsString();
            if (currentValue == null) {
                token = jsonParser.nextToken();
                continue;
            }
            Matcher fileMatcher = MetricsHubConstants.FILE_PATTERN.matcher(currentValue);
            while (fileMatcher.find()) {
                String fileName = fileMatcher.group(1);
                this.processedEmbeddedFiles.computeIfAbsent(fileName, name -> {
                    try {
                        return this.processFile((String)name, this.connectorDirectory);
                    }
                    catch (Exception e) {
                        String errorMessage = String.format("Error while processing file: %s. Current Connector directory: %s .", name, this.connectorDirectory);
                        log.error(errorMessage, (Throwable)e);
                        throw new EmbeddedFileProcessingException(errorMessage, e);
                    }
                });
            }
            token = jsonParser.nextToken();
        }
        if (this.processedEmbeddedFiles.isEmpty()) {
            return;
        }
        JsonNodeUpdater.jsonNodeUpdaterBuilder().withJsonNode(this.connector).withPredicate(value -> value.indexOf("${file::") != -1).withUpdater(this::performFileRefReplacements).build().update();
    }

    public EmbeddedFile processFile(String fileName, Path connectorDirectory) throws IOException {
        Path connectorPathFile;
        Path connectorsDirectoryPath;
        Path filePath = connectorDirectory.resolve(fileName).normalize();
        if (Files.exists(filePath, new LinkOption[0])) {
            return this.createEmbeddedFile(filePath);
        }
        Iterator<URI> iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            Path path = Paths.get(iterator.next()).resolve(fileName).normalize();
            if (!Files.exists(path, new LinkOption[0])) continue;
            return this.createEmbeddedFile(path);
        }
        if (!fileName.startsWith(".") && (connectorsDirectoryPath = FileHelper.findConnectorsDirectory(connectorDirectory.toUri())) != null && Files.exists(connectorPathFile = connectorsDirectoryPath.resolve(fileName).normalize(), new LinkOption[0])) {
            return this.createEmbeddedFile(connectorPathFile);
        }
        throw new IllegalStateException("Can't find embedded file: " + fileName);
    }

    private EmbeddedFile createEmbeddedFile(Path filePath) throws IOException {
        return EmbeddedFile.builder().id(this.processedEmbeddedFiles.size() + 1).filename(filePath.getFileName().toString()).content(Files.readAllBytes(filePath)).build();
    }

    private String performFileRefReplacements(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Matcher matcher = MetricsHubConstants.FILE_PATTERN.matcher(value);
        while (matcher.find()) {
            value = this.replaceFileReference(matcher, value);
        }
        return value;
    }

    private String replaceFileReference(Matcher matcher, String value) {
        String groupOne = matcher.group(1);
        Integer replacement = this.processedEmbeddedFiles.get(groupOne).getId();
        return value.replace(groupOne, replacement.toString());
    }

    public Map<Integer, EmbeddedFile> collectEmbeddedFiles() {
        return this.processedEmbeddedFiles.values().stream().collect(Collectors.toMap(EmbeddedFile::getId, Function.identity(), (k1, k2) -> k1));
    }

    public class EmbeddedFileProcessingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private EmbeddedFileProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

