/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class WbemSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private String query;
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String namespace;

    @JsonCreator
    public WbemSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="query", required=true) @NonNull String query, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
        this.namespace = namespace;
    }

    @Override
    public WbemSource copy() {
        return WbemSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).query(this.query).namespace(this.namespace).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.query = (String)updater.apply(this.query);
        this.namespace = (String)updater.apply(this.namespace);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- query=", this.query);
        StringHelper.addNonNull(stringJoiner, "- namespace=", this.namespace);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static WbemSourceBuilder builder() {
        return new WbemSourceBuilder();
    }

    @NonNull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @JsonDeserialize(using=NonBlankDeserializer.class)
    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setQuery(@NonNull String query) {
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
    }

    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public WbemSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WbemSource)) {
            return false;
        }
        WbemSource other = (WbemSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WbemSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }

    @Generated
    public static class WbemSourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String query;
        @Generated
        private String namespace;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        WbemSourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public WbemSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public WbemSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public WbemSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="query", required=true)
        @Generated
        public WbemSourceBuilder query(@NonNull String query) {
            if (query == null) {
                throw new IllegalArgumentException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        @JsonProperty(value="namespace")
        @Generated
        public WbemSourceBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public WbemSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public WbemSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public WbemSource build() {
            return new WbemSource(this.type, this.computes, this.forceSerialization, this.query, this.namespace, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "WbemSource.WbemSourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", query=" + this.query + ", namespace=" + this.namespace + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

