/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class NumberHelper {
    public static final Pattern INTEGER_DETECT_PATTERN = Pattern.compile("^(-?\\d+)(\\.0*)$");
    private static final DecimalFormat DECIMAL_FORMAT;

    private NumberHelper() {
    }

    public static Double parseDouble(String value, Double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer parseInt(String value, Integer defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double round(double value, int places, RoundingMode roundingMode) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        return BigDecimal.valueOf(value).setScale(places, roundingMode).doubleValue();
    }

    public static String cleanUpEnumInput(String state) {
        if (state == null) {
            return null;
        }
        Matcher matcher = INTEGER_DETECT_PATTERN.matcher(state = state.trim().toLowerCase());
        if (matcher.find()) {
            return state.substring(0, state.indexOf(matcher.group(2)));
        }
        return state;
    }

    public static String formatNumber(Number n, @NonNull String format) {
        if (format == null) {
            throw new IllegalArgumentException("format is marked non-null but is null");
        }
        String stringValue = DECIMAL_FORMAT.format(n);
        String[] valueParts = stringValue.split("\\.");
        String leftPart = valueParts[0];
        String rightPart = valueParts.length == 2 ? "." + valueParts[1] : "";
        return String.format(format, leftPart, rightPart);
    }

    public static String formatNumber(Number n) {
        return DECIMAL_FORMAT.format(n);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        DECIMAL_FORMAT = new DecimalFormat("#########.###", symbols);
    }
}

