/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jflat;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class JFlat {
    private TreeMap<String, String> map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList<String> arrayPaths = new ArrayList();
    private ArrayList<Integer> arrayLengths = new ArrayList();
    private Reader inputReader;
    private boolean parsed = false;

    public JFlat(Reader pJsonReader) {
        this.inputReader = pJsonReader;
    }

    public JFlat(String pJsonSource) {
        this(pJsonSource == null ? new StringReader("") : new StringReader(pJsonSource));
    }

    public void parse() throws ParseException, IOException, IllegalStateException {
        this.parse(false);
    }

    public void parse(boolean removeNodes) throws ParseException, IOException, IllegalStateException {
        JsonStructure root;
        try (JsonReader reader = Json.createReader(this.inputReader);){
            root = reader.read();
        }
        this.navigateTree(root, "", removeNodes);
        if (this.map.containsKey("")) {
            this.map.put("/", this.map.get(""));
            this.map.remove("");
        }
        this.parsed = true;
    }

    private void navigateTree(JsonValue tree, String path, boolean removeNodes) {
        if (tree == null) {
            return;
        }
        if (path == null) {
            path = "";
        }
        switch (tree.getValueType()) {
            case OBJECT: {
                JsonObject object = (JsonObject)tree;
                if (!removeNodes) {
                    this.map.put(path, "{object}");
                }
                for (String name : object.keySet()) {
                    this.navigateTree((JsonValue)object.get(name), path + "/" + name, removeNodes);
                }
                break;
            }
            case ARRAY: {
                JsonArray array = (JsonArray)tree;
                if (!removeNodes) {
                    this.map.put(path, "{array}");
                }
                int i = 0;
                for (JsonValue val2 : array) {
                    this.navigateTree(val2, path + "[" + i + "]", removeNodes);
                    ++i;
                }
                this.arrayPaths.add(path);
                this.arrayLengths.add(i);
                break;
            }
            case STRING: {
                JsonString st = (JsonString)tree;
                this.map.put(path, st.getString());
                break;
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)tree;
                this.map.put(path, num.toString());
                break;
            }
            case TRUE: 
            case FALSE: 
            case NULL: {
                this.map.put(path, tree.getValueType().toString());
                break;
            }
        }
    }

    public StringBuilder getFlatTree(String valueSeparator, String replaceEndOfLines) throws IllegalStateException {
        if (!this.parsed) {
            throw new IllegalStateException("JSON document has not been parsed");
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            result.append(entry.getKey()).append(valueSeparator);
            if (replaceEndOfLines != null) {
                result.append(entry.getValue().replace("\n", replaceEndOfLines)).append("\n");
                continue;
            }
            result.append(entry.getValue()).append("\n");
        }
        return result;
    }

    public StringBuilder getFlatTree(String valueSeparator) {
        return this.getFlatTree(valueSeparator, null);
    }

    public StringBuilder getFlatTree() {
        return this.getFlatTree("=", null);
    }

    public StringBuilder toCSV(String csvEntryKey, String[] csvProperties, String separator) throws IllegalStateException, IllegalArgumentException {
        int i;
        if (!this.parsed) {
            throw new IllegalStateException("JSON document has not been parsed");
        }
        if (csvEntryKey == null) {
            throw new IllegalArgumentException("Cannot convert JSON to CSV without a proper entry key (non-null)");
        }
        if (csvProperties == null) {
            csvProperties = new String[]{};
        }
        for (String property : csvProperties) {
            if (property != null) continue;
            throw new IllegalArgumentException("Cannot convert JSON to CSV without a proper list of properties (non-null)");
        }
        for (int i2 = 0; i2 < csvProperties.length; ++i2) {
            if (csvProperties[i2].startsWith("./")) {
                csvProperties[i2] = csvProperties[i2].substring(2);
            }
            while (csvProperties[i2].startsWith("/")) {
                csvProperties[i2] = csvProperties[i2].substring(1);
            }
        }
        if (separator == null) {
            separator = ";";
        }
        StringBuilder csvResult = new StringBuilder();
        if (this.map == null) {
            return csvResult;
        }
        if (this.map.size() == 0) {
            return csvResult;
        }
        if (csvEntryKey.isEmpty()) {
            csvEntryKey = "/";
        }
        if (!csvEntryKey.startsWith("/")) {
            csvEntryKey = "/" + csvEntryKey;
        }
        ArrayList<String> entries = new ArrayList<String>();
        String[] pathElementArray = csvEntryKey.split("/");
        int arrayLength = 0;
        for (i = 0; i < this.arrayPaths.size(); ++i) {
            if (!"".equals(this.arrayPaths.get(i))) continue;
            arrayLength = this.arrayLengths.get(i);
            break;
        }
        if (arrayLength > 0) {
            for (i = 0; i < arrayLength; ++i) {
                entries.add("[" + i + "]");
            }
        } else {
            entries.add("/");
        }
        for (String pathElement : pathElementArray) {
            if (pathElement == null || pathElement.isEmpty()) continue;
            ArrayList<String> newEntries = new ArrayList<String>();
            for (String existingEntry : entries) {
                int i3;
                String path = existingEntry.equals("/") ? "/" + pathElement : existingEntry + "/" + pathElement;
                arrayLength = 0;
                for (i3 = 0; i3 < this.arrayPaths.size(); ++i3) {
                    if (!path.equalsIgnoreCase(this.arrayPaths.get(i3))) continue;
                    arrayLength = this.arrayLengths.get(i3);
                    break;
                }
                if (arrayLength > 0) {
                    for (i3 = 0; i3 < arrayLength; ++i3) {
                        newEntries.add(path + "[" + i3 + "]");
                    }
                    continue;
                }
                newEntries.add(path);
            }
            entries = newEntries;
        }
        for (String entry : entries) {
            if (!this.map.containsKey(entry)) continue;
            csvResult.append(this.map.floorKey(entry)).append(separator);
            if (entry.equals("/")) {
                entry = "";
            }
            for (String property : csvProperties) {
                String path = property.equals(".") ? entry : entry + "/" + property;
                while (path.contains("/../")) {
                    int pos2 = path.indexOf("/../");
                    int pos1 = path.lastIndexOf("/", pos2 - 1);
                    path = path.substring(0, pos1) + path.substring(pos2 + 3);
                }
                String value = this.map.get(path);
                if (value == null) {
                    value = "";
                }
                csvResult.append(value).append(separator);
            }
            csvResult.append("\n");
        }
        return csvResult;
    }
}

