/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Locale;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.sentrysoftware.jawk.util.ScriptFileSource;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwkParameters {
    private static final Logger LOG;
    private static final String JAR_NAME;

    public static AwkSettings parseCommandLineArguments(String[] args) {
        int argIdx;
        AwkSettings settings = new AwkSettings();
        try {
            for (argIdx = 0; argIdx < args.length; ++argIdx) {
                assert (args[argIdx] != null);
                if (args[argIdx].length() == 0) {
                    throw new IllegalArgumentException("zero-length argument at position " + (argIdx + 1));
                }
                if (args[argIdx].charAt(0) != '-') break;
                if (args[argIdx].equals("-")) {
                    ++argIdx;
                    break;
                }
                if (args[argIdx].equals("-v")) {
                    AwkParameters.checkParameterHasArgument(args, argIdx);
                    AwkParameters.checkInitialVariableFormat(args[++argIdx]);
                    AwkParameters.addVariable(settings, args[argIdx]);
                    continue;
                }
                if (args[argIdx].equals("-f")) {
                    AwkParameters.checkParameterHasArgument(args, argIdx);
                    settings.addScriptSource(new ScriptFileSource(args[++argIdx]));
                    continue;
                }
                if (args[argIdx].equals("-c")) {
                    settings.setWriteIntermediateFile(true);
                    continue;
                }
                if (args[argIdx].equals("-o")) {
                    AwkParameters.checkParameterHasArgument(args, argIdx);
                    settings.setOutputFilename(args[++argIdx]);
                    continue;
                }
                if (args[argIdx].equals("-S")) {
                    settings.setDumpSyntaxTree(true);
                    continue;
                }
                if (args[argIdx].equals("-s")) {
                    settings.setDumpIntermediateCode(true);
                    continue;
                }
                if (args[argIdx].equals("-x")) {
                    settings.setAdditionalFunctions(true);
                    continue;
                }
                if (args[argIdx].equals("-y")) {
                    settings.setAdditionalTypeFunctions(true);
                    continue;
                }
                if (args[argIdx].equals("-t")) {
                    settings.setUseSortedArrayKeys(true);
                    continue;
                }
                if (args[argIdx].equals("-r")) {
                    settings.setCatchIllegalFormatExceptions(false);
                    continue;
                }
                if (args[argIdx].equals("-F")) {
                    AwkParameters.checkParameterHasArgument(args, argIdx);
                    settings.setFieldSeparator(args[++argIdx]);
                    continue;
                }
                if (args[argIdx].equals("--locale")) {
                    AwkParameters.checkParameterHasArgument(args, argIdx);
                    settings.setLocale(new Locale(args[++argIdx]));
                    continue;
                }
                if (args[argIdx].equals("-ext")) {
                    settings.setUserExtensions(true);
                    continue;
                }
                if (args[argIdx].equals("-ni")) {
                    settings.setUseStdIn(true);
                    continue;
                }
                if (args[argIdx].equals("-h") || args[argIdx].equals("-?")) {
                    if (args.length > 1) {
                        throw new IllegalArgumentException("When printing help/usage output, we do not accept other arguments.");
                    }
                    AwkParameters.usage(System.out);
                    System.exit(0);
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter: " + args[argIdx]);
            }
            if (settings.getScriptSources().isEmpty()) {
                if (argIdx >= args.length) {
                    throw new IllegalArgumentException("Awk script not provided.");
                }
                String scriptContent = args[argIdx++];
                settings.addScriptSource(new ScriptSource("<command-line-supplied-script>", new StringReader(scriptContent), false));
            } else {
                for (ScriptSource scriptSource : settings.getScriptSources()) {
                    try {
                        if (scriptSource.isIntermediate()) {
                            scriptSource.getInputStream();
                            continue;
                        }
                        scriptSource.getReader();
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to read script '" + scriptSource.getDescription() + "'", (Throwable)ex);
                        System.exit(1);
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Failed to parse arguments. Please see the help/usage output (cmd line switch '-h').", (Throwable)iae);
            System.exit(1);
        }
        while (argIdx < args.length) {
            String nameValueOrFileName = args[argIdx++];
            settings.getNameValueOrFileNames().add(nameValueOrFileName);
        }
        return settings;
    }

    private static void usage(PrintStream dest) {
        dest.println("Usage:");
        dest.println("java -jar " + JAR_NAME + " [-F fs_val] [-f script-filename] [-o output-filename] [-c] [-S] [-s] [-x] [-y] [-r] [--locale locale] [-ext] [-ni] [-t] [-v name=val]... [script] [name=val | input_filename]...");
        dest.println();
        dest.println(" -F fs_val = Use fs_val for FS.");
        dest.println(" -f filename = Use contents of filename for script.");
        dest.println(" -v name=val = Initial awk variable assignments.");
        dest.println();
        dest.println(" -t = (extension) Maintain array keys in sorted order.");
        dest.println(" -c = (extension) Compile to intermediate file. (default: a.ai)");
        dest.println(" -o = (extension) Specify output file.");
        dest.println(" -S = (extension) Write the syntax tree to file. (default: syntax_tree.lst)");
        dest.println(" -s = (extension) Write the intermediate code to file. (default: avm.lst)");
        dest.println(" -x = (extension) Enable _sleep, _dump as keywords, and exec as a builtin func.");
        dest.println(" -y = (extension) Enable _INTEGER, _DOUBLE, and _STRING casting keywords.");
        dest.println(" -r = (extension) Do NOT hide IllegalFormatExceptions for [s]printf.");
        dest.println(" --locale Locale = (extension) Specify a locale to be used instead of US-English");
        dest.println("-ext= (extension) Enable user-defined extensions. (default: not enabled)");
        dest.println("-ni = (extension) Do NOT process stdin or ARGC/V through input rules.");
        dest.println("                  (Useful for blocking extensions.)");
        dest.println();
        dest.println(" -h or -? = (extension) This help screen.");
    }

    private static void checkParameterHasArgument(String[] args, int argIdx) {
        assert (argIdx < args.length);
        assert (args[argIdx].charAt(0) == '-');
        if (argIdx + 1 >= args.length) {
            throw new IllegalArgumentException("Need additional argument for " + args[argIdx]);
        }
    }

    private static void checkInitialVariableFormat(String keyValue) {
        int equalsCount = 0;
        int length = keyValue.length();
        for (int i = 0; equalsCount <= 1 && i < length; ++i) {
            if (keyValue.charAt(i) != '=') continue;
            ++equalsCount;
        }
        if (equalsCount != 1) {
            throw new IllegalArgumentException("keyValue \"" + keyValue + "\" must be of the form \"name=value\"");
        }
    }

    private static void addVariable(AwkSettings settings, String keyValue) {
        Object value;
        int equalsIdx = keyValue.indexOf(61);
        assert (equalsIdx >= 0);
        String name = keyValue.substring(0, equalsIdx);
        String valueString = keyValue.substring(equalsIdx + 1);
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (NumberFormatException nfe2) {
                value = valueString;
            }
        }
        settings.getVariables().put(name, value);
    }

    static {
        String myName;
        LOG = LoggerFactory.getLogger(AwkParameters.class);
        try {
            File me = new File(AwkParameters.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            myName = me.getName();
        }
        catch (URISyntaxException e) {
            myName = "Jawk.jar";
        }
        JAR_NAME = myName;
    }
}

