/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.sentrysoftware.jawk.NotImplementedError;
import org.sentrysoftware.jawk.ext.AbstractExtension;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.jrt.BlockObject;
import org.sentrysoftware.jawk.jrt.JRT;
import org.sentrysoftware.jawk.jrt.VariableManager;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdinExtension
extends AbstractExtension
implements JawkExtension {
    private static final Logger LOG = LoggerFactory.getLogger(StdinExtension.class);
    private static final Object DONE = new Object();
    private final BlockingQueue<Object> getLineInput = new LinkedBlockingQueue<Object>();
    private final BlockObject blocker = new BlockObject(){

        @Override
        public String getNotifierTag() {
            return "Stdin";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void block() throws InterruptedException {
            BlockObject blockObject = StdinExtension.this.blocker;
            synchronized (blockObject) {
                if (StdinExtension.this.stdInHasInput() == 0) {
                    StdinExtension.this.blocker.wait();
                }
            }
        }
    };
    private boolean isEof = false;

    @Override
    public void init(VariableManager vm, JRT jrt, final AwkSettings settings) {
        super.init(vm, jrt, settings);
        Thread getLineInputThread = new Thread("getLineInputThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public final void run() {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(settings.getInput()));
                    while ((line = br.readLine()) != null) {
                        StdinExtension.this.getLineInput.put(line);
                        BlockObject blockObject = StdinExtension.this.blocker;
                        synchronized (blockObject) {
                            StdinExtension.this.blocker.notify();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    LOG.error("", (Throwable)ie);
                }
                catch (IOException ioe) {
                    LOG.error("", (Throwable)ioe);
                }
                try {
                    StdinExtension.this.getLineInput.put(DONE);
                }
                catch (InterruptedException ie) {
                    LOG.error("Should never be interrupted.", (Throwable)ie);
                    System.exit(1);
                }
                BlockObject blockObject = StdinExtension.this.blocker;
                synchronized (blockObject) {
                    StdinExtension.this.blocker.notify();
                    return;
                }
            }
        };
        getLineInputThread.setDaemon(true);
        getLineInputThread.start();
    }

    @Override
    public String getExtensionName() {
        return "Stdin Support";
    }

    @Override
    public String[] extensionKeywords() {
        return new String[]{"StdinHasInput", "StdinGetline", "StdinBlock"};
    }

    @Override
    public Object invoke(String keyword, Object[] args) {
        if (keyword.equals("StdinHasInput")) {
            StdinExtension.checkNumArgs(args, 0);
            return this.stdInHasInput();
        }
        if (keyword.equals("StdinGetline")) {
            StdinExtension.checkNumArgs(args, 0);
            return this.stdInGetLine();
        }
        if (keyword.equals("StdinBlock")) {
            if (args.length == 0) {
                return this.stdInBlock();
            }
            if (args.length == 1) {
                return this.stdInBlock((BlockObject)args[0]);
            }
            throw new IllegalArgumentException("StdinBlock accepts 0 or 1 args.");
        }
        throw new NotImplementedError(keyword);
    }

    private int stdInHasInput() {
        if (this.isEof) {
            return 1;
        }
        if (this.getLineInput.size() == 0) {
            return 0;
        }
        if (this.getLineInput.size() == 1 && this.getLineInput.peek() == DONE) {
            return 0;
        }
        return 1;
    }

    private Object stdInGetLine() {
        try {
            if (this.isEof) {
                return 0;
            }
            Object lineObj = this.getLineInput.take();
            if (lineObj == DONE) {
                this.isEof = true;
                return 0;
            }
            this.getJrt().setInputLine((String)lineObj);
            this.getJrt().jrtParseFields();
            return 1;
        }
        catch (InterruptedException ie) {
            LOG.warn("", (Throwable)ie);
            return -1;
        }
    }

    private BlockObject stdInBlock() {
        this.blocker.clearNextBlockObject();
        return this.blocker;
    }

    private BlockObject stdInBlock(BlockObject bo) {
        assert (bo != null);
        this.blocker.setNextBlockObject(bo);
        return this.blocker;
    }
}

