/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IWinConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WbemConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WqlCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.wbem.client.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WqlDetectionHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqlDetectionHelper.class);
    private static final String INTEROP_LOWER_CASE = "interop";
    private static final String SELECT_NAME_FROM_CIM_NAMESPACE = "SELECT Name from CIM_Namespace";
    private static final String ROOT_SLASH = "root/";
    private ClientsExecutor clientsExecutor;
    private static final Set<String> IGNORED_WMI_NAMESPACES = Set.of("SECURITY", "RSOP", "Cli", "aspnet", "SecurityCenter", "WMI", "Policy", "DEFAULT", "directory", "subscription", "vm", "perform", "MSCluster", "MicrosoftActiveDirectory", "MicrosoftNLB", "Microsoft", "ServiceModel", "nap");
    private static final List<WqlQuery> WBEM_INTEROP_QUERIES = List.of(new WqlQuery("SELECT Name FROM __NAMESPACE", "root"), new WqlQuery("SELECT Name from CIM_Namespace", "Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "PG_Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "root/Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "root/PG_Interop"), new WqlQuery("SELECT Name from CIM_Namespace", "interop"));
    private static final Set<String> IGNORED_WBEM_NAMESPACES = Set.of("root", "/root");

    public WqlDetectionHelper(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    public PossibleNamespacesResult findPossibleNamespaces(String hostname, WbemConfiguration configuration) {
        if (configuration.getNamespace() != null && !configuration.getNamespace().isBlank()) {
            return PossibleNamespacesResult.builder().possibleNamespaces(Collections.singleton(configuration.getNamespace())).success(true).build();
        }
        TreeSet<String> possibleWbemNamespaces = new TreeSet<String>();
        for (WqlQuery interopQuery : WBEM_INTEROP_QUERIES) {
            try {
                this.clientsExecutor.executeWbem(hostname, configuration, interopQuery.getWql(), interopQuery.getNamespace()).stream().filter(row -> !row.isEmpty()).map(row -> (String)row.get(0)).filter(Objects::nonNull).filter(namespace -> !namespace.isBlank()).filter(namespace -> !namespace.toLowerCase().contains(INTEROP_LOWER_CASE)).filter(namespace -> !IGNORED_WBEM_NAMESPACES.contains(namespace)).map(namespace -> ROOT_SLASH + namespace).forEach(namespace -> possibleWbemNamespaces.add((String)namespace));
            }
            catch (ClientException e) {
                if (WqlDetectionHelper.isAcceptableException(e)) continue;
                Throwable cause = e.getCause();
                String messageFormat = "Hostname %s - Does not respond to WBEM requests. %s: %s\nCancelling namespace detection.";
                String message = String.format("Hostname %s - Does not respond to WBEM requests. %s: %s\nCancelling namespace detection.", hostname, cause != null ? cause.getClass().getSimpleName() : e.getClass().getSimpleName(), cause != null ? cause.getMessage() : e.getMessage());
                log.debug(message);
                return PossibleNamespacesResult.builder().errorMessage(message).success(false).build();
            }
        }
        if (possibleWbemNamespaces.isEmpty()) {
            return PossibleNamespacesResult.builder().errorMessage("No suitable namespace could be found to query host " + hostname + ".").success(false).build();
        }
        return PossibleNamespacesResult.builder().possibleNamespaces(possibleWbemNamespaces).success(true).build();
    }

    public PossibleNamespacesResult findPossibleNamespaces(String hostname, IWinConfiguration configuration) {
        if (configuration.getNamespace() != null && !configuration.getNamespace().isBlank()) {
            return PossibleNamespacesResult.builder().possibleNamespaces(Collections.singleton(configuration.getNamespace())).success(true).build();
        }
        TreeSet<String> possibleWmiNamespaces = new TreeSet<String>();
        try {
            this.clientsExecutor.executeWql(hostname, configuration, "SELECT Name FROM __NAMESPACE", "root").stream().filter(row -> !row.isEmpty()).map(row -> (String)row.get(0)).filter(Objects::nonNull).filter(namespace -> !namespace.isBlank()).filter(namespace -> !namespace.toLowerCase().contains(INTEROP_LOWER_CASE)).filter(namespace -> !IGNORED_WMI_NAMESPACES.contains(namespace)).filter(namespace -> IGNORED_WMI_NAMESPACES.stream().noneMatch(ignoredNamespace -> (ROOT_SLASH + ignoredNamespace).equalsIgnoreCase((String)namespace))).filter(namespace -> IGNORED_WMI_NAMESPACES.stream().noneMatch(ignoredNamespace -> ("root\\" + ignoredNamespace).equalsIgnoreCase((String)namespace))).map(namespace -> ROOT_SLASH + namespace).forEach(possibleWmiNamespaces::add);
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            String message = String.format("Hostname %s - Does not respond to WMI requests. %s: %s\nCancelling namespace detection.", hostname, cause != null ? cause.getClass().getSimpleName() : e.getClass().getSimpleName(), cause != null ? cause.getMessage() : e.getMessage());
            log.debug(message);
            return PossibleNamespacesResult.builder().errorMessage(message).success(false).build();
        }
        if (possibleWmiNamespaces.isEmpty()) {
            return PossibleNamespacesResult.builder().errorMessage("No suitable namespace could be found to query host " + hostname + ".").success(false).build();
        }
        return PossibleNamespacesResult.builder().possibleNamespaces(possibleWmiNamespaces).success(true).build();
    }

    public NamespaceResult detectNamespace(String hostname, IConfiguration configuration, WqlCriterion criterion, Set<String> possibleNamespaces) {
        TreeMap<String, CriterionTestResult> namespaces = new TreeMap<String, CriterionTestResult>();
        WqlCriterion tentativeCriterion = criterion.copy();
        for (String namespace : possibleNamespaces) {
            tentativeCriterion.setNamespace(namespace);
            CriterionTestResult testResult = this.performDetectionTest(hostname, configuration, tentativeCriterion);
            if (testResult.isSuccess()) {
                namespaces.put(namespace, testResult);
                continue;
            }
            Throwable e = testResult.getException();
            if (e == null || WqlDetectionHelper.isAcceptableException(e)) continue;
            log.debug("Hostname %s - Does not respond to %s requests. %s: %s\nCancelling namespace detection.", new Object[]{hostname, criterion.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage()});
            return NamespaceResult.builder().result(testResult).build();
        }
        if (namespaces.isEmpty()) {
            String formattedNamespaceList = possibleNamespaces.stream().collect(Collectors.joining("\n- "));
            return NamespaceResult.builder().result(CriterionTestResult.failure(criterion, "None of the possible namespaces match the criterion:" + formattedNamespaceList)).build();
        }
        if (namespaces.size() > 1) {
            namespaces.remove("root/cimv2");
            namespaces.remove("root\\cimv2");
        }
        String detectedNamespace = (String)namespaces.keySet().stream().findFirst().orElseThrow();
        return NamespaceResult.builder().namespace(detectedNamespace).result((CriterionTestResult)namespaces.get(detectedNamespace)).build();
    }

    public CriterionTestResult performDetectionTest(String hostname, @NonNull IConfiguration configuration, @NonNull WqlCriterion criterion) {
        List<List<String>> queryResult;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (criterion == null) {
            throw new IllegalArgumentException("criterion is marked non-null but is null");
        }
        try {
            queryResult = this.clientsExecutor.executeWql(hostname, configuration, criterion.getQuery(), criterion.getNamespace());
        }
        catch (ClientException e) {
            return CriterionTestResult.error((Criterion)criterion, e);
        }
        String actualResult = SourceTable.tableToCsv(queryResult, ";", true);
        if (actualResult == null || actualResult.isBlank()) {
            return CriterionTestResult.failure(criterion, "No result.");
        }
        if (criterion.getExpectedResult() == null || criterion.getExpectedResult().isBlank()) {
            return CriterionTestResult.success(criterion, actualResult);
        }
        Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex(criterion.getExpectedResult()), 10).matcher(actualResult);
        if (matcher.find()) {
            return CriterionTestResult.success(criterion, matcher.group());
        }
        return CriterionTestResult.failure(criterion, actualResult);
    }

    public static boolean isAcceptableException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WBEMException) {
            WBEMException wbemException = (WBEMException)t;
            int cimErrorType = wbemException.getID();
            return WqlDetectionHelper.isAcceptableWbemError(cimErrorType);
        }
        if (t instanceof WmiComException) {
            String message = t.getMessage();
            return WqlDetectionHelper.isAcceptableWmiComError(message);
        }
        if (t instanceof WqlQuerySyntaxException || t instanceof org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException || t instanceof org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException) {
            return true;
        }
        return WqlDetectionHelper.isAcceptableException(t.getCause());
    }

    private static boolean isAcceptableWmiComError(String errorMessage) {
        return errorMessage != null && (errorMessage.contains("WBEM_E_NOT_FOUND") || errorMessage.contains("WBEM_E_INVALID_NAMESPACE") || errorMessage.contains("WBEM_E_INVALID_CLASS"));
    }

    private static boolean isAcceptableWbemError(int errorId) {
        return errorId == 3 || errorId == 5 || errorId == 6;
    }

    public static class PossibleNamespacesResult {
        private Set<String> possibleNamespaces;
        private boolean success;
        private String errorMessage;

        @Generated
        PossibleNamespacesResult(Set<String> possibleNamespaces, boolean success, String errorMessage) {
            this.possibleNamespaces = possibleNamespaces;
            this.success = success;
            this.errorMessage = errorMessage;
        }

        @Generated
        public static PossibleNamespacesResultBuilder builder() {
            return new PossibleNamespacesResultBuilder();
        }

        @Generated
        public Set<String> getPossibleNamespaces() {
            return this.possibleNamespaces;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public void setPossibleNamespaces(Set<String> possibleNamespaces) {
            this.possibleNamespaces = possibleNamespaces;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PossibleNamespacesResult)) {
                return false;
            }
            PossibleNamespacesResult other = (PossibleNamespacesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Set<String> this$possibleNamespaces = this.getPossibleNamespaces();
            Set<String> other$possibleNamespaces = other.getPossibleNamespaces();
            if (this$possibleNamespaces == null ? other$possibleNamespaces != null : !((Object)this$possibleNamespaces).equals(other$possibleNamespaces)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PossibleNamespacesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Set<String> $possibleNamespaces = this.getPossibleNamespaces();
            result = result * 59 + ($possibleNamespaces == null ? 43 : ((Object)$possibleNamespaces).hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WqlDetectionHelper.PossibleNamespacesResult(possibleNamespaces=" + String.valueOf(this.getPossibleNamespaces()) + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ")";
        }

        @Generated
        public static class PossibleNamespacesResultBuilder {
            @Generated
            private Set<String> possibleNamespaces;
            @Generated
            private boolean success;
            @Generated
            private String errorMessage;

            @Generated
            PossibleNamespacesResultBuilder() {
            }

            @Generated
            public PossibleNamespacesResultBuilder possibleNamespaces(Set<String> possibleNamespaces) {
                this.possibleNamespaces = possibleNamespaces;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            @Generated
            public PossibleNamespacesResultBuilder errorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
                return this;
            }

            @Generated
            public PossibleNamespacesResult build() {
                return new PossibleNamespacesResult(this.possibleNamespaces, this.success, this.errorMessage);
            }

            @Generated
            public String toString() {
                return "WqlDetectionHelper.PossibleNamespacesResult.PossibleNamespacesResultBuilder(possibleNamespaces=" + String.valueOf(this.possibleNamespaces) + ", success=" + this.success + ", errorMessage=" + this.errorMessage + ")";
            }
        }
    }

    private static class WqlQuery {
        private String wql;
        private String namespace;

        WqlQuery(String wql, String namespace) {
            this.wql = wql;
            this.namespace = namespace;
        }

        @Generated
        public String getWql() {
            return this.wql;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public void setWql(String wql) {
            this.wql = wql;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WqlQuery)) {
                return false;
            }
            WqlQuery other = (WqlQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$wql = this.getWql();
            String other$wql = other.getWql();
            if (this$wql == null ? other$wql != null : !this$wql.equals(other$wql)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WqlQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $wql = this.getWql();
            result = result * 59 + ($wql == null ? 43 : $wql.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WqlDetectionHelper.WqlQuery(wql=" + this.getWql() + ", namespace=" + this.getNamespace() + ")";
        }
    }

    public static class NamespaceResult {
        private String namespace;
        private CriterionTestResult result;

        @Generated
        NamespaceResult(String namespace, CriterionTestResult result) {
            this.namespace = namespace;
            this.result = result;
        }

        @Generated
        public static NamespaceResultBuilder builder() {
            return new NamespaceResultBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public CriterionTestResult getResult() {
            return this.result;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public void setResult(CriterionTestResult result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamespaceResult)) {
                return false;
            }
            NamespaceResult other = (NamespaceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            CriterionTestResult this$result = this.getResult();
            CriterionTestResult other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NamespaceResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            CriterionTestResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WqlDetectionHelper.NamespaceResult(namespace=" + this.getNamespace() + ", result=" + String.valueOf(this.getResult()) + ")";
        }

        @Generated
        public static class NamespaceResultBuilder {
            @Generated
            private String namespace;
            @Generated
            private CriterionTestResult result;

            @Generated
            NamespaceResultBuilder() {
            }

            @Generated
            public NamespaceResultBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public NamespaceResultBuilder result(CriterionTestResult result) {
                this.result = result;
                return this;
            }

            @Generated
            public NamespaceResult build() {
                return new NamespaceResult(this.namespace, this.result);
            }

            @Generated
            public String toString() {
                return "WqlDetectionHelper.NamespaceResult.NamespaceResultBuilder(namespace=" + this.namespace + ", result=" + String.valueOf(this.result) + ")";
            }
        }
    }
}

