/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.ClientRuntimeException;
import org.sentrysoftware.metricshub.engine.common.exception.ControlledSshException;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IWinConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.OsCommandConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SshConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.telemetry.SshSemaphoreFactory;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.springframework.util.Assert;

public class OsCommandHelper {
    private static final String NEGATIVE_TIMEOUT = "timeout mustn't be negative nor zero.";
    private static final Pattern SUDO_COMMAND_PATTERN = Pattern.compile("%\\{SUDO:([^\\}]*)\\}", 2);
    static final Function<String, File> TEMP_FILE_CREATOR = OsCommandHelper::createEmbeddedTempFile;

    public static Map<String, File> createOsCommandEmbeddedFiles(@NonNull String commandLine, OsCommandConfiguration osCommandConfiguration, @NonNull Map<String, EmbeddedFile> commandLineEmbeddedFiles, Function<String, File> tempFileCreator) throws IOException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (commandLineEmbeddedFiles == null) {
            throw new IllegalArgumentException("commandLineEmbeddedFiles is marked non-null but is null");
        }
        HashMap<String, File> embeddedTempFiles = new HashMap<String, File>();
        try {
            Matcher matcher = MetricsHubConstants.FILE_PATTERN.matcher(commandLine);
            while (matcher.find()) {
                String fileName = matcher.group(1);
                String fileNameRef = matcher.group();
                embeddedTempFiles.computeIfAbsent(fileNameRef, k -> {
                    EmbeddedFile embeddedFile = (EmbeddedFile)commandLineEmbeddedFiles.get(fileNameRef);
                    Assert.state((embeddedFile != null ? 1 : 0) != 0, () -> "Cannot get the EmbeddedFile from the Connector. File name: " + fileName);
                    String content = embeddedFile.getContent();
                    Assert.state((content != null ? 1 : 0) != 0, () -> "EmbeddedFile content is null. File name: " + fileName);
                    try {
                        return OsCommandHelper.createTempFileWithEmbeddedFileContent(embeddedFile, osCommandConfiguration, tempFileCreator);
                    }
                    catch (IOException e) {
                        throw new TempFileCreationException(e);
                    }
                });
            }
            return Collections.unmodifiableMap(embeddedTempFiles);
        }
        catch (Exception e) {
            embeddedTempFiles.values().forEach(File::delete);
            if (e instanceof TempFileCreationException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    static File createTempFileWithEmbeddedFileContent(EmbeddedFile embeddedFile, OsCommandConfiguration osCommandConfiguration, Function<String, File> tempFileCreator) throws IOException {
        String extension = embeddedFile.getType() != null ? "." + embeddedFile.getType() : "";
        File tempFile = tempFileCreator.apply(extension);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(tempFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(OsCommandHelper.replaceSudo(embeddedFile.getContent(), osCommandConfiguration));
        }
        return tempFile;
    }

    static File createEmbeddedTempFile(String extension) {
        try {
            return File.createTempFile("SEN_Embedded_", extension);
        }
        catch (IOException e) {
            throw new TempFileCreationException(e);
        }
    }

    static String replaceSudo(String text, OsCommandConfiguration osCommandConfiguration) {
        if (text == null || text.isBlank()) {
            return text;
        }
        Optional<String> maybeSudoFile = OsCommandHelper.getFileNameFromSudoCommand(text);
        String sudoReplace = maybeSudoFile.isPresent() && osCommandConfiguration != null && osCommandConfiguration.isUseSudo() && osCommandConfiguration.getUseSudoCommands().contains(maybeSudoFile.get()) ? osCommandConfiguration.getSudoCommand() : "";
        return maybeSudoFile.map(fileName -> text.replaceAll(OsCommandHelper.toCaseInsensitiveRegex(String.format("%%{SUDO:%s}", fileName)), sudoReplace)).orElse(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WithSpan(value="OS Command")
    public static String runLocalCommand(@NonNull String command, @SpanAttribute(value="OSCommand.timeout") long timeout, @SpanAttribute(value="OSCommand.command") String noPasswordCommand) throws InterruptedException, IOException, TimeoutException {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)NEGATIVE_TIMEOUT);
        Object cmd = LocalOsHandler.isWindows() ? "CMD.EXE /C " + command : command;
        Process process = Runtime.getRuntime().exec((String)cmd);
        if (process == null) {
            throw new IllegalStateException("Local command Process is null.");
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> future = executor.submit(() -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    StringJoiner stringJoiner = new StringJoiner("\n");
                    while ((line = bufferedReader.readLine()) != null) {
                        stringJoiner.add(line);
                    }
                    process.waitFor();
                    string = stringJoiner.toString();
                }
                return string;
            }
        });
        try {
            String string = future.get(timeout, TimeUnit.SECONDS);
            return string;
        }
        catch (TimeoutException exception) {
            future.cancel(true);
            throw new TimeoutException(String.format("Command \"%s\" execution has timed out after %d s", noPasswordCommand != null ? noPasswordCommand : command, timeout));
        }
        catch (ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            String string = null;
            return string;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static String runSshCommand(@NonNull String command, @NonNull String hostname, @NonNull SshConfiguration sshConfiguration, long timeout, List<File> localFiles, String noPasswordCommand) throws ClientException, InterruptedException, ControlledSshException {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (sshConfiguration == null) {
            throw new IllegalArgumentException("sshConfiguration is marked non-null but is null");
        }
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)NEGATIVE_TIMEOUT);
        try {
            return OsCommandHelper.runControlledSshCommand(() -> {
                try {
                    return ClientsExecutor.runRemoteSshCommand(hostname, sshConfiguration.getUsername(), sshConfiguration.getPassword(), sshConfiguration.getPrivateKey(), command, timeout, localFiles, noPasswordCommand);
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException(e);
                }
            }, hostname, 120);
        }
        catch (ClientRuntimeException e) {
            throw (ClientException)e.getCause();
        }
    }

    static <T> T runControlledSshCommand(Supplier<T> executable, String hostname, int timeout) throws InterruptedException, ControlledSshException {
        Semaphore semaphore = SshSemaphoreFactory.getInstance().createOrGetSempahore(hostname);
        try {
            if (semaphore.tryAcquire(timeout, TimeUnit.SECONDS)) {
                T t = executable.get();
                return t;
            }
            String message = String.format("Failed to run SSH command on %s. Timed out trying to get ssh semaphore permit.", hostname);
            throw new ControlledSshException(message);
        }
        finally {
            semaphore.release();
        }
    }

    static Optional<String> getFileNameFromSudoCommand(@NonNull String command) {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        Matcher matcher = SUDO_COMMAND_PATTERN.matcher(command);
        return matcher.find() ? Optional.ofNullable(matcher.group(1)) : Optional.empty();
    }

    public static String toCaseInsensitiveRegex(String host) {
        Assert.isTrue((host != null && !host.isEmpty() ? 1 : 0) != 0, (String)"host cannot be null nor empty.");
        return host.isBlank() ? host : "(?i)" + Pattern.quote(host);
    }

    public static long getTimeout(Long commandTimeout, OsCommandConfiguration osCommandConfiguration, IConfiguration configuration, long defaultTimeout) {
        Long l;
        if (commandTimeout != null) {
            return commandTimeout.intValue();
        }
        if (osCommandConfiguration != null && osCommandConfiguration.getTimeout() != null) {
            return osCommandConfiguration.getTimeout().intValue();
        }
        if (configuration == null) {
            return defaultTimeout;
        }
        if (configuration instanceof IWinConfiguration) {
            IWinConfiguration winConfiguration = (IWinConfiguration)configuration;
            l = winConfiguration.getTimeout();
        } else {
            l = ((SshConfiguration)configuration).getTimeout();
        }
        Long timeout = l;
        return timeout != null ? timeout : defaultTimeout;
    }

    public static Optional<String> getUsername(IConfiguration configuration) {
        if (configuration == null) {
            return Optional.empty();
        }
        if (configuration instanceof IWinConfiguration) {
            IWinConfiguration winConfiguration = (IWinConfiguration)configuration;
            return Optional.ofNullable(winConfiguration.getUsername());
        }
        if (configuration instanceof SshConfiguration) {
            SshConfiguration sshConfiguration = (SshConfiguration)configuration;
            return Optional.ofNullable(sshConfiguration.getUsername());
        }
        return Optional.empty();
    }

    public static Optional<char[]> getPassword(IConfiguration protocolConfiguration) {
        if (protocolConfiguration == null) {
            return Optional.empty();
        }
        if (protocolConfiguration instanceof IWinConfiguration) {
            IWinConfiguration winConfiguration = (IWinConfiguration)protocolConfiguration;
            return Optional.ofNullable(winConfiguration.getPassword());
        }
        if (protocolConfiguration instanceof SshConfiguration) {
            SshConfiguration sshConfiguration = (SshConfiguration)protocolConfiguration;
            return Optional.ofNullable(sshConfiguration.getPassword());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OsCommandResult runOsCommand(@NonNull String commandLine, @NonNull TelemetryManager telemetryManager, Long commandTimeout, boolean isExecuteLocally, boolean isLocalhost) throws IOException, ClientException, InterruptedException, TimeoutException, NoCredentialProvidedException, ControlledSshException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        IConfiguration configuration = !isLocalhost && telemetryManager.getHostConfiguration().getHostType() == DeviceKind.WINDOWS ? telemetryManager.getWinConfiguration() : telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        Optional<String> maybeUsername = OsCommandHelper.getUsername(configuration);
        if ((maybeUsername.isEmpty() || maybeUsername.get().isBlank()) && !isExecuteLocally && !isLocalhost) {
            throw new NoCredentialProvidedException();
        }
        Optional<char[]> maybePassword = OsCommandHelper.getPassword(configuration);
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        OsCommandConfiguration osCommandConfiguration = (OsCommandConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class);
        Map<String, File> embeddedTempFiles = OsCommandHelper.createOsCommandEmbeddedFiles(commandLine, osCommandConfiguration, EmbeddedFileHelper.findEmbeddedFiles(commandLine), TEMP_FILE_CREATOR);
        String updatedUserCommand = maybeUsername.map(username -> commandLine.replaceAll(OsCommandHelper.toCaseInsensitiveRegex("%{USERNAME}"), (String)username)).orElse(commandLine);
        String updatedHostnameCommand = updatedUserCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex("%{HOSTNAME}"), hostname);
        String updatedSudoCommand = OsCommandHelper.replaceSudo(updatedHostnameCommand, osCommandConfiguration);
        String updatedEmbeddedFilesCommand = embeddedTempFiles.entrySet().stream().reduce(updatedSudoCommand, (s, entry) -> s.replaceAll(OsCommandHelper.toCaseInsensitiveRegex((String)entry.getKey()), Matcher.quoteReplacement(((File)entry.getValue()).getAbsolutePath())), (s1, s2) -> null);
        String command = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex("%{PASSWORD}"), String.valueOf(password))).orElse(updatedEmbeddedFilesCommand);
        String noPasswordCommand = maybePassword.map(password -> updatedEmbeddedFilesCommand.replaceAll(OsCommandHelper.toCaseInsensitiveRegex("%{PASSWORD}"), "********")).orElse(updatedEmbeddedFilesCommand);
        try {
            String localCommandResult;
            long timeout = OsCommandHelper.getTimeout(commandTimeout, osCommandConfiguration, configuration, telemetryManager.getHostConfiguration().getStrategyTimeout());
            String commandResult = isLocalhost || isExecuteLocally ? ((localCommandResult = OsCommandHelper.runLocalCommand(command, timeout, noPasswordCommand)) != null ? localCommandResult : "") : (DeviceKind.WINDOWS.equals((Object)telemetryManager.getHostConfiguration().getHostType()) ? ClientsExecutor.executeWinRemoteCommand(hostname, configuration, command, embeddedTempFiles.values().stream().map(File::getAbsolutePath).collect(Collectors.toList())) : OsCommandHelper.runSshCommand(command, hostname, (SshConfiguration)configuration, timeout, new ArrayList<File>(embeddedTempFiles.values()), noPasswordCommand));
            OsCommandResult osCommandResult = new OsCommandResult(commandResult, noPasswordCommand);
            return osCommandResult;
        }
        finally {
            embeddedTempFiles.values().forEach(File::delete);
        }
    }

    @Generated
    private OsCommandHelper() {
    }

    static class TempFileCreationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TempFileCreationException(IOException cause) {
            super(cause);
        }
    }
}

