/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;

public class EmbeddedFileHelper {
    public static Map<String, EmbeddedFile> findEmbeddedFiles(@NonNull String value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        HashMap<String, EmbeddedFile> embeddedFiles = new HashMap<String, EmbeddedFile>();
        ArrayList<String> alreadyProcessedFiles = new ArrayList<String>();
        Matcher fileMatcher = MetricsHubConstants.FILE_PATTERN.matcher(value);
        while (fileMatcher.find()) {
            String fileUri = fileMatcher.group(1);
            String fileNameRef = fileMatcher.group();
            if (alreadyProcessedFiles.contains(fileNameRef)) continue;
            embeddedFiles.put(fileNameRef, EmbeddedFileHelper.runNewEmbeddedFileObjectTask(URI.create(fileUri), fileNameRef));
            alreadyProcessedFiles.add(fileNameRef);
        }
        return embeddedFiles;
    }

    private static EmbeddedFile runNewEmbeddedFileObjectTask(URI fileUri, String fileNameRef) throws IOException {
        if ("jar".equals(fileUri.getScheme())) {
            try {
                return FileHelper.fileSystemTask(fileUri, Collections.emptyMap(), () -> {
                    try {
                        return EmbeddedFileHelper.newEmbeddedFileObject(fileUri, fileNameRef);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    IOException ioException = (IOException)e;
                    throw ioException;
                }
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    IOException ioException = (IOException)throwable;
                    throw ioException;
                }
                throw new IOException(e);
            }
        }
        return EmbeddedFileHelper.newEmbeddedFileObject(fileUri, fileNameRef);
    }

    private static EmbeddedFile newEmbeddedFileObject(URI fileUri, String fileNameRef) throws IOException {
        Path filePath = Paths.get(fileUri);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Can't find embedded file: " + fileUri.getPath());
        }
        return new EmbeddedFile(EmbeddedFileHelper.parseEmbeddedFile(filePath), EmbeddedFileHelper.findExtension(fileUri.toString()), fileNameRef);
    }

    static String findExtension(String uriString) {
        int separatorIndex;
        int index = uriString.lastIndexOf(46);
        if (index > (separatorIndex = Math.max(uriString.lastIndexOf(47), uriString.lastIndexOf(92)))) {
            return uriString.substring(index + 1);
        }
        return null;
    }

    private static String parseEmbeddedFile(Path filePath) throws IOException {
        return FileHelper.readFileContent(filePath);
    }

    @Generated
    private EmbeddedFileHelper() {
    }
}

